/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.misc;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureFluid;
import gregapi.render.BlockTextureMulti;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase04MultiTileEntities;
import gregapi.tileentity.data.ITileEntitySurface;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.FluidStack;

public class MultiTileEntityFluidSpring
extends TileEntityBase04MultiTileEntities
implements IMultiTileEntity.IMTE_OnRegistration,
ITileEntitySurface,
IMultiTileEntity.IMTE_IsSideSolid,
IMultiTileEntity.IMTE_GetExplosionResistance,
IMultiTileEntity.IMTE_GetBlockHardness,
IMultiTileEntity.IMTE_GetLightOpacity,
IMultiTileEntity.IMTE_SyncDataShort {
    public FluidStack mFluid = FL.Water.make(1L);
    public boolean mActive = false;
    public static MultiTileEntityRegistry MTE_REGISTRY = null;
    public static MultiTileEntityFluidSpring INSTANCE;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.spring")) {
            this.mFluid = FL.load(aNBT, "gt.spring");
        }
        if (aNBT.func_74764_b("gt.active")) {
            this.mActive = aNBT.func_74767_n("gt.active");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        FL.save(aNBT, "gt.spring", this.mFluid);
        UT.NBT.setBoolean(aNBT, "gt.active", this.mActive);
    }

    @Override
    public final NBTTagCompound writeItemNBT(NBTTagCompound aNBT) {
        aNBT = super.writeItemNBT(aNBT);
        FL.save(aNBT, "gt.spring", this.mFluid);
        return aNBT;
    }

    public static boolean setBlock(World aWorld, int aX, int aY, int aZ, FluidStack aSpring) {
        return MultiTileEntityFluidSpring.MTE_REGISTRY.mBlock.placeBlock(aWorld, aX, aY, aZ, (byte)1, INSTANCE.getMultiTileEntityID(), UT.NBT.make("gt.spring", (Object)aSpring, new Object[0]), true, false);
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        return this.getClientDataPacketShort(aSendAll, (short)this.mFluid.getFluid().getID());
    }

    @Override
    public boolean receiveDataShort(short aData, INetworkHandler aNetworkHandler) {
        this.mFluid = FL.make(FL.fluid(aData), 600L);
        return true;
    }

    @Override
    public void onRegistration(MultiTileEntityRegistry aRegistry, short aID) {
        INSTANCE = this;
        MTE_REGISTRY = aRegistry;
    }

    @Override
    public void onTick(long aTimer, boolean aIsServerSide) {
        super.onTick(aTimer, aIsServerSide);
        if (this.mFluid.amount <= 0) {
            this.mFluid.amount = 600;
        }
        if (aIsServerSide) {
            boolean tProduce = false;
            if (this.mActive) {
                tProduce = this.rng(this.mFluid.amount) == 0;
            } else if (CS.SERVER_TIME % 20L == 1L && !WD.liquid(this.getBlockAtSide((byte)1))) {
                this.mActive = true;
                tProduce = true;
            }
            if (tProduce) {
                Block tBlock = FL.BLOCKS.get(this.mFluid.getFluid().getName());
                Block tAbove = this.getBlockAtSide((byte)1);
                if (ST.invalid(tBlock)) {
                    tBlock = this.mFluid.getFluid().getBlock();
                }
                if (ST.valid(tBlock)) {
                    if (tBlock instanceof BlockFluidFinite) {
                        if (tAbove == tBlock) {
                            this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, tBlock, (int)UT.Code.bind4(this.getMetaDataAtSide((byte)1) + 8), 3);
                            tBlock.func_149674_a(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, CS.RNGSUS);
                        } else if (WD.liquid(tAbove) || tAbove.isAir((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) {
                            this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, tBlock, 7, 3);
                            tBlock.func_149674_a(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, CS.RNGSUS);
                        }
                    } else if (tAbove == tBlock) {
                        if (this.getMetaDataAtSide((byte)1) == 0) {
                            for (byte tSide : CS.ALL_SIDES_HORIZONTAL) {
                                tAbove = this.getBlock(this.field_145851_c + CS.OFFX[tSide], this.field_145848_d + 1, this.field_145849_e + CS.OFFZ[tSide]);
                                if (tAbove == tBlock) {
                                    if (0 == this.getMetaData(this.field_145851_c + CS.OFFX[tSide], this.field_145848_d + 1, this.field_145849_e + CS.OFFZ[tSide])) continue;
                                    this.field_145850_b.func_147465_d(this.field_145851_c + CS.OFFX[tSide], this.field_145848_d + 1, this.field_145849_e + CS.OFFZ[tSide], tBlock, 0, 3);
                                } else {
                                    if (!tAbove.isAir((IBlockAccess)this.field_145850_b, this.field_145851_c + CS.OFFX[tSide], this.field_145848_d + 1, this.field_145849_e + CS.OFFZ[tSide])) continue;
                                    this.field_145850_b.func_147465_d(this.field_145851_c + CS.OFFX[tSide], this.field_145848_d + 1, this.field_145849_e + CS.OFFZ[tSide], tBlock, 0, 3);
                                }
                                break;
                            }
                        } else {
                            this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, tBlock, 0, 3);
                        }
                    } else if (WD.liquid(tAbove) || tAbove.isAir((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) {
                        this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, tBlock, 0, 3);
                    }
                }
            }
        }
    }

    @Override
    public boolean setBlockBounds(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        return false;
    }

    @Override
    public int getRenderPasses(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 1;
    }

    @Override
    public ITexture getTexture(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aShouldSideBeRendered[aSide] ? BlockTextureMulti.get(BlockTextureFluid.get(this.mFluid), BlockTextureDefault.get(Textures.BlockIcons.FLUID_SPRING)) : null;
    }

    @Override
    public int getLightOpacity() {
        return 255;
    }

    @Override
    public float getExplosionResistance2() {
        return Blocks.field_150357_h.func_149638_a(null);
    }

    @Override
    public float getBlockHardness() {
        return -1.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return true;
    }

    @Override
    public boolean isSurfaceOpaque(byte aSide) {
        return true;
    }

    @Override
    public boolean isSideSolid(byte aSide) {
        return true;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.fluid.spring";
    }
}

