/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.misc;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityContainer;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityFoamable;
import gregapi.tileentity.base.TileEntityBase07Paintable;
import gregapi.util.UT;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class MultiTileEntityCFoam
extends TileEntityBase07Paintable
implements ITileEntityFoamable,
IMultiTileEntity.IMTE_GetPlayerRelativeBlockHardness,
IMultiTileEntity.IMTE_AddToolTips,
IMultiTileEntity.IMTE_OnPlaced,
IMultiTileEntity.IMTE_OnRegistration {
    public boolean mFoamDried = false;
    public boolean mOwnable = false;
    public static MultiTileEntityRegistry MTE_REGISTRY = null;
    public static MultiTileEntityCFoam INSTANCE;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.foamdried")) {
            this.mFoamDried = aNBT.func_74767_n("gt.foamdried");
        }
        if (aNBT.func_74764_b("gt.ownable")) {
            this.mOwnable = aNBT.func_74767_n("gt.ownable");
        }
        if (aNBT.func_74764_b("gt.owner") && !CS.OWNERSHIP_RESET) {
            this.mOwner = UUID.fromString(aNBT.func_74779_i("gt.owner"));
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setBoolean(aNBT, "gt.foamdried", this.mFoamDried);
        UT.NBT.setBoolean(aNBT, "gt.ownable", this.mOwnable);
        if (this.mOwner != null) {
            aNBT.func_74778_a("gt.owner", this.mOwner.toString());
        }
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        UT.NBT.setBoolean(aNBT, "gt.foamdried", this.mFoamDried);
        UT.NBT.setBoolean(aNBT, "gt.ownable", this.mOwnable);
        return super.writeItemNBT2(aNBT);
    }

    public static boolean setBlock(World aWorld, int aX, int aY, int aZ, byte aSide, EntityPlayer aPlayer, ItemStack aStack, short[] aRGB, boolean aOwned) {
        return MultiTileEntityCFoam.MTE_REGISTRY.mBlock.placeBlock(aWorld, aX, aY, aZ, aSide, INSTANCE.getMultiTileEntityID(), UT.NBT.make("gt.color", (Object)UT.Code.getRGBInt(aRGB), "gt.painted", true, "gt.ownable", aOwned, "gt.owner", aOwned && aPlayer != null ? aPlayer.func_110124_au().toString() : null), true, false);
    }

    @Override
    public void onRegistration(MultiTileEntityRegistry aRegistry, short aID) {
        INSTANCE = this;
        MTE_REGISTRY = aRegistry;
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        if (this.mOwnable) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.owner.controlled"));
        }
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide && aTimer >= 100L && !this.mFoamDried && this.rng(5900) == 0) {
            this.mFoamDried = true;
            this.updateClientData();
        }
    }

    @Override
    public boolean onPlaced(ItemStack aStack, EntityPlayer aPlayer, MultiTileEntityContainer aMTEContainer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.mOwnable && aPlayer != null && !CS.OWNERSHIP_RESET) {
            this.mOwner = aPlayer.func_110124_au();
        }
        return true;
    }

    @Override
    public boolean allowInteraction(Entity aEntity) {
        return !this.mOwnable || !this.mFoamDried || super.allowInteraction(aEntity);
    }

    @Override
    public boolean dryFoam(byte aSide, Entity aPlayer) {
        if (this.mFoamDried || this.isClientSide()) {
            return false;
        }
        this.mFoamDried = true;
        this.updateClientData();
        return true;
    }

    @Override
    public boolean removeFoam(byte aSide, Entity aPlayer) {
        if (this.isClientSide() || !this.allowInteraction(aPlayer)) {
            return false;
        }
        this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, CS.NB, 0, 3);
        return true;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aShouldSideBeRendered[aSide] ? BlockTextureDefault.get((IIconContainer)(this.mFoamDried ? (this.mOwnable ? Textures.BlockIcons.CFOAM_HARDENED_OWNED : Textures.BlockIcons.CFOAM_HARDENED) : (this.mOwnable ? Textures.BlockIcons.CFOAM_FRESH_OWNED : Textures.BlockIcons.CFOAM_FRESH)), this.mRGBa) : null;
    }

    @Override
    public int getLightOpacity() {
        return this.mFoamDried ? 255 : 3;
    }

    @Override
    public float getBlockHardness() {
        return (this.mFoamDried ? CS.BlocksGT.CFoam : CS.BlocksGT.CFoamFresh).func_149712_f(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public float getExplosionResistance2() {
        return (this.mFoamDried ? CS.BlocksGT.CFoam : CS.BlocksGT.CFoamFresh).func_149638_a(null);
    }

    @Override
    public byte getVisualData() {
        return (byte)((this.mFoamDried ? 1 : 0) | (this.mOwnable ? 2 : 0));
    }

    @Override
    public void setVisualData(byte aData) {
        this.mFoamDried = (aData & 1) != 0;
        this.mOwnable = (aData & 2) != 0;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return this.mFoamDried;
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return this.mFoamDried;
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return this.mFoamDried;
    }

    @Override
    public boolean isSealable2(byte aSide) {
        return this.mFoamDried;
    }

    @Override
    public boolean hasFoam(byte aSide) {
        return true;
    }

    @Override
    public boolean driedFoam(byte aSide) {
        return this.mFoamDried;
    }

    @Override
    public boolean ownedFoam(byte aSide) {
        return this.mOwnable;
    }

    @Override
    public boolean applyFoam(byte aSide, Entity aPlayer, short[] aCFoamRGB, byte aVanillaColor, boolean aOwnable) {
        return false;
    }

    @Override
    public boolean addDefaultCollisionBoxToList() {
        return true;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    @Override
    public boolean showInCreative() {
        return false;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.cfoam.scaffold.wood";
    }
}

