/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.energy.reactors;

import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.MT;
import gregapi.item.IItemReactorRod;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureFluid;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.ST;
import gregapi.util.UT;
import gregtech.tileentity.energy.reactors.MultiTileEntityReactorCore;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class MultiTileEntityReactorCore1x1
extends MultiTileEntityReactorCore {
    public ITexture[] mTextures = new ITexture[15];
    public static IIconContainer[] sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/generators/reactor_core_1x1/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/generators/reactor_core_1x1/colored/top"), new Textures.BlockIcons.CustomIcon("machines/generators/reactor_core_1x1/colored/side1"), new Textures.BlockIcons.CustomIcon("machines/generators/reactor_core_1x1/colored/side2"), new Textures.BlockIcons.CustomIcon("machines/generators/reactor_core_1x1/colored/face1"), new Textures.BlockIcons.CustomIcon("machines/generators/reactor_core_1x1/colored/face2")};
    public static IIconContainer[] sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/generators/reactor_core_1x1/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/generators/reactor_core_1x1/overlay/top"), new Textures.BlockIcons.CustomIcon("machines/generators/reactor_core_1x1/overlay/side1"), new Textures.BlockIcons.CustomIcon("machines/generators/reactor_core_1x1/overlay/side2"), new Textures.BlockIcons.CustomIcon("machines/generators/reactor_core_1x1/overlay/face1"), new Textures.BlockIcons.CustomIcon("machines/generators/reactor_core_1x1/overlay/face2")};

    @Override
    public void onServerTickPost(boolean aFirst) {
        if (aFirst) {
            if (CS.SERVER_TIME % 20L == 19L && !this.mStopped) {
                DelegatorTileEntity[] tAdjacents = new DelegatorTileEntity[4];
                DelegatorTileEntity<TileEntity> tAdjacentTE = this.getAdjacentTileEntity((byte)2);
                if (tAdjacentTE.mTileEntity instanceof MultiTileEntityReactorCore && CS.SIDES_HORIZONTAL[tAdjacentTE.mSideOfTileEntity]) {
                    tAdjacents[0] = tAdjacentTE;
                }
                tAdjacentTE = this.getAdjacentTileEntity((byte)3);
                if (tAdjacentTE.mTileEntity instanceof MultiTileEntityReactorCore && CS.SIDES_HORIZONTAL[tAdjacentTE.mSideOfTileEntity]) {
                    tAdjacents[1] = tAdjacentTE;
                }
                tAdjacentTE = this.getAdjacentTileEntity((byte)4);
                if (tAdjacentTE.mTileEntity instanceof MultiTileEntityReactorCore && CS.SIDES_HORIZONTAL[tAdjacentTE.mSideOfTileEntity]) {
                    tAdjacents[2] = tAdjacentTE;
                }
                tAdjacentTE = this.getAdjacentTileEntity((byte)5);
                if (tAdjacentTE.mTileEntity instanceof MultiTileEntityReactorCore && CS.SIDES_HORIZONTAL[tAdjacentTE.mSideOfTileEntity]) {
                    tAdjacents[3] = tAdjacentTE;
                }
                int tNeutronCount = (int)UT.Code.divup(this.getReactorRodNeutronEmission(0), 2L);
                boolean tModerated = this.isReactorRodModerated(0);
                if (tNeutronCount != 0 || tModerated) {
                    DelegatorTileEntity tAdjacent = tAdjacents[0];
                    if (tAdjacent != null) {
                        this.mNeutronCounts[0] = this.mNeutronCounts[0] + ((MultiTileEntityReactorCore)tAdjacent.mTileEntity).getReactorRodNeutronReflection(S2103[tAdjacent.mSideOfTileEntity], tNeutronCount, tModerated);
                    }
                    if ((tAdjacent = tAdjacents[2]) != null) {
                        this.mNeutronCounts[0] = this.mNeutronCounts[0] + ((MultiTileEntityReactorCore)tAdjacent.mTileEntity).getReactorRodNeutronReflection(S0312[tAdjacent.mSideOfTileEntity], tNeutronCount, tModerated);
                    }
                    if ((tAdjacent = tAdjacents[1]) != null) {
                        this.mNeutronCounts[0] = this.mNeutronCounts[0] + ((MultiTileEntityReactorCore)tAdjacent.mTileEntity).getReactorRodNeutronReflection(S0312[tAdjacent.mSideOfTileEntity], tNeutronCount, tModerated);
                    }
                    if ((tAdjacent = tAdjacents[2]) != null) {
                        this.mNeutronCounts[0] = this.mNeutronCounts[0] + ((MultiTileEntityReactorCore)tAdjacent.mTileEntity).getReactorRodNeutronReflection(S2103[tAdjacent.mSideOfTileEntity], tNeutronCount, tModerated);
                    }
                    if ((tAdjacent = tAdjacents[0]) != null) {
                        this.mNeutronCounts[0] = this.mNeutronCounts[0] + ((MultiTileEntityReactorCore)tAdjacent.mTileEntity).getReactorRodNeutronReflection(S0312[tAdjacent.mSideOfTileEntity], tNeutronCount, tModerated);
                    }
                    if ((tAdjacent = tAdjacents[3]) != null) {
                        this.mNeutronCounts[0] = this.mNeutronCounts[0] + ((MultiTileEntityReactorCore)tAdjacent.mTileEntity).getReactorRodNeutronReflection(S2103[tAdjacent.mSideOfTileEntity], tNeutronCount, tModerated);
                    }
                    if ((tAdjacent = tAdjacents[1]) != null) {
                        this.mNeutronCounts[0] = this.mNeutronCounts[0] + ((MultiTileEntityReactorCore)tAdjacent.mTileEntity).getReactorRodNeutronReflection(S2103[tAdjacent.mSideOfTileEntity], tNeutronCount, tModerated);
                    }
                    if ((tAdjacent = tAdjacents[3]) != null) {
                        this.mNeutronCounts[0] = this.mNeutronCounts[0] + ((MultiTileEntityReactorCore)tAdjacent.mTileEntity).getReactorRodNeutronReflection(S0312[tAdjacent.mSideOfTileEntity], tNeutronCount, tModerated);
                    }
                }
            }
        } else {
            long tCalc;
            if (CS.SERVER_TIME % 20L == 19L) {
                this.mNeutronCounts[0] = this.mNeutronCounts[0] + (this.mNeutronCounts[1] + this.mNeutronCounts[2] + this.mNeutronCounts[3]);
                this.oNeutronCounts[3] = 0;
                this.oNeutronCounts[2] = 0;
                this.oNeutronCounts[1] = 0;
                this.mNeutronCounts[3] = 0;
                this.mNeutronCounts[2] = 0;
                this.mNeutronCounts[1] = 0;
                this.updateReactorRodModeration(0);
            }
            if ((tCalc = UT.Code.divup(this.oNeutronCounts[0] = this.mNeutronCounts[0], 256L)) > 0L && CS.SERVER_TIME % 20L == 10L) {
                for (Object tEntity : this.field_145850_b.field_72996_f) {
                    int tStrength;
                    if (!(tEntity instanceof EntityLivingBase) || Math.abs((double)this.field_145851_c - ((EntityLivingBase)tEntity).field_70165_t) > 200.0 || Math.abs((double)this.field_145849_e - ((EntityLivingBase)tEntity).field_70161_v) > 200.0 || (tStrength = UT.Code.bindInt((long)((double)tCalc - ((EntityLivingBase)tEntity).func_70011_f((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e)))) <= 0) continue;
                    UT.Entities.applyRadioactivity((Entity)((EntityLivingBase)tEntity), (int)UT.Code.divup(tStrength, 10L), tStrength);
                }
            }
            this.mRunning = tCalc != 0L;
            long tEnergy = this.mEnergy;
            if (this.getReactorRodNeutronReaction(0)) {
                this.mRunning = true;
            }
            int tDivider = 1;
            if (MT.Na.mLiquid.isFluidEqual(this.mTanks[0].getFluid())) {
                tDivider = 6;
            } else if (MT.Sn.mLiquid.isFluidEqual(this.mTanks[0].getFluid())) {
                tDivider = 3;
            }
            this.mEnergy = UT.Code.divup(this.mEnergy - tEnergy, tDivider) + tEnergy;
            this.oEnergy = this.mEnergy - tEnergy;
            if (this.mEnergy > 0L) {
                boolean tIsExploding = false;
                if (FL.Coolant_IC2.is(this.mTanks[0])) {
                    tEnergy = this.mEnergy / (long)CS.EU_PER_COOLANT;
                    if (this.mTanks[0].has(tEnergy) && this.mTanks[1].fillAll(FL.Coolant_IC2_Hot.make(tEnergy))) {
                        this.mEnergy -= (long)CS.EU_PER_COOLANT * this.mTanks[0].remove(tEnergy);
                    } else {
                        tIsExploding = true;
                    }
                } else if (FL.distw(this.mTanks[0])) {
                    tEnergy = this.mEnergy / (long)CS.EU_PER_WATER;
                    if (this.mTanks[0].has(tEnergy) && this.mTanks[1].fillAll(FL.Steam.make(tEnergy * (long)CS.STEAM_PER_WATER))) {
                        this.mEnergy -= this.mTanks[0].remove(tEnergy) * (long)CS.EU_PER_WATER;
                    } else {
                        tIsExploding = true;
                    }
                } else if (MT.Sn.mLiquid.isFluidEqual(this.mTanks[0].getFluid())) {
                    tEnergy = this.mEnergy / (long)CS.EU_PER_TIN;
                    if (this.mTanks[0].has(tEnergy) && this.mTanks[1].fillAll(FL.Hot_Molten_Tin.make(tEnergy))) {
                        this.mEnergy -= (long)CS.EU_PER_TIN * this.mTanks[0].remove(tEnergy);
                    } else {
                        tIsExploding = true;
                    }
                } else if (MT.Na.mLiquid.isFluidEqual(this.mTanks[0].getFluid())) {
                    tEnergy = this.mEnergy / (long)CS.EU_PER_SODIUM;
                    if (this.mTanks[0].has(tEnergy) && this.mTanks[1].fillAll(FL.Hot_Molten_Sodium.make(tEnergy))) {
                        this.mEnergy -= (long)CS.EU_PER_SODIUM * this.mTanks[0].remove(tEnergy);
                    } else {
                        tIsExploding = true;
                    }
                } else if (MT.HDO.mLiquid.isFluidEqual(this.mTanks[0].getFluid())) {
                    tEnergy = this.mEnergy / (long)CS.EU_PER_SEMI_HEAVY_WATER;
                    if (this.mTanks[0].has(tEnergy) && this.mTanks[1].fillAll(FL.Hot_Semi_Heavy_Water.make(tEnergy))) {
                        this.mEnergy -= (long)CS.EU_PER_SEMI_HEAVY_WATER * this.mTanks[0].remove(tEnergy);
                    } else {
                        tIsExploding = true;
                    }
                } else if (MT.D2O.mLiquid.isFluidEqual(this.mTanks[0].getFluid())) {
                    tEnergy = this.mEnergy / (long)CS.EU_PER_HEAVY_WATER;
                    if (this.mTanks[0].has(tEnergy) && this.mTanks[1].fillAll(FL.Hot_Heavy_Water.make(tEnergy))) {
                        this.mEnergy -= (long)CS.EU_PER_HEAVY_WATER * this.mTanks[0].remove(tEnergy);
                    } else {
                        tIsExploding = true;
                    }
                } else if (MT.T2O.mLiquid.isFluidEqual(this.mTanks[0].getFluid())) {
                    tEnergy = this.mEnergy / (long)CS.EU_PER_TRITIATED_WATER;
                    if (this.mTanks[0].has(tEnergy) && this.mTanks[1].fillAll(FL.Hot_Tritiated_Water.make(tEnergy))) {
                        this.mEnergy -= (long)CS.EU_PER_TRITIATED_WATER * this.mTanks[0].remove(tEnergy);
                    } else {
                        tIsExploding = true;
                    }
                } else if (MT.LiCl.mLiquid.isFluidEqual(this.mTanks[0].getFluid())) {
                    tEnergy = this.mEnergy / (long)CS.EU_PER_LICL;
                    if (this.mTanks[0].has(tEnergy) && this.mTanks[1].fillAll(FL.Hot_Molten_LiCl.make(tEnergy))) {
                        this.mEnergy -= (long)CS.EU_PER_LICL * this.mTanks[0].remove(tEnergy);
                    } else {
                        tIsExploding = true;
                    }
                } else if (MT.CO2.mGas.isFluidEqual(this.mTanks[0].getFluid())) {
                    tEnergy = this.mEnergy / (long)CS.EU_PER_CO2;
                    if (this.mTanks[0].has(tEnergy) && this.mTanks[1].fillAll(FL.Hot_Carbon_Dioxide.make(tEnergy))) {
                        this.mEnergy -= (long)CS.EU_PER_CO2 * this.mTanks[0].remove(tEnergy);
                    } else {
                        tIsExploding = true;
                    }
                } else if (MT.He.mGas.isFluidEqual(this.mTanks[0].getFluid())) {
                    tEnergy = this.mEnergy / (long)CS.EU_PER_HELIUM;
                    if (this.mTanks[0].has(tEnergy) && this.mTanks[1].fillAll(FL.Hot_Helium.make(tEnergy))) {
                        this.mEnergy -= (long)CS.EU_PER_HELIUM * this.mTanks[0].remove(tEnergy);
                    } else {
                        tIsExploding = true;
                    }
                } else if (FL.Thorium_Salt.is(this.mTanks[0])) {
                    tEnergy = this.mEnergy / (long)CS.EU_PER_THORIUM_SALT;
                    if (this.mTanks[0].has(tEnergy) && this.mTanks[1].fillAll(FL.amount(MT.LiCl.mLiquid, tEnergy))) {
                        this.mEnergy -= (long)CS.EU_PER_THORIUM_SALT * this.mTanks[0].remove(tEnergy);
                    } else {
                        tIsExploding = true;
                    }
                } else if (this.mTanks[0].isEmpty() && this.oEnergy > 0L) {
                    tIsExploding = true;
                }
                if (tIsExploding && !this.invempty()) {
                    this.slotKill(0);
                    UT.Sounds.send("random.explode", this, false);
                    tCalc *= 2L;
                    for (Object tEntity : this.field_145850_b.field_72996_f) {
                        int tStrength;
                        if (!(tEntity instanceof EntityLivingBase) || Math.abs((double)this.field_145851_c - ((EntityLivingBase)tEntity).field_70165_t) > 500.0 || Math.abs((double)this.field_145849_e - ((EntityLivingBase)tEntity).field_70161_v) > 500.0 || (tStrength = UT.Code.bindInt((long)((double)tCalc - ((EntityLivingBase)tEntity).func_70011_f((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e)))) <= 0) continue;
                        UT.Entities.applyRadioactivity((Entity)((EntityLivingBase)tEntity), (int)UT.Code.divup(tStrength, 10L), tStrength);
                    }
                    this.updateClientData();
                }
            }
        }
    }

    @Override
    public int getReactorRodNeutronEmission(int aSlot) {
        if (!this.mStopped && this.slotHas(0) && ST.item(this.slot(0)) instanceof IItemReactorRod) {
            return ((IItemReactorRod)ST.item(this.slot(0))).getReactorRodNeutronEmission(this, 0, this.slot(0));
        }
        this.mNeutronCounts[0] = 0;
        return 0;
    }

    @Override
    public boolean getReactorRodNeutronReaction(int aSlot) {
        if (CS.SERVER_TIME % 20L == 18L) {
            this.mNeutronCounts[0] = this.mNeutronCounts[0] - this.oNeutronCounts[0];
        }
        if (!this.mStopped && this.slotHas(0) && ST.item(this.slot(0)) instanceof IItemReactorRod) {
            return ((IItemReactorRod)ST.item(this.slot(0))).getReactorRodNeutronReaction(this, 0, this.slot(0));
        }
        return false;
    }

    @Override
    public int getReactorRodNeutronReflection(int aSlot, int aNeutrons, boolean aModerated) {
        if (!this.mStopped && this.slotHas(0) && ST.item(this.slot(0)) instanceof IItemReactorRod) {
            return ((IItemReactorRod)ST.item(this.slot(0))).getReactorRodNeutronReflection(this, 0, this.slot(0), aNeutrons, aModerated);
        }
        return 0;
    }

    @Override
    public boolean isReactorRodModerated(int aSlot) {
        if (this.slotHas(0) && ST.item(this.slot(0)) instanceof IItemReactorRod) {
            boolean isModerated = ((IItemReactorRod)ST.item(this.slot(0))).isModerated(this, 0, this.slot(0));
            if (this.mStopped) {
                return false;
            }
            return isModerated;
        }
        return false;
    }

    @Override
    public void updateReactorRodModeration(int aSlot) {
        if (this.slotHas(0) && ST.item(this.slot(0)) instanceof IItemReactorRod) {
            ((IItemReactorRod)ST.item(this.slot(0))).updateModeration(this, 0, this.slot(0));
        }
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L) {
            return rReturn;
        }
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("pincers") && CS.SIDES_TOP[aSide]) {
            if (this.slotHas(0) && ST.give(aPlayer, this.slot(0), true, this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5)) {
                this.slotKill(0);
                this.updateClientData();
                return 10000L;
            }
            return 0L;
        }
        if (aTool.equals("geigercounter")) {
            if (aChatReturn != null) {
                aChatReturn.add("Neutron Levels: " + (this.oNeutronCounts[0] + this.oNeutronCounts[1] + this.oNeutronCounts[2] + this.oNeutronCounts[3]) + "n");
                aChatReturn.add(this.mStopped ? "Reactor Block is OFF" : "Reactor Block is ON");
            }
            return 10000L;
        }
        return 0L;
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        ItemStack aStack;
        if (this.isServerSide() && CS.SIDES_TOP[aSide] && ST.item(aStack = aPlayer.func_71045_bC()) instanceof IItemReactorRod && ((IItemReactorRod)ST.item_(aStack)).isReactorRod(aStack) && !this.slotHas(0) && ST.use((Entity)aPlayer, aStack)) {
            this.slot(0, ST.amount(1L, aStack));
            this.mStopped = true;
            UT.Sounds.send("random.click", this, false);
            this.updateClientData();
        }
        return true;
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        if (aSendAll) {
            return this.getClientDataPacketByteArray(aSendAll, (byte)UT.Code.getR(this.mRGBa), (byte)UT.Code.getG(this.mRGBa), (byte)UT.Code.getB(this.mRGBa), this.getVisualData(), this.getDirectionData(), UT.Code.toByteS(FL.id_(this.mTanks[0]), 0), UT.Code.toByteS(FL.id_(this.mTanks[0]), 1), UT.Code.toByteS(ST.id(this.slot(0)), 0), UT.Code.toByteS(ST.id(this.slot(0)), 1), UT.Code.toByteS(ST.meta(this.slot(0)), 0), UT.Code.toByteS(ST.meta(this.slot(0)), 1));
        }
        return this.getClientDataPacketByte(aSendAll, this.getVisualData());
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        super.receiveDataByteArray(aData, aNetworkHandler);
        int i = 5;
        if (aData.length <= i) {
            return true;
        }
        this.mTanks[0].setFluid(FL.make(UT.Code.combine(aData[i++], aData[i++]), (long)this.mTanks[0].getCapacity()));
        this.slot(0, ST.make(UT.Code.combine(aData[i++], aData[i++]), 1L, (long)UT.Code.combine(aData[i++], aData[i++])));
        return true;
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        this.mTextures[0] = BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[0], this.mRGBa), BlockTextureDefault.get(sOverlays[0]));
        this.mTextures[1] = BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[1], this.mRGBa), BlockTextureDefault.get(sOverlays[1]));
        this.mTextures[2] = BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[2], this.mRGBa), BlockTextureDefault.get(sOverlays[2]));
        this.mTextures[3] = BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[3], this.mRGBa), BlockTextureDefault.get(sOverlays[3]));
        this.mTextures[4] = BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[4], this.mRGBa), BlockTextureDefault.get(sOverlays[4]));
        this.mTextures[5] = BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[5], this.mRGBa), BlockTextureDefault.get(sOverlays[5]));
        this.mTextures[10] = this.mTanks[0].has() ? BlockTextureFluid.get(this.mTanks[0]) : null;
        ItemStack aStack = this.slot(0);
        if (ST.item(aStack) instanceof IItemReactorRod) {
            this.mTextures[6] = ((IItemReactorRod)ST.item_(aStack)).getReactorRodTextureSides(this, 0, aStack, !this.mStopped && (this.mMode & CS.B[0]) == 0);
            this.mTextures[11] = ((IItemReactorRod)ST.item_(aStack)).getReactorRodTextureTop(this, 0, aStack, !this.mStopped && (this.mMode & CS.B[0]) == 0);
        } else {
            this.mTextures[6] = null;
            this.mTextures[11] = null;
        }
        return 11;
    }

    @Override
    public boolean usesRenderPass2(int aRenderPass, boolean[] aShouldSideBeRendered) {
        return aRenderPass < 6 || aRenderPass == 6 && this.slotHas(0) || aRenderPass == 10 && this.mTanks[0].has();
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 4: {
                return this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[14], CS.PX_N[0], CS.PX_N[0]);
            }
            case 0: {
                return this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[14], CS.PX_N[0]);
            }
            case 2: {
                return this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[0], CS.PX_N[14]);
            }
            case 5: {
                return this.box(aBlock, CS.PX_P[14], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[0], CS.PX_N[0]);
            }
            case 1: {
                return this.box(aBlock, CS.PX_P[0], CS.PX_P[14], CS.PX_P[0], CS.PX_N[0], CS.PX_N[0], CS.PX_N[0]);
            }
            case 3: {
                return this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[14], CS.PX_N[0], CS.PX_N[0], CS.PX_N[0]);
            }
            case 6: {
                return this.box(aBlock, CS.PX_P[6], CS.PX_P[1], CS.PX_P[6], CS.PX_N[6], CS.PX_P[17], CS.PX_N[6]);
            }
            case 10: {
                return this.box(aBlock, CS.PX_P[2] + 0.005f, CS.PX_P[2], CS.PX_P[2] + 0.005f, CS.PX_N[2] - 0.005f, CS.PX_N[2], CS.PX_N[2] - 0.005f);
            }
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aRenderPass < 6 && !CS.ALONG_AXIS[aRenderPass][aSide] ? null : (aRenderPass == this.mFacing ? this.mTextures[4] : (aRenderPass == this.mSecondFacing ? this.mTextures[5] : (aRenderPass >= 6 || aRenderPass < 2 ? this.mTextures[CS.SIDES_VERTICAL[aSide] && aRenderPass != 10 && aRenderPass > 1 ? aRenderPass + 5 : aRenderPass] : this.mTextures[aRenderPass < 6 && this.isCovered((byte)aRenderPass) ? 3 : 2])));
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return new ItemStack[1];
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return aSide == 0 || aSide == 1 ? UT.Code.getAscendingArray(1) : CS.ZL_INTEGER;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        return this.mStopped && aStack != null && aSlot == 0 && !this.slotHas(aSlot) && ST.item(aStack) instanceof IItemReactorRod && ((IItemReactorRod)ST.item_(aStack)).isReactorRod(aStack);
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return this.mStopped && aStack != null && aSlot == 0;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.generator.reactor.core.1x1";
    }
}

