/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.tools.electric;

import gregapi.block.MaterialAdventure;
import gregapi.data.CS;
import gregapi.data.MD;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.item.multiitem.MultiItemTool;
import gregapi.item.multiitem.behaviors.Behavior_Place_Sapling;
import gregapi.item.multiitem.behaviors.Behavior_Place_Workbench;
import gregapi.item.multiitem.behaviors.Behavior_Tool;
import gregapi.old.Textures;
import gregapi.oredict.OreDictMaterial;
import gregapi.render.IIconContainer;
import gregapi.util.ST;
import gregtech.items.tools.early.GT_Tool_Axe;
import ic2.core.IC2;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.world.BlockEvent;

public class GT_Tool_Chainsaw_LV
extends GT_Tool_Axe {
    @Override
    public int getBaseQuality() {
        return 1;
    }

    @Override
    public int getToolDamagePerContainerCraft() {
        return 200;
    }

    @Override
    public int getToolDamagePerEntityAttack() {
        return super.getToolDamagePerEntityAttack() * 4;
    }

    @Override
    public float getSpeedMultiplier() {
        return 2.0f;
    }

    @Override
    public String getCraftingSound() {
        return CS.SFX.IC_CHAINSAW_01;
    }

    @Override
    public String getEntityHitSound() {
        return CS.SFX.IC_CHAINSAW_02;
    }

    @Override
    public String getMiningSound() {
        return CS.SFX.IC_CHAINSAW_01;
    }

    @Override
    public int getHurtResistanceTime(int aOriginalHurtResistance, Entity aEntity) {
        if (aEntity instanceof EntityCreeper) {
            return aOriginalHurtResistance / 3;
        }
        return aOriginalHurtResistance;
    }

    @Override
    public DamageSource getDamageSource(EntityLivingBase aPlayer, Entity aEntity) {
        if (MD.IC2.mLoaded && aPlayer instanceof EntityPlayer && aEntity instanceof EntityCreeper) {
            try {
                ST.achieve((Entity)aPlayer, AchievementList.field_76016_k);
                IC2.achievements.issueAchievement((EntityPlayer)aPlayer, "buildCable");
                IC2.achievements.issueAchievement((EntityPlayer)aPlayer, "buildGenerator");
                IC2.achievements.issueAchievement((EntityPlayer)aPlayer, "buildBatBox");
                IC2.achievements.issueAchievement((EntityPlayer)aPlayer, "buildChainsaw");
                IC2.achievements.issueAchievement((EntityPlayer)aPlayer, "killCreeperChainsaw");
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        return super.getDamageSource(aPlayer, aEntity);
    }

    @Override
    public boolean isMinableBlock(Block aBlock, byte aMetaData) {
        String tTool = aBlock.getHarvestTool((int)aMetaData);
        return tTool != null && (tTool.equalsIgnoreCase("axe") || tTool.equalsIgnoreCase("saw")) || aBlock.func_149688_o() == Material.field_151575_d || aBlock.func_149688_o() == MaterialAdventure.WOOD || aBlock.func_149688_o() == Material.field_151570_A || aBlock.func_149688_o() == Material.field_151584_j || aBlock.func_149688_o() == Material.field_151582_l || aBlock.func_149688_o() == Material.field_151585_k || aBlock.func_149688_o() == Material.field_151572_C || aBlock.func_149688_o() == Material.field_151588_w || aBlock.func_149688_o() == Material.field_151598_x || aBlock.func_149688_o() == Material.field_151589_v;
    }

    @Override
    public int convertBlockDrops(List<ItemStack> aDrops, ItemStack aStack, EntityPlayer aPlayer, Block aBlock, long aAvailableDurability, int aX, int aY, int aZ, byte aMetaData, int aFortune, boolean aSilkTouch, BlockEvent.HarvestDropsEvent aEvent) {
        if (aBlock.func_149688_o() == Material.field_151584_j && aBlock instanceof IShearable) {
            aPlayer.field_70170_p.func_147465_d(aX, aY, aZ, aBlock, (int)aMetaData, 0);
            if (((IShearable)aBlock).isShearable(aStack, (IBlockAccess)aPlayer.field_70170_p, aX, aY, aZ)) {
                ArrayList tDrops = ((IShearable)aBlock).onSheared(aStack, (IBlockAccess)aPlayer.field_70170_p, aX, aY, aZ, aFortune);
                aDrops.clear();
                aDrops.addAll(tDrops);
                aEvent.dropChance = 1.0f;
            }
            aPlayer.field_70170_p.func_147465_d(aX, aY, aZ, CS.NB, 0, 0);
            return 0;
        }
        if ((aBlock.func_149688_o() == Material.field_151588_w || aBlock.func_149688_o() == Material.field_151598_x) && aDrops.isEmpty()) {
            aDrops.add(ST.make(aBlock, 1L, (long)aMetaData));
            aPlayer.field_70170_p.func_147468_f(aX, aY, aZ);
            aEvent.dropChance = 1.0f;
            return 0;
        }
        return super.convertBlockDrops(aDrops, aStack, aPlayer, aBlock, aAvailableDurability, aX, aY, aZ, aMetaData, aFortune, aSilkTouch, aEvent);
    }

    @Override
    public float getMiningSpeed(Block aBlock, byte aMetaData, float aDefault, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ) {
        return aBlock.func_149688_o() == Material.field_151584_j || aBlock.func_149688_o() == Material.field_151582_l || aBlock.func_149688_o() == Material.field_151585_k || aBlock.func_149688_o() == Material.field_151572_C ? aDefault : super.getMiningSpeed(aBlock, aMetaData, aDefault, aPlayer, aWorld, aX, aY, aZ);
    }

    @Override
    public IIconContainer getIcon(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? Textures.ItemIcons.POWER_UNIT_LV : (ST.meta(aStack) % 2 != 0 ? Textures.ItemIcons.VOID : MultiItemTool.getPrimaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.Steel).mTextureSetsItems.get(OP.toolHeadChainsaw.mIconIndexItem));
    }

    @Override
    public short[] getRGBa(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? MultiItemTool.getSecondaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.StainlessSteel).mRGBaSolid : MultiItemTool.getPrimaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.Steel).mRGBaSolid;
    }

    @Override
    public void onToolCrafted(ItemStack aStack, EntityPlayer aPlayer) {
        super.onToolCrafted(aStack, aPlayer);
        if (MD.IC2.mLoaded) {
            try {
                aPlayer.func_71029_a((StatBase)AchievementList.field_76018_i);
                aPlayer.func_71029_a((StatBase)AchievementList.field_76015_j);
                aPlayer.func_71029_a((StatBase)AchievementList.field_76016_k);
                IC2.achievements.issueAchievement(aPlayer, "buildCable");
                IC2.achievements.issueAchievement(aPlayer, "buildGenerator");
                IC2.achievements.issueAchievement(aPlayer, "buildBatBox");
                IC2.achievements.issueAchievement(aPlayer, "buildChainsaw");
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
    }

    @Override
    public void onStatsAddedToTool(MultiItemTool aItem, int aID) {
        aItem.addItemBehavior(aID, new Behavior_Tool("saw", "dig.wood", (long)this.getToolDamagePerContainerCraft(), false, CS.SFX.RANDOM_PITCH));
        aItem.addItemBehavior(aID, Behavior_Place_Sapling.INSTANCE);
        aItem.addItemBehavior(aID, Behavior_Place_Workbench.INSTANCE);
    }

    @Override
    public String getDeathMessage() {
        return "[VICTIM] was massacred by [KILLER]";
    }
}

