/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.tools.early;

import gregapi.block.MaterialAdventure;
import gregapi.block.tree.BlockBaseBeam;
import gregapi.data.CS;
import gregapi.data.MD;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.item.multiitem.MultiItemTool;
import gregapi.item.multiitem.behaviors.Behavior_Place_Sapling;
import gregapi.item.multiitem.behaviors.Behavior_Place_Workbench;
import gregapi.item.multiitem.behaviors.Behavior_Tool;
import gregapi.item.multiitem.tools.ToolStats;
import gregapi.oredict.OreDictMaterial;
import gregapi.render.IIconContainer;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import gregapi.wooddict.WoodDictionary;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;

public class GT_Tool_Axe
extends ToolStats {
    private static boolean LOCK = true;

    @Override
    public int getToolDamagePerBlockBreak() {
        return 50;
    }

    @Override
    public int getToolDamagePerEntityAttack() {
        return 200;
    }

    @Override
    public int getToolDamagePerContainerCraft() {
        return 100;
    }

    @Override
    public int getToolDamagePerDropConversion() {
        return 1;
    }

    @Override
    public int getBaseQuality() {
        return 0;
    }

    @Override
    public float getBaseDamage() {
        return 3.0f;
    }

    @Override
    public float getSpeedMultiplier() {
        return 1.0f;
    }

    @Override
    public float getMaxDurabilityMultiplier() {
        return 1.0f;
    }

    @Override
    public boolean isWeapon() {
        return true;
    }

    @Override
    public boolean isMinableBlock(Block aBlock, byte aMeta) {
        return "axe".equalsIgnoreCase(aBlock.getHarvestTool((int)aMeta)) || aBlock instanceof BlockHugeMushroom || aBlock.func_149688_o() == Material.field_151575_d || aBlock.func_149688_o() == MaterialAdventure.WOOD || aBlock.func_149688_o() == Material.field_151570_A || aBlock.func_149688_o() == Material.field_151584_j || aBlock.func_149688_o() == Material.field_151582_l || aBlock.func_149688_o() == Material.field_151585_k || aBlock.func_149688_o() == Material.field_151572_C || aBlock.func_149688_o() == Material.field_151589_v;
    }

    @Override
    public int convertBlockDrops(List<ItemStack> aDrops, ItemStack aStack, EntityPlayer aPlayer, Block aBlock, long aAvailableDurability, int aX, int aY, int aZ, byte aMeta, int aFortune, boolean aSilkTouch, BlockEvent.HarvestDropsEvent aEvent) {
        int rAmount = 0;
        if (LOCK && !MD.TreeCap.mLoaded && !aPlayer.field_70170_p.field_72995_K && !aPlayer.func_70093_af() && !aBlock.getClass().getName().startsWith("com.ferreusveritas.dynamictrees") && (aBlock instanceof BlockHugeMushroom || aBlock.isWood((IBlockAccess)aPlayer.field_70170_p, aX, aY, aZ) || OP.log.contains(ST.make(aBlock, 1L, (long)aMeta)) || WoodDictionary.WOODS.containsKey(aBlock, (long)aMeta, true))) {
            LOCK = false;
            try {
                int tY = aY;
                int tH = aPlayer.field_70170_p.func_72800_K();
                int tCount = 0;
                int tIncrement = UT.Code.roundUp(aBlock.func_149712_f(aPlayer.field_70170_p, aX, aY, aZ) * (float)this.getToolDamagePerBlockBreak());
                while (++tY < tH && aPlayer.field_70170_p.func_147439_a(aX, tY, aZ) == aBlock) {
                    if ((long)rAmount >= aAvailableDurability) continue;
                    rAmount += ++tIncrement;
                    ++tCount;
                }
                while (--tY > aY && tCount-- > 0 && aPlayer.field_70170_p.func_147480_a(aX, tY, aZ, true)) {
                    if (!CS.FAST_LEAF_DECAY) continue;
                    WD.leafdecay(aPlayer.field_70170_p, aX, tY, aZ, null, true, true);
                }
                if (CS.FAST_LEAF_DECAY) {
                    WD.leafdecay(aPlayer.field_70170_p, aX, aY, aZ, null, true, true);
                }
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
            LOCK = true;
        }
        this.harvestStick(aDrops, aStack, aPlayer, aBlock, aAvailableDurability, aX, aY, aZ, aMeta, aFortune, aSilkTouch, aEvent);
        return rAmount;
    }

    @Override
    public float getMiningSpeed(Block aBlock, byte aMeta, float aDefault, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ) {
        if (aBlock instanceof BlockBaseBeam) {
            return 2.0f * aDefault;
        }
        if (aBlock.getClass().getName().startsWith("com.ferreusveritas.dynamictrees")) {
            return aDefault;
        }
        if (aBlock instanceof BlockHugeMushroom || aBlock.isWood((IBlockAccess)aPlayer.field_70170_p, aX, aY, aZ) || OP.log.contains(ST.make(aBlock, 1L, (long)aMeta)) || WoodDictionary.WOODS.containsKey(aBlock, (long)aMeta, true)) {
            float rAmount = 1.0f;
            float tIncrement = 1.0f;
            if (!aPlayer.func_70093_af() && !MD.TreeCap.mLoaded) {
                int tH = aPlayer.field_70170_p.func_72800_K();
                for (int tY = aY + 1; tY < tH && aPlayer.field_70170_p.func_147439_a(aX, tY, aZ) == aBlock; ++tY) {
                    rAmount += (tIncrement += 0.1f);
                }
            }
            if (rAmount > 2.0f && (aBlock instanceof BlockHugeMushroom || MD.NeLi.owns(aBlock))) {
                return aDefault / (4.0f * rAmount);
            }
            return 2.0f * aDefault / rAmount;
        }
        return aBlock.func_149688_o() == Material.field_151584_j || aBlock.func_149688_o() == Material.field_151582_l || aBlock.func_149688_o() == Material.field_151585_k || aBlock.func_149688_o() == Material.field_151572_C ? aDefault / 4.0f : aDefault;
    }

    @Override
    public void afterDealingDamage(float aNormalDamage, float aMagicDamage, int aFireAspect, boolean aCriticalHit, Entity aEntity, ItemStack aStack, EntityPlayer aPlayer) {
        super.afterDealingDamage(aNormalDamage, aMagicDamage, aFireAspect, aCriticalHit, aEntity, aStack, aPlayer);
        if (aEntity.field_70170_p.field_72995_K || aNormalDamage < 2.0f) {
            return;
        }
        if ("EntityEnt".equalsIgnoreCase(UT.Reflection.getLowercaseClass(aEntity))) {
            ST.drop(aEntity, Blocks.field_150364_r, (long)UT.Code.bindStack((int)(aNormalDamage / 2.0f)), 0L);
        }
    }

    @Override
    public IIconContainer getIcon(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? MultiItemTool.getPrimaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.Steel).mTextureSetsItems.get(OP.toolHeadAxe.mIconIndexItem) : MultiItemTool.getSecondaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.WOODS.Spruce).mTextureSetsItems.get(OP.stick.mIconIndexItem);
    }

    @Override
    public short[] getRGBa(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? MultiItemTool.getPrimaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.Steel).mRGBaSolid : MultiItemTool.getSecondaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.WOODS.Spruce).mRGBaSolid;
    }

    @Override
    public void onStatsAddedToTool(MultiItemTool aItem, int aID) {
        aItem.addItemBehavior(aID, new Behavior_Tool("axe", "dig.wood", (long)this.getToolDamagePerContainerCraft(), false, CS.SFX.RANDOM_PITCH));
        aItem.addItemBehavior(aID, Behavior_Place_Sapling.INSTANCE);
        aItem.addItemBehavior(aID, Behavior_Place_Workbench.INSTANCE);
    }

    @Override
    public String getDeathMessage() {
        return "[VICTIM] has been chopped by [KILLER]";
    }
}

