/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.behaviors;

import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class Behavior_Spray_Color
extends IBehavior.AbstractBehaviorDefault {
    private final ItemStack mEmpty;
    private final ItemStack mUsed;
    private final ItemStack mFull;
    private final long mUses;
    private final byte mColor;
    private final Collection<Block> mAllowedVanillaBlocks = Arrays.asList(Blocks.field_150349_c, Blocks.field_150359_w, Blocks.field_150410_aZ, Blocks.field_150399_cn, Blocks.field_150397_co, Blocks.field_150404_cg, Blocks.field_150405_ch, Blocks.field_150406_ce);

    public Behavior_Spray_Color(ItemStack aEmpty, ItemStack aUsed, ItemStack aFull, long aUses, byte aColor) {
        this.mEmpty = aEmpty;
        this.mUsed = aUsed;
        this.mFull = aFull;
        this.mUses = aUses * 10L;
        this.mColor = UT.Code.bind4(aColor);
        LH.add("gt.behaviour.paintspray." + this.mColor + ".tooltip", "Can Color things in " + CS.DYE_NAMES[this.mColor]);
    }

    @Override
    public boolean onItemUseFirst(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float hitX, float hitY, float hitZ) {
        if (aWorld.field_72995_K || aStack.field_77994_a != 1) {
            return false;
        }
        boolean rOutput = false;
        if (!aPlayer.func_82247_a(aX, aY, aZ, (int)aSide, aStack)) {
            return false;
        }
        NBTTagCompound tNBT = UT.NBT.getNBT(aStack);
        long tUses = tNBT.func_74763_f("gt.remaining");
        if (ST.equal(aStack, this.mFull, true)) {
            aStack.func_150996_a(this.mUsed.func_77973_b());
            ST.meta_(aStack, ST.meta_(this.mUsed));
            tUses = this.mUses;
        }
        if (ST.equal(aStack, this.mUsed, true) && this.colorize(aWorld, aX, aY, aZ, aSide)) {
            UT.Sounds.send(CS.SFX.IC_SPRAY, aWorld, aX, aY, aZ);
            if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                tUses -= 10L;
            }
            rOutput = true;
        }
        UT.NBT.set(aStack, UT.NBT.setPosNum(tNBT, "gt.remaining", tUses));
        if (tUses <= 0L) {
            if (this.mEmpty == null) {
                --aStack.field_77994_a;
            } else {
                aStack.func_150996_a(this.mEmpty.func_77973_b());
                ST.meta_(aStack, ST.meta_(this.mEmpty));
            }
        }
        return rOutput;
    }

    @Override
    public boolean onRightClickEntity(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, Entity aEntity) {
        if (aStack.field_77994_a != 1) {
            return false;
        }
        boolean rUsed = false;
        if (aEntity instanceof EntitySheep && !((EntitySheep)aEntity).func_70892_o() && ((EntitySheep)aEntity).func_70896_n() != (~this.mColor & 0xF)) {
            ((EntitySheep)aEntity).func_70891_b(~this.mColor & 0xF);
            if (aEntity.field_70170_p.field_72995_K) {
                return true;
            }
            rUsed = true;
        }
        if (aEntity instanceof EntityWolf && ((EntityWolf)aEntity).func_70909_n() && ((EntityWolf)aEntity).func_82186_bH() != (~this.mColor & 0xF)) {
            ((EntityWolf)aEntity).func_82185_r(~this.mColor & 0xF);
            if (aEntity.field_70170_p.field_72995_K) {
                return true;
            }
            rUsed = true;
        }
        if (rUsed) {
            NBTTagCompound tNBT = UT.NBT.getNBT(aStack);
            long tUses = tNBT.func_74763_f("gt.remaining");
            if (ST.equal(aStack, this.mFull, true)) {
                aStack.func_150996_a(this.mUsed.func_77973_b());
                ST.meta_(aStack, ST.meta_(this.mUsed));
                tUses = this.mUses;
            }
            if (ST.equal(aStack, this.mUsed, true) && !UT.Entities.hasInfiniteItems(aPlayer)) {
                tUses -= 50L;
            }
            UT.NBT.set(aStack, UT.NBT.setPosNum(tNBT, "gt.remaining", tUses));
            if (tUses <= 0L) {
                if (this.mEmpty == null) {
                    --aStack.field_77994_a;
                } else {
                    aStack.func_150996_a(this.mEmpty.func_77973_b());
                    ST.meta_(aStack, ST.meta_(this.mEmpty));
                }
            }
            return true;
        }
        return false;
    }

    private boolean colorize(World aWorld, int aX, int aY, int aZ, byte aSide) {
        Block aBlock = aWorld.func_147439_a(aX, aY, aZ);
        if (aBlock != CS.NB && (this.mAllowedVanillaBlocks.contains(aBlock) || aBlock instanceof BlockColored || IL.TE_Rockwool.block() == aBlock || aBlock == CS.BlocksGT.Grass)) {
            if (aBlock == Blocks.field_150405_ch) {
                return aWorld.func_147465_d(aX, aY, aZ, Blocks.field_150406_ce, ~this.mColor & 0xF, 3);
            }
            if (aBlock == Blocks.field_150410_aZ) {
                return aWorld.func_147465_d(aX, aY, aZ, (Block)Blocks.field_150397_co, ~this.mColor & 0xF, 3);
            }
            if (aBlock == Blocks.field_150359_w) {
                return aWorld.func_147465_d(aX, aY, aZ, (Block)Blocks.field_150399_cn, ~this.mColor & 0xF, 3);
            }
            if (aBlock == Blocks.field_150349_c || aBlock == CS.BlocksGT.Grass) {
                switch (this.mColor) {
                    case 2: {
                        return aWorld.func_147465_d(aX, aY, aZ, (Block)CS.BlocksGT.Grass, 0, 3);
                    }
                    case 10: {
                        return aWorld.func_147465_d(aX, aY, aZ, (Block)CS.BlocksGT.Grass, 1, 3);
                    }
                    case 0: {
                        return aWorld.func_147465_d(aX, aY, aZ, (Block)CS.BlocksGT.Grass, 2, 3);
                    }
                    case 7: {
                        return aWorld.func_147465_d(aX, aY, aZ, (Block)CS.BlocksGT.Grass, 3, 3);
                    }
                    case 11: {
                        return aWorld.func_147465_d(aX, aY, aZ, (Block)CS.BlocksGT.Grass, 4, 3);
                    }
                    case 3: {
                        return aWorld.func_147465_d(aX, aY, aZ, (Block)CS.BlocksGT.Grass, 5, 3);
                    }
                }
                return false;
            }
            return aWorld.func_72805_g(aX, aY, aZ) != (~this.mColor & 0xF) && aWorld.func_72921_c(aX, aY, aZ, ~this.mColor & 0xF, 3);
        }
        return aBlock.recolourBlock(aWorld, aX, aY, aZ, CS.FORGE_DIR[aSide], ~this.mColor & 0xF);
    }

    @Override
    public List<String> getAdditionalToolTips(MultiItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(LH.get("gt.behaviour.paintspray." + this.mColor + ".tooltip"));
        NBTTagCompound tNBT = aStack.func_77978_p();
        long tRemaining = ST.equal(aStack, this.mFull, true) ? this.mUses : (tNBT == null ? 0L : tNBT.func_74763_f("gt.remaining"));
        aList.add(LH.get("gt.behaviour.paintspray.uses") + " " + tRemaining / 10L + "." + tRemaining % 10L);
        aList.add(LH.get("gt.behaviour.unstackable"));
        return aList;
    }

    static {
        LH.add("gt.behaviour.paintspray.uses", "Remaining Uses:");
        LH.add("gt.behaviour.unstackable", "Not usable when stacked!");
    }
}

