/*
 * Decompiled with CFR 0.152.
 */
package gregapi.worldgen.dungeon;

import gregapi.block.IBlockPlacable;
import gregapi.block.IPrefixBlock;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.MD;
import gregapi.data.MT;
import gregapi.fluid.FluidTankGT;
import gregapi.oredict.OreDictMaterial;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.worldgen.dungeon.DungeonChunkRoomVault;
import gregapi.worldgen.dungeon.DungeonData;
import net.minecraft.block.Block;
import net.minecraftforge.fluids.FluidStack;

public class DungeonChunkRoomStorage
extends DungeonChunkRoomVault {
    public static OreDictMaterial[] sHexoriums = new OreDictMaterial[]{MT.HexoriumRed, MT.HexoriumGreen, MT.HexoriumBlue, MT.HexoriumWhite, MT.HexoriumBlack};
    public static OreDictMaterial[] sInfused = new OreDictMaterial[]{MT.InfusedFire, MT.InfusedAir, MT.InfusedWater, MT.InfusedEarth, MT.InfusedEntropy, MT.InfusedOrder};
    public static OreDictMaterial[] sDusts = new OreDictMaterial[]{MT.NaCl, MT.NaCl, MT.KCl, MT.KCl, MT.Gunpowder, MT.Gunpowder, MT.Gunpowder, MT.Bone, MT.Bone, MT.Asphalt, MT.Asphalt, MT.Clay, MT.ClayBrown, MT.ClayRed, MT.Bentonite, MT.Palygorskite, MT.Kaolinite, MT.Porcelain, MT.RareEarth, MT.Sugar, MT.Cocoa, MT.Coffee, MT.Vanilla, MT.PepperBlack, MT.Curry, MT.Wheat, MT.Barley, MT.Rye, MT.Rice, MT.Oat, MT.OatAbyssal, MT.Corn, MT.Potato, MT.WaxBee, MT.WaxRefractory, MT.Blaze, MT.Breeze, MT.Blizz, MT.Blitz, MT.Basalz};
    public static OreDictMaterial[] sWoods = new OreDictMaterial[]{MT.WOODS.Oak, MT.WOODS.Birch, MT.WOODS.Spruce, MT.WOODS.Jungle, MT.WOODS.Acacia, MT.WOODS.DarkOak, MT.WOODS.Crimson, MT.WOODS.Warped, MT.WOODS.Compressed, MT.WoodRubber, MT.WOODS.Maple, MT.WOODS.Willow, MT.WOODS.BlueMahoe, MT.WOODS.Hazel, MT.WOODS.Cinnamon, MT.WOODS.Coconut, MT.WOODS.Rainbowood, MT.WOODS.BlueSpruce, MT.Livingwood, MT.Greatwood, MT.Silverwood, MT.WoodTreated, MT.Weedwood, MT.Skyroot};
    public static OreDictMaterial[] sGems = new OreDictMaterial[]{MT.EnderPearl, MT.EnderPearl, MT.EnderEye, MT.Diamond, MT.DiamondPink, MT.Emerald, MT.Aquamarine, MT.Ruby, MT.GreenSapphire, MT.BlueSapphire, MT.Amethyst, MT.Craponite, MT.Amber, MT.VoidQuartz, MT.NetherQuartz, MT.NetherQuartz, MT.MilkyQuartz, MT.MilkyQuartz, MT.CertusQuartz, MT.ChargedCertusQuartz, MT.Lapis, MT.Lapis, MT.Lapis, MT.Redstone, MT.Redstone, MT.Redstone, MT.Glowstone, MT.Glowstone, MT.Gloomstone, MT.Apatite, MT.Apatite, MT.Apatite, MT.Coal, MT.Coal, MT.Coal, MT.Coal, MT.Coal, MT.Charcoal, MT.Charcoal, MT.Charcoal, MT.Charcoal, MT.Charcoal, MT.Lignite, MT.Lignite, MT.Lignite, MT.Lignite, MT.Lignite};
    public static OreDictMaterial[] sMetals = new OreDictMaterial[]{MT.Cu, MT.Cu, MT.Sn, MT.Bronze, MT.Fe, MT.Fe, MT.Fe, MT.Steel, MT.Steel, MT.StainlessSteel, MT.StainlessSteel, MT.DamascusSteel};
    public static OreDictMaterial[] sOres = new OreDictMaterial[]{MT.TiO2, MT.TiO2, MT.MnO2, MT.MnO2, MT.MnO2, MT.Fe2O3, MT.Fe2O3, MT.Fe2O3, MT.Fe2O3, MT.Fe2O3, MT.OREMATS.Cassiterite, MT.OREMATS.Cassiterite, MT.OREMATS.Cassiterite, MT.OREMATS.Cassiterite, MT.OREMATS.Cassiterite, MT.OREMATS.Zeolite, MT.OREMATS.Pollucite, MT.OREMATS.Borax, MT.OREMATS.BrownLimonite, MT.OREMATS.YellowLimonite, MT.OREMATS.Garnierite, MT.OREMATS.Scheelite, MT.OREMATS.Wolframite, MT.OREMATS.Ferberite, MT.OREMATS.Huebnerite, MT.OREMATS.Tungstate, MT.OREMATS.Realgar, MT.OREMATS.Cinnabar, MT.OREMATS.Molybdenite, MT.OREMATS.Sphalerite, MT.OREMATS.Stibnite, MT.OREMATS.Pentlandite, MT.OREMATS.Chalcopyrite, MT.OREMATS.Arsenopyrite, MT.OREMATS.Cobaltite, MT.OREMATS.Galena, MT.OREMATS.Cooperite, MT.OREMATS.Tetrahedrite, MT.OREMATS.Kesterite, MT.OREMATS.Stannite, MT.OREMATS.Barite, MT.OREMATS.Celestine, MT.OREMATS.Ilmenite, MT.OREMATS.Bauxite, MT.OREMATS.Chromite, MT.OREMATS.Powellite, MT.OREMATS.Wulfenite, MT.OREMATS.Ferrovanadium, MT.OREMATS.Bastnasite, MT.OREMATS.Coltan, MT.OREMATS.Malachite, MT.OREMATS.Bromargyrite, MT.OREMATS.Smithsonite, MT.OREMATS.Sperrylite};

    @Override
    public boolean generate(DungeonData aData) {
        int k;
        int j;
        int i;
        int tType;
        if (!super.generate(aData)) {
            return false;
        }
        Block tInfusedCrystal = ST.block(MD.TC, "blockCrystal");
        Block tHexoriumColor = ST.block(MD.HEX, UT.Code.select((long)aData.mColor, "blockEnergizedHexoriumMonolithRainbow", CS.HEXORIUM_MONOLITHS));
        Block tHexoriumRandom = ST.block(MD.HEX, UT.Code.select("blockEnergizedHexoriumMonolithRainbow", CS.HEXORIUM_MONOLITHS));
        FluidStack[][] tFluids = new FluidStack[][]{{FL.Oil_Creosote.make(16000L), FL.Oil_Seed.make(16000L), FL.lube(16000L), FL.Glue.make(16000L), FL.Latex.make(16000L), FL.Water.make(16000L), FL.Purple_Drink.make(16000L)}, {FL.Oil_Creosote.make(32000L), FL.Oil_Seed.make(32000L), FL.lube(32000L), FL.Glue.make(32000L), FL.Latex.make(32000L), FL.Holywater.make(32000L), FL.Purple_Drink.make(32000L)}, {FL.Oil_Normal.make(64000L), FL.Oil_Normal.make(64000L), FL.Oil_Soulsand.make(64000L), FL.Oil_Light.make(64000L), FL.Oil_Medium.make(64000L), FL.Oil_Heavy.make(64000L), FL.Oil_ExtraHeavy.make(64000L)}};
        short[] tIDs = new short[]{32714, 32734, 32102};
        if (aData.mRoomLayout[aData.mRoomX + 1][aData.mRoomZ] == 0 && aData.next1in2()) {
            tType = aData.next(tIDs.length);
            for (i = 0; i < 3; ++i) {
                block30: for (j = 0; j < 4; ++j) {
                    if (aData.next1in2()) {
                        for (k = 0; k < 4; ++k) {
                            aData.set(12 + i, 1 + k, 6 + j, (byte)6, (long)tIDs[tType], new FluidTankGT(UT.Code.select(CS.NF, tFluids[tType])).writeToNBT(UT.NBT.make(), "gt.tank"), true, true);
                            if (aData.next2in3()) continue block30;
                        }
                        continue;
                    }
                    if (!aData.next1in2()) continue;
                    switch (aData.next(3)) {
                        case 0: {
                            aData.set(12 + i, 1, 6 + j, (byte)6, 32055L, new FluidTankGT(FL.Propane.make(8000L)).writeToNBT(UT.NBT.make("gt.color", (Object)CS.DYE_INT_Red, "gt.painted", true), "gt.tank"), true, true);
                            continue block30;
                        }
                        case 1: {
                            aData.set(12 + i, 1, 6 + j, (byte)6, 32056L, new FluidTankGT(FL.Oxygen.make(8000L)).writeToNBT(UT.NBT.make("gt.color", (Object)CS.DYE_INT_LightBlue, "gt.painted", true), "gt.tank"), true, true);
                            continue block30;
                        }
                        case 2: {
                            aData.set(12 + i, 1, 6 + j, (byte)6, 32056L, new FluidTankGT(FL.Helium.make(8000L)).writeToNBT(UT.NBT.make("gt.color", (Object)CS.DYE_INT_Yellow, "gt.painted", true), "gt.tank"), true, true);
                        }
                    }
                }
            }
        }
        if (aData.mRoomLayout[aData.mRoomX - 1][aData.mRoomZ] == 0 && aData.next1in2()) {
            tType = aData.next(tIDs.length);
            for (i = 0; i < 3; ++i) {
                block33: for (j = 0; j < 4; ++j) {
                    if (aData.next1in2()) {
                        for (k = 0; k < 4; ++k) {
                            aData.set(1 + i, 1 + k, 6 + j, (byte)6, (long)tIDs[tType], new FluidTankGT(UT.Code.select(CS.NF, tFluids[tType])).writeToNBT(UT.NBT.make(), "gt.tank"), true, true);
                            if (aData.next2in3()) continue block33;
                        }
                        continue;
                    }
                    if (!aData.next1in2()) continue;
                    switch (aData.next(3)) {
                        case 0: {
                            aData.set(1 + i, 1, 6 + j, (byte)6, 32055L, new FluidTankGT(FL.Propane.make(8000L)).writeToNBT(UT.NBT.make("gt.color", (Object)CS.DYE_INT_Red, "gt.painted", true), "gt.tank"), true, true);
                            continue block33;
                        }
                        case 1: {
                            aData.set(1 + i, 1, 6 + j, (byte)6, 32056L, new FluidTankGT(FL.Oxygen.make(8000L)).writeToNBT(UT.NBT.make("gt.color", (Object)CS.DYE_INT_LightBlue, "gt.painted", true), "gt.tank"), true, true);
                            continue block33;
                        }
                        case 2: {
                            aData.set(1 + i, 1, 6 + j, (byte)6, 32056L, new FluidTankGT(FL.Helium.make(8000L)).writeToNBT(UT.NBT.make("gt.color", (Object)CS.DYE_INT_Yellow, "gt.painted", true), "gt.tank"), true, true);
                        }
                    }
                }
            }
        }
        if (aData.mRoomLayout[aData.mRoomX][aData.mRoomZ + 1] == 0 && aData.next1in2()) {
            tType = aData.next(tIDs.length);
            for (i = 0; i < 4; ++i) {
                block36: for (j = 0; j < 3; ++j) {
                    if (aData.next1in2()) {
                        for (k = 0; k < 4; ++k) {
                            aData.set(6 + i, 1 + k, 12 + j, (byte)6, (long)tIDs[tType], new FluidTankGT(UT.Code.select(CS.NF, tFluids[tType])).writeToNBT(UT.NBT.make(), "gt.tank"), true, true);
                            if (aData.next2in3()) continue block36;
                        }
                        continue;
                    }
                    if (!aData.next1in2()) continue;
                    switch (aData.next(3)) {
                        case 0: {
                            aData.set(6 + i, 1, 12 + j, (byte)6, 32055L, new FluidTankGT(FL.Propane.make(8000L)).writeToNBT(UT.NBT.make("gt.color", (Object)CS.DYE_INT_Red, "gt.painted", true), "gt.tank"), true, true);
                            continue block36;
                        }
                        case 1: {
                            aData.set(6 + i, 1, 12 + j, (byte)6, 32056L, new FluidTankGT(FL.Oxygen.make(8000L)).writeToNBT(UT.NBT.make("gt.color", (Object)CS.DYE_INT_LightBlue, "gt.painted", true), "gt.tank"), true, true);
                            continue block36;
                        }
                        case 2: {
                            aData.set(6 + i, 1, 12 + j, (byte)6, 32056L, new FluidTankGT(FL.Helium.make(8000L)).writeToNBT(UT.NBT.make("gt.color", (Object)CS.DYE_INT_Yellow, "gt.painted", true), "gt.tank"), true, true);
                        }
                    }
                }
            }
        }
        if (aData.mRoomLayout[aData.mRoomX][aData.mRoomZ - 1] == 0 && aData.next1in2()) {
            tType = aData.next(tIDs.length);
            for (i = 0; i < 4; ++i) {
                block39: for (j = 0; j < 3; ++j) {
                    if (aData.next1in2()) {
                        for (k = 0; k < 4; ++k) {
                            aData.set(6 + i, 1 + k, 1 + j, (byte)6, (long)tIDs[tType], new FluidTankGT(UT.Code.select(CS.NF, tFluids[tType])).writeToNBT(UT.NBT.make(), "gt.tank"), true, true);
                            if (aData.next2in3()) continue block39;
                        }
                        continue;
                    }
                    if (!aData.next1in2()) continue;
                    switch (aData.next(3)) {
                        case 0: {
                            aData.set(6 + i, 1, 1 + j, (byte)6, 32055L, new FluidTankGT(FL.Propane.make(8000L)).writeToNBT(UT.NBT.make("gt.color", (Object)CS.DYE_INT_Red, "gt.painted", true), "gt.tank"), true, true);
                            continue block39;
                        }
                        case 1: {
                            aData.set(6 + i, 1, 1 + j, (byte)6, 32056L, new FluidTankGT(FL.Oxygen.make(8000L)).writeToNBT(UT.NBT.make("gt.color", (Object)CS.DYE_INT_LightBlue, "gt.painted", true), "gt.tank"), true, true);
                            continue block39;
                        }
                        case 2: {
                            aData.set(6 + i, 1, 1 + j, (byte)6, 32056L, new FluidTankGT(FL.Helium.make(8000L)).writeToNBT(UT.NBT.make("gt.color", (Object)CS.DYE_INT_Yellow, "gt.painted", true), "gt.tank"), true, true);
                        }
                    }
                }
            }
        }
        IBlockPlacable[] tMetalCrates = new IPrefixBlock[]{CS.BlocksGT.crateGtDust, CS.BlocksGT.crateGtDust, CS.BlocksGT.crateGtIngot, CS.BlocksGT.crateGtIngot, CS.BlocksGT.crateGtIngot, CS.BlocksGT.crateGtIngot, CS.BlocksGT.crateGtPlate, CS.BlocksGT.crateGtPlate, CS.BlocksGT.crateGt64Dust, CS.BlocksGT.crateGt64Plate, CS.BlocksGT.crateGt64Ingot, CS.BlocksGT.crateGt64Ingot};
        int[] tStart = new int[]{1, 12};
        int[] tEnd = new int[]{3, 14};
        for (int a = 0; a < 2; ++a) {
            block42: for (int b = 0; b < 2; ++b) {
                switch (aData.next(7 + (MD.HEX.mLoaded ? 1 : 0) + (MD.TC.mLoaded ? 1 : 0))) {
                    case 0: {
                        int j2;
                        int i2;
                        for (i2 = tStart[a]; i2 <= tEnd[a]; ++i2) {
                            for (j2 = tStart[b]; j2 <= tEnd[b]; ++j2) {
                                if (aData.next3in4()) {
                                    aData.set(tMetalCrates, i2, 1, j2, sMetals);
                                    if (aData.next2in3()) {
                                        aData.set(tMetalCrates, i2, 2, j2, sMetals);
                                        if (aData.next1in2()) {
                                            aData.set(tMetalCrates, i2, 3, j2, sMetals);
                                            if (!aData.next1in3()) continue;
                                            aData.ingots_or_plates(i2, 4, j2, 0L, sMetals);
                                            continue;
                                        }
                                        if (!aData.next1in3()) continue;
                                        aData.ingots_or_plates(i2, 3, j2, 0L, sMetals);
                                        continue;
                                    }
                                    if (!aData.next1in3()) continue;
                                    aData.ingots_or_plates(i2, 2, j2, 0L, sMetals);
                                    continue;
                                }
                                if (!aData.next1in3()) continue;
                                aData.ingots_or_plates(i2, 1, j2, 0L, sMetals);
                            }
                        }
                        continue block42;
                    }
                    case 1: {
                        int j2;
                        int i2;
                        for (i2 = tStart[a]; i2 <= tEnd[a]; ++i2) {
                            for (j2 = tStart[b]; j2 <= tEnd[b]; ++j2) {
                                if (!aData.next3in4()) continue;
                                aData.set((IBlockPlacable)(aData.next1in2() ? CS.BlocksGT.crateGt64Dust : CS.BlocksGT.crateGtDust), i2, 1, j2, sDusts);
                                if (!aData.next2in3()) continue;
                                aData.set((IBlockPlacable)(aData.next1in3() ? CS.BlocksGT.crateGt64Dust : CS.BlocksGT.crateGtDust), i2, 2, j2, sDusts);
                                if (!aData.next1in2()) continue;
                                aData.set((IBlockPlacable)(aData.next1in4() ? CS.BlocksGT.crateGt64Dust : CS.BlocksGT.crateGtDust), i2, 3, j2, sDusts);
                            }
                        }
                        continue block42;
                    }
                    case 2: {
                        int j2;
                        int i2;
                        for (i2 = tStart[a]; i2 <= tEnd[a]; ++i2) {
                            for (j2 = tStart[b]; j2 <= tEnd[b]; ++j2) {
                                if (!aData.next3in4()) continue;
                                aData.set((IBlockPlacable)(aData.next1in4() ? CS.BlocksGT.crateGt64Gem : CS.BlocksGT.crateGtGem), i2, 1, j2, sGems);
                                if (!aData.next2in3()) continue;
                                aData.set((IBlockPlacable)(aData.next1in6() ? CS.BlocksGT.crateGt64Gem : CS.BlocksGT.crateGtGem), i2, 2, j2, sGems);
                                if (!aData.next1in2()) continue;
                                aData.set((IBlockPlacable)(aData.next1in8() ? CS.BlocksGT.crateGt64Gem : CS.BlocksGT.crateGtGem), i2, 3, j2, sGems);
                            }
                        }
                        continue block42;
                    }
                    case 3: {
                        int j2;
                        int i2;
                        for (i2 = tStart[a]; i2 <= tEnd[a]; ++i2) {
                            for (j2 = tStart[b]; j2 <= tEnd[b]; ++j2) {
                                if (!aData.next3in4()) continue;
                                aData.set((IBlockPlacable)CS.BlocksGT.crateGt64Plate, i2, 1, j2, sWoods);
                                if (!aData.next2in3()) continue;
                                aData.set((IBlockPlacable)CS.BlocksGT.crateGt64Plate, i2, 2, j2, sWoods);
                                if (!aData.next1in2()) continue;
                                aData.set((IBlockPlacable)CS.BlocksGT.crateGt64Plate, i2, 3, j2, sWoods);
                            }
                        }
                        continue block42;
                    }
                    case 4: {
                        int j2;
                        int i2;
                        for (i2 = tStart[a]; i2 <= tEnd[a]; ++i2) {
                            for (j2 = tStart[b]; j2 <= tEnd[b]; ++j2) {
                                if (aData.next3in4()) {
                                    aData.set((IBlockPlacable)(aData.next1in2() ? CS.BlocksGT.crateGt64Raw : CS.BlocksGT.crateGtRaw), i2, 1, j2, sOres);
                                    if (aData.next2in3()) {
                                        aData.set((IBlockPlacable)(aData.next1in3() ? CS.BlocksGT.crateGt64Raw : CS.BlocksGT.crateGtRaw), i2, 2, j2, sOres);
                                        if (aData.next1in2()) {
                                            aData.set((IBlockPlacable)(aData.next1in4() ? CS.BlocksGT.crateGt64Raw : CS.BlocksGT.crateGtRaw), i2, 3, j2, sOres);
                                            if (!aData.next1in4()) continue;
                                            aData.set((IBlockPlacable)CS.BlocksGT.blockRaw, i2, 4, j2, sOres);
                                            continue;
                                        }
                                        if (!aData.next1in4()) continue;
                                        aData.set((IBlockPlacable)CS.BlocksGT.blockRaw, i2, 3, j2, sOres);
                                        continue;
                                    }
                                    if (!aData.next1in4()) continue;
                                    aData.set((IBlockPlacable)CS.BlocksGT.blockRaw, i2, 2, j2, sOres);
                                    continue;
                                }
                                if (!aData.next1in4()) continue;
                                aData.set((IBlockPlacable)CS.BlocksGT.blockRaw, i2, 1, j2, sOres);
                            }
                        }
                        continue block42;
                    }
                    case 5: {
                        int j2;
                        int i2;
                        if (!MD.HEX.mLoaded) continue block42;
                        for (i2 = tStart[a]; i2 <= tEnd[a]; ++i2) {
                            for (j2 = tStart[b]; j2 <= tEnd[b]; ++j2) {
                                if (aData.next1in2()) {
                                    aData.set((IBlockPlacable)(aData.next1in2() ? CS.BlocksGT.crateGt64Gem : CS.BlocksGT.crateGtGem), i2, 1, j2, sHexoriums);
                                    if (aData.next1in2()) {
                                        aData.set((IBlockPlacable)(aData.next1in3() ? CS.BlocksGT.crateGt64Gem : CS.BlocksGT.crateGtGem), i2, 2, j2, sHexoriums);
                                        if (aData.next1in2()) {
                                            aData.set((IBlockPlacable)(aData.next1in4() ? CS.BlocksGT.crateGt64Gem : CS.BlocksGT.crateGtGem), i2, 3, j2, sHexoriums);
                                            if (!aData.next1in2()) continue;
                                            aData.set(i2, 4, j2, tHexoriumColor, 1, tHexoriumRandom, 1);
                                            continue;
                                        }
                                        if (!aData.next1in2()) continue;
                                        aData.set(i2, 3, j2, tHexoriumColor, 1, tHexoriumRandom, 1);
                                        continue;
                                    }
                                    if (!aData.next1in2()) continue;
                                    aData.set(i2, 2, j2, tHexoriumColor, 1, tHexoriumRandom, 1);
                                    continue;
                                }
                                if (!aData.next1in2()) continue;
                                aData.set(i2, 1, j2, tHexoriumColor, 1, tHexoriumRandom, 1);
                            }
                        }
                        continue block42;
                    }
                    case 6: {
                        int j2;
                        int i2;
                        if (!MD.TC.mLoaded) continue block42;
                        for (i2 = tStart[a]; i2 <= tEnd[a]; ++i2) {
                            for (j2 = tStart[b]; j2 <= tEnd[b]; ++j2) {
                                if (aData.next1in2()) {
                                    aData.set((IBlockPlacable)(aData.next1in4() ? CS.BlocksGT.crateGt64Gem : CS.BlocksGT.crateGtGem), i2, 1, j2, sInfused);
                                    if (aData.next1in2()) {
                                        aData.set((IBlockPlacable)(aData.next1in6() ? CS.BlocksGT.crateGt64Gem : CS.BlocksGT.crateGtGem), i2, 2, j2, sInfused);
                                        if (aData.next1in2()) {
                                            aData.set((IBlockPlacable)(aData.next1in8() ? CS.BlocksGT.crateGt64Gem : CS.BlocksGT.crateGtGem), i2, 3, j2, sInfused);
                                            if (!aData.next1in2()) continue;
                                            aData.set(i2, 4, j2, tInfusedCrystal, aData.next(7));
                                            continue;
                                        }
                                        if (!aData.next1in2()) continue;
                                        aData.set(i2, 3, j2, tInfusedCrystal, aData.next(7));
                                        continue;
                                    }
                                    if (!aData.next1in2()) continue;
                                    aData.set(i2, 2, j2, tInfusedCrystal, aData.next(7));
                                    continue;
                                }
                                if (!aData.next1in2()) continue;
                                aData.set(i2, 1, j2, tInfusedCrystal, aData.next(7));
                            }
                        }
                        continue block42;
                    }
                }
            }
        }
        return true;
    }
}

