/*
 * Decompiled with CFR 0.152.
 */
package gregapi.worldgen;

import gregapi.code.BiomeNameSet;
import gregapi.data.CS;
import gregapi.data.MT;
import gregapi.oredict.OreDictMaterial;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.worldgen.StoneLayer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class StoneLayerOres {
    public boolean mGenerateIndicators;
    public int mMinY;
    public int mMaxY;
    public byte mMeta;
    public OreDictMaterial mMaterial;
    public Block mBlock;
    public long mChance;
    public BiomeNameSet mTargetBiomes = new BiomeNameSet(new Object[0]);
    @Deprecated
    public ArrayList<String> mBiomes = new ArrayList();

    public StoneLayerOres(OreDictMaterial aMaterial, long aChance, int aMinY, int aMaxY, Collection ... aBiomes) {
        this(aMaterial, true, aChance, aMinY, aMaxY, CS.NB, 0L, aBiomes);
    }

    public StoneLayerOres(OreDictMaterial aMaterial, long aChance, int aMinY, int aMaxY, Block aBlock, Collection ... aBiomes) {
        this(aMaterial, true, aChance, aMinY, aMaxY, aBlock, 0L, aBiomes);
    }

    public StoneLayerOres(OreDictMaterial aMaterial, long aChance, int aMinY, int aMaxY, Block aBlock, long aMeta, Collection ... aBiomes) {
        this(aMaterial, true, aChance, aMinY, aMaxY, aBlock, aMeta, aBiomes);
    }

    public StoneLayerOres(OreDictMaterial aMaterial, boolean aGenerateIndicators, long aChance, int aMinY, int aMaxY, Collection ... aBiomes) {
        this(aMaterial, aGenerateIndicators, aChance, aMinY, aMaxY, CS.NB, 0L, aBiomes);
    }

    public StoneLayerOres(OreDictMaterial aMaterial, boolean aGenerateIndicators, long aChance, int aMinY, int aMaxY, Block aBlock, Collection ... aBiomes) {
        this(aMaterial, aGenerateIndicators, aChance, aMinY, aMaxY, aBlock, 0L, aBiomes);
    }

    public StoneLayerOres(OreDictMaterial aMaterial, boolean aGenerateIndicators, long aChance, int aMinY, int aMaxY, Block aBlock, long aMeta, Collection ... aBiomes) {
        this(aMaterial, aGenerateIndicators, aChance, aMinY, aMaxY, aBlock, aMeta, CS.NB, 0L, aBiomes);
    }

    public StoneLayerOres(OreDictMaterial aMaterial, boolean aGenerateIndicators, long aChance, int aMinY, int aMaxY, Block aBlock1, long aMeta1, Block aBlock2, long aMeta2, Collection ... aBiomes) {
        this.mMaterial = aMaterial != null && aMaterial.mID > 0 ? aMaterial : MT.Empty;
        this.mChance = UT.Code.bind(1L, 648648000L, aChance);
        if (!ST.valid(aBlock1)) {
            aBlock1 = aBlock2;
            aMeta1 = aMeta2;
        }
        this.mBlock = aBlock1 == CS.NB ? null : aBlock1;
        this.mMeta = UT.Code.bind4(aMeta1);
        this.mGenerateIndicators = aGenerateIndicators;
        for (Collection aBiome : aBiomes) {
            this.mTargetBiomes.addAll(aBiome);
        }
        if (aMinY > aMaxY) {
            this.mMinY = aMaxY;
            this.mMaxY = aMinY;
        } else {
            this.mMinY = aMinY;
            this.mMaxY = aMaxY;
        }
    }

    public boolean check(StoneLayer aLayer, World aWorld, int aX, int aY, int aZ, BiomeGenBase aBiome, int aRandomNumber) {
        return aY >= this.mMinY && aY <= this.mMaxY && (long)aRandomNumber < this.mChance && (this.mTargetBiomes.isEmpty() || this.mTargetBiomes.contains(aBiome));
    }

    public boolean check(StoneLayer aLayer, World aWorld, int aX, int aY, int aZ, BiomeGenBase aBiome, Random aRandom) {
        return aY >= this.mMinY && aY <= this.mMaxY && (long)aRandom.nextInt(648648000) < this.mChance && (this.mTargetBiomes.isEmpty() || this.mTargetBiomes.contains(aBiome));
    }

    public boolean check(StoneLayer aLayer, World aWorld, int aX, int aY, int aZ, BiomeGenBase aBiome) {
        return aY >= this.mMinY && aY <= this.mMaxY && (long)CS.RNGSUS.nextInt(648648000) < this.mChance && (this.mTargetBiomes.isEmpty() || this.mTargetBiomes.contains(aBiome));
    }

    public boolean set(StoneLayer aLayer, World aWorld, int aX, int aY, int aZ, BiomeGenBase aBiome, Random aRandom) {
        if (this.mBlock != null) {
            return aWorld.func_147465_d(aX, aY, aZ, this.mBlock, (int)this.mMeta, 0);
        }
        return aY == this.mMinY || aY == this.mMaxY || aRandom.nextBoolean() ? this.small(aLayer, aWorld, aX, aY, aZ, aBiome) : this.normal(aLayer, aWorld, aX, aY, aZ, aBiome);
    }

    public boolean set(StoneLayer aLayer, World aWorld, int aX, int aY, int aZ, BiomeGenBase aBiome) {
        if (this.mBlock != null) {
            return aWorld.func_147465_d(aX, aY, aZ, this.mBlock, (int)this.mMeta, 0);
        }
        return aY == this.mMinY || aY == this.mMaxY || CS.RNGSUS.nextBoolean() ? this.small(aLayer, aWorld, aX, aY, aZ, aBiome) : this.normal(aLayer, aWorld, aX, aY, aZ, aBiome);
    }

    public boolean normal(StoneLayer aLayer, World aWorld, int aX, int aY, int aZ, BiomeGenBase aBiome) {
        if (this.mBlock != null) {
            return aWorld.func_147465_d(aX, aY, aZ, this.mBlock, (int)this.mMeta, 0);
        }
        return aLayer.mOre != null && aLayer.mOre.placeBlock(aWorld, aX, aY, aZ, (byte)6, this.mMaterial.mID, null, false, true);
    }

    public boolean small(StoneLayer aLayer, World aWorld, int aX, int aY, int aZ, BiomeGenBase aBiome) {
        if (this.mBlock != null) {
            return aWorld.func_147465_d(aX, aY, aZ, this.mBlock, (int)this.mMeta, 0);
        }
        return aLayer.mOreSmall != null && aLayer.mOreSmall.placeBlock(aWorld, aX, aY, aZ, (byte)6, this.mMaterial.mID, null, false, true);
    }

    public boolean broken(StoneLayer aLayer, World aWorld, int aX, int aY, int aZ, BiomeGenBase aBiome) {
        if (this.mBlock != null) {
            return aWorld.func_147465_d(aX, aY, aZ, this.mBlock, (int)this.mMeta, 0);
        }
        return aLayer.mOreBroken != null && aLayer.mOreBroken.placeBlock(aWorld, aX, aY, aZ, (byte)6, this.mMaterial.mID, null, false, true);
    }
}

