/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.energy;

import gregapi.code.ArrayListNoNulls;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.behavior.TE_Behavior_Active_Trinary;
import gregapi.tileentity.behavior.TE_Behavior_Energy_Capacitor;
import gregapi.tileentity.behavior.TE_Behavior_Energy_Converter;
import gregapi.tileentity.behavior.TE_Behavior_Energy_Stats;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.machines.ITileEntityRunningActively;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileEntityBase10EnergyConverter
extends TileEntityBase09FacingSingle
implements ITileEntityEnergy,
ITileEntityRunningActively {
    protected boolean mStopped = false;
    protected boolean mNegativeInput = false;
    protected boolean oNegativeInput = false;
    protected byte mExplosionPrevention = 0;
    protected byte mMode = 0;
    public TE_Behavior_Energy_Stats mEnergyIN = null;
    public TE_Behavior_Energy_Stats mEnergyOUT = null;
    public TE_Behavior_Energy_Capacitor mStorage = null;
    public TE_Behavior_Energy_Converter mConverter = null;
    public TE_Behavior_Active_Trinary mActivity = null;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.stopped")) {
            this.mStopped = aNBT.func_74767_n("gt.stopped");
        }
        if (aNBT.func_74764_b("gt.mode")) {
            this.mMode = aNBT.func_74771_c("gt.mode");
        }
        this.mActivity = new TE_Behavior_Active_Trinary(this, aNBT);
        this.readEnergyBehavior(aNBT);
        this.readEnergyConverter(aNBT);
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setBoolean(aNBT, "gt.stopped", this.mStopped);
        aNBT.func_74774_a("gt.mode", this.mMode);
        this.mActivity.save(aNBT);
        this.writeEnergyBehavior(aNBT);
    }

    public void readEnergyBehavior(NBTTagCompound aNBT) {
        long tInput = aNBT.func_74763_f("gt.input");
        long tOutput = aNBT.func_74763_f("gt.output");
        this.mStorage = new TE_Behavior_Energy_Capacitor(this, aNBT, tInput * 2L);
        this.mEnergyIN = new TE_Behavior_Energy_Stats(this, aNBT, aNBT.func_74764_b("gt.energy.accepted") ? TagData.createTagData(aNBT.func_74779_i("gt.energy.accepted")) : TD.Energy.QU, this.mStorage, this.takesAnyLowerSize() || tInput <= 16L ? 1L : tInput / 2L, tInput, tInput * 2L);
        this.mEnergyOUT = new TE_Behavior_Energy_Stats(this, aNBT, aNBT.func_74764_b("gt.energy.emitted") ? TagData.createTagData(aNBT.func_74779_i("gt.energy.emitted")) : this.mEnergyIN.mType, this.mStorage, this.emitsAnyLowerSize() ? 1L : tOutput / 2L, tOutput, tOutput * 2L);
    }

    public void readEnergyConverter(NBTTagCompound aNBT) {
        this.mConverter = new TE_Behavior_Energy_Converter(this, aNBT, this.mStorage, this.mEnergyIN, this.mEnergyOUT, aNBT.func_74764_b("gt.multiplier") ? aNBT.func_74763_f("gt.multiplier") : 1L, aNBT.func_74767_n("gt.wasteenergy"), false, aNBT.func_74767_n("gt.limit.consumption"));
    }

    public void writeEnergyBehavior(NBTTagCompound aNBT) {
        this.mStorage.save(aNBT);
        this.mConverter.save(aNBT);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        this.addToolTipsEnergy(aList, aStack, aF3_H);
        this.addToolTipsEfficiency(aList, aStack, aF3_H);
        super.addToolTips(aList, aStack, aF3_H);
    }

    public void addToolTipsEnergy(List<String> aList, ItemStack aStack, boolean aF3_H) {
        this.mConverter.mEnergyIN.addToolTips(aList, aStack, aF3_H, this.getLocalisedInputSide(), false);
        this.mConverter.mEnergyOUT.addToolTips(aList, aStack, aF3_H, this.getLocalisedOutputSide(), true);
    }

    public void addToolTipsEfficiency(List<String> aList, ItemStack aStack, boolean aF3_H) {
        LH.addToolTipsEfficiency(aList, aStack, aF3_H, this.mConverter);
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            this.doConversion(aTimer);
            if (this.mTimer % 600L == 5L) {
                if (this.mActivity.mActive) {
                    this.doDefaultStructuralChecks();
                } else if (this.mExplosionPrevention > 0) {
                    this.mExplosionPrevention = (byte)(this.mExplosionPrevention - 1);
                }
            }
        } else if (this.mActivity.mState != 0 && (this.mEnergyIN.mType == TD.Energy.RU || this.mEnergyOUT.mType == TD.Energy.RU) && WD.random(this, 20, CS.CLIENT_TIME)) {
            UT.Sounds.play("minecart.base", 1, 0.2f, this.getCoords());
        }
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return this.mActivity.check(this.mStopped) || this.mNegativeInput != this.oNegativeInput || super.onTickCheck(aTimer);
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oNegativeInput = this.mNegativeInput;
    }

    @Override
    public void setVisualData(byte aData) {
        this.mActivity.mState = (byte)(aData & 0x7F);
        this.mNegativeInput = aData < 0;
    }

    @Override
    public byte getVisualData() {
        return (byte)(this.mActivity.mState | (byte)(this.mNegativeInput ? CS.B[7] : 0));
    }

    public void doConversion(long aTimer) {
        this.mActivity.mActive = this.mConverter.doConversion(aTimer, this, (byte)6, this.mMode, this.mNegativeInput && TD.Energy.ALL_NEGATIVE_ALLOWED.contains(this.mEnergyIN.mType) && TD.Energy.ALL_NEGATIVE_ALLOWED.contains(this.mEnergyOUT.mType));
        if (this.mConverter.mOverloaded) {
            this.overload(this.mStorage.mEnergy, this.mConverter.mEnergyOUT.mType);
            this.mConverter.mOverloaded = false;
            this.mStorage.mEnergy = 0L;
        }
    }

    @Override
    public long doInject(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoInject) {
        if (aDoInject) {
            this.mNegativeInput = aSize < 0L;
        }
        long tConsumed = this.mConverter.mEnergyIN.doInject(aSize, aAmount, aDoInject);
        if (this.mConverter.mEnergyIN.mOverloaded) {
            this.overload(aSize, aEnergyType);
            this.mConverter.mEnergyIN.mOverloaded = false;
        }
        return tConsumed;
    }

    public void overload(long aSize, TagData aEnergyType) {
        if (this.mExplosionPrevention < 100) {
            if (this.mTimer < 100L) {
                CS.DEB.println("Machine overloaded on startup with: " + aSize + " " + aEnergyType.getLocalisedNameLong());
            }
            this.mExplosionPrevention = (byte)(this.mExplosionPrevention + 1);
            this.mStorage.mEnergy = 0L;
        } else {
            this.overcharge(aSize, aEnergyType);
        }
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return (aEmitting ? this.mConverter.mEnergyOUT : this.mConverter.mEnergyIN).isType(aEnergyType);
    }

    @Override
    public boolean isEnergyAcceptingFrom(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return !(!aTheoretical && (this.mStopped || !this.mConverter.mWasteEnergy && this.mConverter.mEmitsEnergy != this.mConverter.mCanEmitEnergy) || !CS.SIDES_INVALID[aSide] && !this.isInput(aSide) || !super.isEnergyAcceptingFrom(aEnergyType, aSide, aTheoretical));
    }

    @Override
    public boolean isEnergyEmittingTo(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return (CS.SIDES_INVALID[aSide] || this.isOutput(aSide)) && super.isEnergyEmittingTo(aEnergyType, aSide, aTheoretical);
    }

    @Override
    public long getEnergySizeOutputMin(TagData aEnergyType, byte aSide) {
        return this.mConverter.mEnergyOUT.sizeMin(aEnergyType);
    }

    @Override
    public long getEnergySizeOutputRecommended(TagData aEnergyType, byte aSide) {
        return this.mConverter.mEnergyOUT.sizeRec(aEnergyType);
    }

    @Override
    public long getEnergySizeOutputMax(TagData aEnergyType, byte aSide) {
        return this.mConverter.mEnergyOUT.sizeMax(aEnergyType);
    }

    @Override
    public long getEnergySizeInputMin(TagData aEnergyType, byte aSide) {
        return this.mConverter.mEnergyIN.sizeMin(aEnergyType);
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, byte aSide) {
        return this.mConverter.mEnergyIN.sizeRec(aEnergyType);
    }

    @Override
    public long getEnergySizeInputMax(TagData aEnergyType, byte aSide) {
        return this.mConverter.mEnergyIN.sizeMax(aEnergyType);
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return new ArrayListNoNulls<TagData>(false, this.mConverter.mEnergyIN.mType, this.mConverter.mEnergyOUT.mType);
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    @Override
    public boolean getStateRunningPossible() {
        return true;
    }

    @Override
    public boolean getStateRunningPassively() {
        return this.mActivity.mActive;
    }

    @Override
    public boolean getStateRunningActively() {
        return this.mConverter.mEmitsEnergy;
    }

    public boolean setAdjacentOnOff(boolean aOnOff) {
        if (this.mConverter.mWasteEnergy) {
            this.mStopped = !aOnOff;
        }
        return !this.mStopped;
    }

    public boolean setStateOnOff(boolean aOnOff) {
        this.mStopped = !aOnOff;
        return !this.mStopped;
    }

    public boolean getStateOnOff() {
        return !this.mStopped;
    }

    public byte setStateMode(byte aMode) {
        this.mMode = aMode;
        return this.mMode;
    }

    public byte getStateMode() {
        return this.mMode;
    }

    public boolean takesAnyLowerSize() {
        return false;
    }

    public boolean emitsAnyLowerSize() {
        return false;
    }

    public boolean isInput(byte aSide) {
        return aSide != this.mFacing;
    }

    public boolean isOutput(byte aSide) {
        return aSide == this.mFacing;
    }

    public String getLocalisedInputSide() {
        return LH.get("gt.lang.face.any.but.front");
    }

    public String getLocalisedOutputSide() {
        return LH.get("gt.lang.face.front");
    }
}

