/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.base;

import gregapi.block.multitileentity.MultiTileEntityContainer;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.tileentity.ITileEntityMachineBlockUpdateable;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class TileEntityBase10FacingDouble
extends TileEntityBase09FacingSingle {
    public byte mSecondFacing = this.getDefaultSecondSide();

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.facing.2nd")) {
            this.mSecondFacing = aNBT.func_74771_c("gt.facing.2nd");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        aNBT.func_74774_a("gt.facing.2nd", this.mSecondFacing);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        if (this.getFacingTool() != null) {
            aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.x.to.toggle.facing.pre") + LH.get("gt.lang.tool.name." + this.getFacingTool(), "Unknown") + LH.get("gt.lang.use.x.to.toggle.facing.post"));
        }
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.x.to.toggle.facing2.pre") + LH.get("gt.lang.tool.name.monkeywrench", "Monkey Wrench") + LH.get("gt.lang.use.x.to.toggle.facing2.post"));
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        byte aTargetSide;
        if (this.isClientSide()) {
            return 0L;
        }
        if (this.getFacingTool() != null && aTool.equals(this.getFacingTool())) {
            aTargetSide = UT.Code.getSideWrenching(aSide, aHitX, aHitY, aHitZ);
            if (this.getValidSides()[aTargetSide]) {
                byte oFacing = this.mFacing;
                byte oSecondFacing = this.mSecondFacing;
                this.mFacing = aTargetSide;
                if (!this.getValidSecondSides()[this.mSecondFacing]) {
                    this.mSecondFacing = CS.OPOS[this.mFacing];
                    if (!this.getValidSecondSides()[this.mSecondFacing]) {
                        byte[] byArray = CS.ALL_SIDES_VALID;
                        int n = byArray.length;
                        for (int i = 0; i < n; ++i) {
                            byte tSide;
                            this.mSecondFacing = tSide = byArray[i];
                            if (this.getValidSecondSides()[this.mSecondFacing]) break;
                        }
                    }
                }
                this.updateClientData();
                this.causeBlockUpdate();
                this.onFacingChange(oFacing, oSecondFacing);
                this.checkCoverValidity();
                this.doEnetUpdate();
                if (this.hasMultiBlockMachineRelevantData()) {
                    ITileEntityMachineBlockUpdateable.Util.causeMachineUpdate(this, false);
                }
                return 10000L;
            }
        }
        if (aTool.equals("monkeywrench")) {
            aTargetSide = UT.Code.getSideWrenching(aSide, aHitX, aHitY, aHitZ);
            if (this.getValidSecondSides()[aTargetSide]) {
                byte oSecondFacing = this.mSecondFacing;
                this.mSecondFacing = aTargetSide;
                this.updateClientData();
                this.causeBlockUpdate();
                this.onFacingChange(this.mFacing, oSecondFacing);
                this.checkCoverValidity();
                this.doEnetUpdate();
                if (this.hasMultiBlockMachineRelevantData()) {
                    ITileEntityMachineBlockUpdateable.Util.causeMachineUpdate(this, false);
                }
                return 10000L;
            }
        }
        return 0L;
    }

    @Override
    public boolean onPlaced(ItemStack aStack, EntityPlayer aPlayer, MultiTileEntityContainer aMTEContainer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        this.mFacing = this.useInversePlacementRotation(aStack, aPlayer, aWorld, aX, aY, aZ, aSide, aHitX, aHitY, aHitZ) ? UT.Code.getOppositeSideForPlayerPlacing((Entity)aPlayer, this.mFacing, this.getValidSides()) : UT.Code.getSideForPlayerPlacing((Entity)aPlayer, this.mFacing, this.getValidSides());
        this.mSecondFacing = this.useInversePlacementRotation(aStack, aPlayer, aWorld, aX, aY, aZ, aSide, aHitX, aHitY, aHitZ) ? UT.Code.getSideForPlayerPlacing((Entity)aPlayer, this.mSecondFacing, this.getValidSecondSides()) : UT.Code.getOppositeSideForPlayerPlacing((Entity)aPlayer, this.mSecondFacing, this.getValidSecondSides());
        this.onFacingChange((byte)6, (byte)6);
        this.checkCoverValidity();
        this.doEnetUpdate();
        return true;
    }

    public void onFacingChange(byte aPreviousFacing, byte aPreviousSecondFacing) {
        this.onFacingChange(aPreviousFacing);
    }

    @Override
    public byte getDirectionData() {
        return (byte)(this.mFacing | this.mSecondFacing << 3);
    }

    @Override
    public void setDirectionData(byte aData) {
        this.mFacing = (byte)(aData & 7);
        this.mSecondFacing = (byte)(aData >>> 3 & 7);
    }

    @Override
    public boolean isUsingWrenchingOverlay(ItemStack aStack, byte aSide) {
        return super.isUsingWrenchingOverlay(aStack, aSide) || CS.ToolsGT.contains("monkeywrench", aStack);
    }

    @Override
    public boolean isConnectedWrenchingOverlay(ItemStack aStack, byte aSide) {
        return aSide == this.mFacing || aSide == this.mSecondFacing;
    }

    public byte getDefaultSecondSide() {
        return CS.OPOS[this.getDefaultSide()];
    }

    public boolean[] getValidSecondSides() {
        return this.getValidSides();
    }
}

