/*
 * Decompiled with CFR 0.152.
 */
package gregapi.random;

import gregapi.data.CS;
import gregapi.util.UT;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S27PacketExplosion;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;

public class ExplosionGT
extends Explosion {
    private World mWorld;
    private Map field_77288_k = new HashMap();

    public static ExplosionGT explode(World aWorld, Entity aEntity, double aX, double aY, double aZ, float aPower, boolean aFlaming, boolean aSmoking) {
        ExplosionGT tExplosion = new ExplosionGT(aWorld, aEntity, aX, aY, aZ, aPower);
        tExplosion.field_77286_a = aFlaming;
        tExplosion.field_82755_b = aSmoking;
        if (ForgeEventFactory.onExplosionStart((World)aWorld, (Explosion)tExplosion)) {
            return tExplosion;
        }
        tExplosion.func_77278_a();
        if (aWorld instanceof WorldServer) {
            tExplosion.func_77279_a(false);
            if (!aSmoking) {
                tExplosion.field_77281_g.clear();
            }
            for (EntityPlayer tPlayer : aWorld.field_73010_i) {
                if (!(tPlayer.func_70092_e(aX, aY, aZ) < 4096.0)) continue;
                ((EntityPlayerMP)tPlayer).field_71135_a.func_147359_a((Packet)new S27PacketExplosion(aX, aY, aZ, aPower, tExplosion.field_77281_g, (Vec3)tExplosion.func_77277_b().get(tPlayer)));
            }
        } else {
            tExplosion.func_77279_a(true);
        }
        return tExplosion;
    }

    public ExplosionGT(World aWorld, Entity aEntity, double aX, double aY, double aZ, float aPower) {
        super(aWorld, aEntity, aX, aY, aZ, aPower);
        this.mWorld = aWorld;
    }

    public void func_77278_a() {
        float tSize = this.field_77280_f;
        HashSet<ChunkPosition> tPositions = new HashSet<ChunkPosition>();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    if (i != 0 && i != 15 && j != 0 && j != 15 && k != 0 && k != 15) continue;
                    double tIncX = (float)i / 7.5f - 1.0f;
                    double tIncY = (float)j / 7.5f - 1.0f;
                    double tIncZ = (float)k / 7.5f - 1.0f;
                    double tDist = Math.sqrt(tIncX * tIncX + tIncY * tIncY + tIncZ * tIncZ);
                    tIncX /= tDist;
                    tIncY /= tDist;
                    tIncZ /= tDist;
                    double tX = this.field_77284_b;
                    double tY = this.field_77285_c;
                    double tZ = this.field_77282_d;
                    float tMul = 0.3f;
                    for (float tPow = tSize * (0.7f + this.mWorld.field_73012_v.nextFloat() * 0.6f); tPow > 0.0f; tPow -= tMul * 0.75f) {
                        int tFloorZ;
                        int tFloorY;
                        int tFloorX = UT.Code.roundDown(tX);
                        Block tBlock = this.mWorld.func_147439_a(tFloorX, tFloorY = UT.Code.roundDown(tY), tFloorZ = UT.Code.roundDown(tZ));
                        if (tBlock.func_149688_o() != Material.field_151579_a) {
                            float f3 = this.field_77283_e != null ? this.field_77283_e.func_145772_a((Explosion)this, this.mWorld, tFloorX, tFloorY, tFloorZ, tBlock) : tBlock.getExplosionResistance(this.field_77283_e, this.mWorld, tFloorX, tFloorY, tFloorZ, this.field_77284_b, this.field_77285_c, this.field_77282_d);
                            tPow -= (f3 + 0.3f) * tMul;
                        }
                        if (tPow > 0.0f && (this.field_77283_e == null || this.field_77283_e.func_145774_a((Explosion)this, this.mWorld, tFloorX, tFloorY, tFloorZ, tBlock, tPow))) {
                            tPositions.add(new ChunkPosition(tFloorX, tFloorY, tFloorZ));
                        }
                        tX += tIncX * (double)tMul;
                        tY += tIncY * (double)tMul;
                        tZ += tIncZ * (double)tMul;
                    }
                }
            }
        }
        this.field_77281_g.addAll(tPositions);
        List tEntities = this.mWorld.func_72839_b(this.field_77283_e, AxisAlignedBB.func_72330_a((double)UT.Code.roundDown(this.field_77284_b - (double)(tSize *= 2.0f) - 1.0), (double)UT.Code.roundDown(this.field_77285_c - (double)tSize - 1.0), (double)UT.Code.roundDown(this.field_77282_d - (double)tSize - 1.0), (double)UT.Code.roundDown(this.field_77284_b + (double)tSize + 1.0), (double)UT.Code.roundDown(this.field_77285_c + (double)tSize + 1.0), (double)UT.Code.roundDown(this.field_77282_d + (double)tSize + 1.0)));
        ForgeEventFactory.onExplosionDetonate((World)this.mWorld, (Explosion)this, (List)tEntities, (double)tSize);
        Vec3 tVec3 = Vec3.func_72443_a((double)this.field_77284_b, (double)this.field_77285_c, (double)this.field_77282_d);
        for (int i1 = 0; i1 < tEntities.size(); ++i1) {
            double tKnockZ;
            double tKnockY;
            double tKnockX;
            double tDist;
            Entity tEntity = (Entity)tEntities.get(i1);
            double tEntityDist = tEntity.func_70011_f(this.field_77284_b, this.field_77285_c, this.field_77282_d) / (double)tSize;
            if (!(tEntityDist <= 1.0) || tEntity instanceof EntityWither || tEntity instanceof EntityDragon || tEntity instanceof EntityDragonPart || tEntity.getClass().getName().toLowerCase().contains("boss") || !((tDist = (double)MathHelper.func_76133_a((double)((tKnockX = tEntity.field_70165_t - this.field_77284_b) * tKnockX + (tKnockY = tEntity.field_70163_u + (double)tEntity.func_70047_e() - this.field_77285_c) * tKnockY + (tKnockZ = tEntity.field_70161_v - this.field_77282_d) * tKnockZ))) > 0.0)) continue;
            tKnockX /= tDist;
            tKnockY /= tDist;
            tKnockZ /= tDist;
            double tKnockback = (1.0 - tEntityDist) * (double)this.mWorld.func_72842_a(tVec3, tEntity.field_70121_D);
            tEntity.func_70097_a(DamageSource.func_94539_a((Explosion)this), (float)((int)((tKnockback * tKnockback + tKnockback) * 4.0 * (double)tSize + 1.0) * CS.TFC_DAMAGE_MULTIPLIER));
            double tBlastProtection = EnchantmentProtection.func_92092_a((Entity)tEntity, (double)tKnockback);
            tEntity.field_70159_w += tKnockX * tBlastProtection;
            tEntity.field_70181_x += tKnockY * tBlastProtection;
            tEntity.field_70179_y += tKnockZ * tBlastProtection;
            if (!(tEntity instanceof EntityPlayer)) continue;
            this.field_77288_k.put(tEntity, Vec3.func_72443_a((double)(tKnockX * tKnockback), (double)(tKnockY * tKnockback), (double)(tKnockZ * tKnockback)));
        }
    }

    public void func_77279_a(boolean aEffects) {
        Block tBlock;
        this.mWorld.func_72908_a(this.field_77284_b, this.field_77285_c, this.field_77282_d, "random.explode", 4.0f, (1.0f + (this.mWorld.field_73012_v.nextFloat() - this.mWorld.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        this.mWorld.func_72869_a(this.field_77280_f >= 2.0f && this.field_82755_b ? "hugeexplosion" : "largeexplode", this.field_77284_b, this.field_77285_c, this.field_77282_d, 1.0, 0.0, 0.0);
        if (this.field_82755_b) {
            for (ChunkPosition tPos : this.field_77281_g) {
                tBlock = this.mWorld.func_147439_a(tPos.field_151329_a, tPos.field_151327_b, tPos.field_151328_c);
                if (aEffects) {
                    double d0 = (float)tPos.field_151329_a + this.mWorld.field_73012_v.nextFloat();
                    double d1 = (float)tPos.field_151327_b + this.mWorld.field_73012_v.nextFloat();
                    double d2 = (float)tPos.field_151328_c + this.mWorld.field_73012_v.nextFloat();
                    double d3 = d0 - this.field_77284_b;
                    double d4 = d1 - this.field_77285_c;
                    double d5 = d2 - this.field_77282_d;
                    double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                    d3 /= d6;
                    d4 /= d6;
                    d5 /= d6;
                    double d7 = 0.5 / (d6 / (double)this.field_77280_f + 0.1);
                    this.mWorld.func_72869_a("explode", (d0 + this.field_77284_b) / 2.0, (d1 + this.field_77285_c) / 2.0, (d2 + this.field_77282_d) / 2.0, d3 *= (d7 *= (double)(this.mWorld.field_73012_v.nextFloat() * this.mWorld.field_73012_v.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7);
                    this.mWorld.func_72869_a("smoke", d0, d1, d2, d3, d4, d5);
                }
                if (tBlock.func_149688_o() == Material.field_151579_a) continue;
                if (tBlock.func_149659_a((Explosion)this)) {
                    tBlock.func_149690_a(this.mWorld, tPos.field_151329_a, tPos.field_151327_b, tPos.field_151328_c, this.mWorld.func_72805_g(tPos.field_151329_a, tPos.field_151327_b, tPos.field_151328_c), 1.0f / this.field_77280_f, 0);
                }
                tBlock.onBlockExploded(this.mWorld, tPos.field_151329_a, tPos.field_151327_b, tPos.field_151328_c, (Explosion)this);
            }
        }
        if (this.field_77286_a) {
            for (ChunkPosition tPos : this.field_77281_g) {
                tBlock = this.mWorld.func_147439_a(tPos.field_151329_a, tPos.field_151327_b, tPos.field_151328_c);
                Block tAbove = this.mWorld.func_147439_a(tPos.field_151329_a, tPos.field_151327_b - 1, tPos.field_151328_c);
                if (tBlock.func_149688_o() != Material.field_151579_a || !tAbove.func_149730_j() || CS.RNGSUS.nextInt(3) != 0) continue;
                this.mWorld.func_147449_b(tPos.field_151329_a, tPos.field_151327_b, tPos.field_151328_c, (Block)Blocks.field_150480_ab);
            }
        }
    }

    public Map func_77277_b() {
        return this.field_77288_k;
    }

    public EntityLivingBase func_94613_c() {
        return this.field_77283_e == null ? null : (this.field_77283_e instanceof EntityTNTPrimed ? ((EntityTNTPrimed)this.field_77283_e).func_94083_c() : (this.field_77283_e instanceof EntityLivingBase ? (EntityLivingBase)this.field_77283_e : null));
    }
}

