/*
 * Decompiled with CFR 0.152.
 */
package gregapi.network.packets;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import gregapi.block.IBlockErrorable;
import gregapi.network.INetworkHandler;
import gregapi.network.packets.PacketCoordinates;
import net.minecraft.block.Block;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PacketBlockError
extends PacketCoordinates {
    private String mError;

    public PacketBlockError(int aDecoderType) {
        super(aDecoderType);
    }

    public PacketBlockError(int aX, int aY, int aZ, String aError) {
        super(aX, aY, aZ);
        this.mError = aError;
    }

    public PacketBlockError(ChunkCoordinates aCoords, String aError) {
        super(aCoords);
        this.mError = aError;
    }

    @Override
    public byte getPacketIDOffset() {
        return 104;
    }

    @Override
    public ByteArrayDataOutput encode2(ByteArrayDataOutput aData) {
        aData.writeUTF(this.mError);
        return aData;
    }

    @Override
    public PacketCoordinates decode2(int aX, int aY, int aZ, ByteArrayDataInput aData) {
        return new PacketBlockError(aX, aY, aZ, aData.readUTF());
    }

    @Override
    public void process(IBlockAccess aWorld, INetworkHandler aNetworkHandler) {
        Block tBlock;
        if (aWorld instanceof World && (tBlock = aWorld.func_147439_a(this.mX, this.mY, this.mZ)) instanceof IBlockErrorable) {
            ((IBlockErrorable)tBlock).receiveBlockError(aWorld, this.mX, this.mY, this.mZ, this.mError);
        }
    }
}

