/*
 * Decompiled with CFR 0.152.
 */
package gregapi.item.prefixitem;

import cpw.mods.fml.common.FMLLog;
import gregapi.code.ModData;
import gregapi.code.ObjectStack;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MT;
import gregapi.item.IItemProjectile;
import gregapi.item.prefixitem.PrefixItem;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictPrefix;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class PrefixItemProjectile
extends PrefixItem
implements IItemProjectile {
    public final TagData mProjectileType;
    public final Class<? extends IItemProjectile.EntityProjectile> mEntityClass;
    public final float mSpeedMultiplier;
    public final float mPrecision;
    public final boolean mStabbing;
    public final boolean mIsBullet;
    public int mLootingMultiplier = 1;

    public PrefixItemProjectile(ModData aMod, String aNameInternal, OreDictPrefix aPrefix, TagData aProjectileType, Class<? extends IItemProjectile.EntityProjectile> aEntityClass, float aSpeedMultiplier, float aPrecision, boolean aDispensable, boolean aStabbing, boolean aIsBullet, OreDictMaterial ... aMaterialList) {
        this(aMod.mID, aMod.mID, aNameInternal, aPrefix, aProjectileType, aEntityClass, aSpeedMultiplier, aPrecision, aDispensable, aStabbing, aIsBullet, aMaterialList);
    }

    public PrefixItemProjectile(String aModIDOwner, String aModIDTextures, String aNameInternal, OreDictPrefix aPrefix, TagData aProjectileType, Class<? extends IItemProjectile.EntityProjectile> aEntityClass, float aSpeedMultiplier, float aPrecision, boolean aDispensable, boolean aStabbing, boolean aIsBullet, OreDictMaterial ... aMaterialList) {
        super(aModIDOwner, aModIDTextures, aNameInternal, aPrefix, aMaterialList);
        this.mProjectileType = aProjectileType;
        this.mEntityClass = aEntityClass;
        this.mPrecision = aPrecision;
        this.mSpeedMultiplier = aSpeedMultiplier;
        this.mStabbing = aStabbing;
        this.mIsBullet = aIsBullet;
        if (aDispensable) {
            BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)new MetaItemDispense());
        }
    }

    @Override
    public void func_77624_a(ItemStack aStack, EntityPlayer aPlayer, List aList, boolean aF3_H) {
        if (this.mIsBullet) {
            OreDictMaterial tMat = this.getMaterial(ST.meta(aStack));
            int tDamage = (int)((tMat == null ? 1.0 : tMat.getWeight(this.getPrefix((int)ST.meta((ItemStack)aStack)).mAmount) / 50.0) * 2.0 * (double)CS.TFC_DAMAGE_MULTIPLIER) + 1;
            aList.add(LH.Chat.WHITE + "Bullet Damage: " + LH.Chat.RED + (float)tDamage / 2.0f + (CS.TFC_DAMAGE_MULTIPLIER > 1 ? "" : " Hearts"));
        }
        super.func_77624_a(aStack, aPlayer, aList, aF3_H);
    }

    @Override
    public boolean hasProjectile(TagData aProjectileType, ItemStack aStack) {
        return (this.mProjectileType == aProjectileType || aProjectileType == null) && UT.Code.exists(ST.meta_(aStack), this.mMaterialList) && this.mMaterialList[ST.meta_(aStack)] != MT.Empty;
    }

    @Override
    public IItemProjectile.EntityProjectile getProjectile(TagData aProjectileType, ItemStack aStack, World aWorld, double aX, double aY, double aZ) {
        if (!this.hasProjectile(aProjectileType, aStack)) {
            return null;
        }
        try {
            IItemProjectile.EntityProjectile tProjectile = this.mEntityClass.getConstructor(World.class, Double.TYPE, Double.TYPE, Double.TYPE).newInstance(aWorld, aX, aY, aZ);
            tProjectile.setProjectileStack(ST.amount(1L, aStack));
            return tProjectile;
        }
        catch (Throwable e) {
            FMLLog.severe((String)"Problems with '%s'", (Object[])new Object[]{this.mEntityClass.getName()});
            FMLLog.severe((String)e.toString(), (Object[])new Object[0]);
            return null;
        }
    }

    @Override
    public IItemProjectile.EntityProjectile getProjectile(TagData aProjectileType, ItemStack aStack, World aWorld, EntityLivingBase aEntity, float aSpeed) {
        if (!this.hasProjectile(aProjectileType, aStack)) {
            return null;
        }
        try {
            IItemProjectile.EntityProjectile tProjectile = this.mEntityClass.getConstructor(World.class, EntityLivingBase.class, Float.TYPE).newInstance(aWorld, aEntity, Float.valueOf(this.mSpeedMultiplier * aSpeed));
            tProjectile.setProjectileStack(ST.amount(1L, aStack));
            return tProjectile;
        }
        catch (Throwable e) {
            FMLLog.severe((String)"Problems with '%s'", (Object[])new Object[]{this.mEntityClass.getName()});
            FMLLog.severe((String)e.toString(), (Object[])new Object[0]);
            return null;
        }
    }

    public boolean onLeftClickEntity(ItemStack aStack, EntityPlayer aPlayer, Entity aEntity) {
        super.onLeftClickEntity(aStack, aPlayer, aEntity);
        if (aEntity instanceof EntityLivingBase) {
            if (this.mStabbing) {
                UT.Enchantments.applyBullshitA((EntityLivingBase)aEntity, (Entity)aPlayer, aStack);
                UT.Enchantments.applyBullshitB((EntityLivingBase)aPlayer, aEntity, aStack);
            }
            ST.use((Entity)aPlayer, aStack);
            return false;
        }
        return false;
    }

    public PrefixItemProjectile setLootingMultiplier(int aLootingMultiplier) {
        this.mLootingMultiplier = aLootingMultiplier;
        return this;
    }

    @Override
    public void updateItemStack(ItemStack aStack) {
        NBTTagCompound tNBT;
        super.updateItemStack(aStack);
        short aMetaData = ST.meta_(aStack);
        if (UT.Code.exists(aMetaData, this.mMaterialList) && !this.mMaterialList[aMetaData].mEnchantmentAmmo.isEmpty() && !(tNBT = UT.NBT.getOrCreate(aStack)).func_74767_n("gt.u")) {
            tNBT.func_74757_a("gt.u", true);
            for (ObjectStack<Enchantment> tEnchantment : this.mMaterialList[aMetaData].mEnchantmentAmmo) {
                UT.NBT.addEnchantment(aStack, (Enchantment)tEnchantment.mObject, tEnchantment.mObject == Enchantment.field_77335_o ? tEnchantment.mAmount * (long)this.mLootingMultiplier : tEnchantment.mAmount);
            }
        }
    }

    public ItemStack onDispense(IBlockSource aSource, ItemStack aStack) {
        World aWorld = aSource.func_82618_k();
        IPosition tPosition = BlockDispenser.func_149939_a((IBlockSource)aSource);
        EnumFacing tFacing = BlockDispenser.func_149937_b((int)aSource.func_82620_h());
        IItemProjectile.EntityProjectile tProjectile = this.getProjectile(this.mProjectileType, aStack, aWorld, tPosition.func_82615_a(), tPosition.func_82617_b(), tPosition.func_82616_c());
        if (tProjectile != null) {
            tProjectile.func_70186_c(tFacing.func_82601_c(), (float)tFacing.func_96559_d() + 0.1f, tFacing.func_82599_e(), this.mSpeedMultiplier * 1.1f, this.mPrecision);
            tProjectile.setProjectileStack(ST.amount(1L, aStack));
            tProjectile.field_70251_a = 1;
            aWorld.func_72838_d((Entity)tProjectile);
            if (aStack.field_77994_a < 100) {
                --aStack.field_77994_a;
            }
            return aStack;
        }
        EnumFacing enumfacing = BlockDispenser.func_149937_b((int)aSource.func_82620_h());
        IPosition iposition = BlockDispenser.func_149939_a((IBlockSource)aSource);
        ItemStack itemstack1 = aStack.func_77979_a(1);
        BehaviorDefaultDispenseItem.func_82486_a((World)aSource.func_82618_k(), (ItemStack)itemstack1, (int)6, (EnumFacing)enumfacing, (IPosition)iposition);
        return aStack;
    }

    public static class MetaItemDispense
    extends BehaviorProjectileDispense {
        public ItemStack func_82487_b(IBlockSource aSource, ItemStack aStack) {
            return ((PrefixItemProjectile)aStack.func_77973_b()).onDispense(aSource, aStack);
        }

        protected IProjectile func_82499_a(World aWorld, IPosition aPosition) {
            return null;
        }
    }
}

