/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover.covers;

import gregapi.cover.CoverData;
import gregapi.cover.covers.AbstractCoverAttachmentController;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.ITexture;
import gregapi.tileentity.machines.ITileEntityRunningActively;
import gregapi.tileentity.machines.ITileEntitySwitchableOnOff;

public class CoverControllerAutoTimer
extends AbstractCoverAttachmentController {
    public final int mTime;
    public final ITexture mTextureForeground;

    public CoverControllerAutoTimer(int aTime) {
        this.mTime = Math.max(11, aTime);
        this.mTextureForeground = BlockTextureDefault.get("machines/covers/autotimerswitch/" + this.mTime + "/circuit");
    }

    @Override
    public ITexture getCoverTextureSurface(byte aSide, CoverData aData) {
        return this.mTextureForeground;
    }

    @Override
    public ITexture getCoverTextureAttachment(byte aSide, CoverData aData, byte aTextureSide) {
        return aSide != aTextureSide ? BACKGROUND_COVER : BlockTextureMulti.get(BACKGROUND_COVER, this.mTextureForeground);
    }

    @Override
    public ITexture getCoverTextureHolder(byte aSide, CoverData aData, byte aTextureSide) {
        return BACKGROUND_COVER;
    }

    @Override
    public void onTickPre(byte aSide, CoverData aData, long aTimer, boolean aIsServerSide, boolean aReceivedBlockUpdate, boolean aReceivedInventoryUpdate) {
        if (aIsServerSide && aData.mTileEntity instanceof ITileEntitySwitchableOnOff) {
            ((ITileEntitySwitchableOnOff)((Object)aData.mTileEntity)).setStateOnOff(aData.mTileEntity instanceof ITileEntityRunningActively && ((ITileEntityRunningActively)((Object)aData.mTileEntity)).getStateRunningActively() || aTimer % (long)this.mTime >= (long)(this.mTime - 10));
        }
    }

    @Override
    public boolean getStateOnOff(byte aSide, CoverData aData) {
        return true;
    }
}

