/*
 * Decompiled with CFR 0.152.
 */
package gregapi.block;

import gregapi.block.IBlockBase;
import gregapi.block.ItemBlockBase;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.OP;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockBase
extends Block
implements IBlockBase {
    public final String mNameInternal;

    public BlockBase(Class<? extends ItemBlock> aItemClass, String aNameInternal, Material aMaterial, Block.SoundType aSoundType) {
        super(aMaterial);
        this.func_149672_a(aSoundType);
        this.mNameInternal = aNameInternal;
        this.func_149663_c(this.mNameInternal);
        this.func_149647_a(CreativeTabs.field_78030_b);
        ST.register(this, this.mNameInternal, aItemClass);
        LH.add(this.mNameInternal + "." + Short.MAX_VALUE, "Any Sub-Block of this one");
    }

    public final String func_149739_a() {
        return this.mNameInternal;
    }

    public String func_149732_F() {
        return StatCollector.func_74838_a((String)this.mNameInternal);
    }

    public String getHarvestTool(int aMeta) {
        return "pickaxe";
    }

    public int getHarvestLevel(int aMeta) {
        return 0;
    }

    public boolean func_149700_E() {
        return this.canSilkHarvest((byte)0);
    }

    public boolean canSilkHarvest(World aWorld, EntityPlayer aPlayer, int aX, int aY, int aZ, int aMeta) {
        return this.canSilkHarvest(UT.Code.bind4(aMeta));
    }

    public boolean isToolEffective(String aType, int aMeta) {
        return this.getHarvestTool(aMeta).equals(aType);
    }

    public boolean canBeReplacedByLeaves(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    public boolean isNormalCube(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return true;
    }

    public boolean func_149686_d() {
        return true;
    }

    public boolean func_149662_c() {
        return true;
    }

    public boolean func_149730_j() {
        return this.func_149662_c();
    }

    public boolean isSideSolid(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aDirection) {
        return this.isSideSolid(WD.meta(aWorld, aX, aY, aZ), UT.Code.side(aDirection));
    }

    public boolean func_149646_a(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        return this.func_149662_c() ? !WD.visOpq(aWorld.func_147439_a(aX, aY, aZ)) : super.func_149646_a(aWorld, aX, aY, aZ, aSide);
    }

    public int func_149692_a(int aMeta) {
        return aMeta;
    }

    public int quantityDropped(int aMeta, int aFortune, Random aRandom) {
        return 1;
    }

    public ItemStack func_149644_j(int aMeta) {
        return ST.make(this, 1L, (long)this.func_149692_a(aMeta));
    }

    public int func_149643_k(World aWorld, int aX, int aY, int aZ) {
        return WD.meta((IBlockAccess)aWorld, aX, aY, aZ);
    }

    public int func_149717_k() {
        return 255;
    }

    public Item func_149650_a(int aMeta, Random aRandom, int aFortune) {
        return Item.func_150898_a((Block)this);
    }

    public Item func_149694_d(World aWorld, int aX, int aY, int aZ) {
        return Item.func_150898_a((Block)this);
    }

    public void func_149651_a(IIconRegister aIconRegister) {
    }

    public boolean canSustainPlant(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aSide, IPlantable aPlant) {
        return false;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess aWorld, int aX, int aY, int aZ) {
        byte aMeta = WD.meta(aWorld, aX, aY, aZ);
        return this.canCreatureSpawn(aMeta) && this.isSideSolid(aMeta, (byte)1);
    }

    public boolean isFireSource(World aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        return this.isFireSource(WD.meta((IBlockAccess)aWorld, aX, aY, aZ));
    }

    public boolean isFlammable(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        return this.isFlammable(WD.meta(aWorld, aX, aY, aZ));
    }

    public int getFlammability(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        return this.getFlammability(WD.meta(aWorld, aX, aY, aZ));
    }

    public int getFireSpreadSpeed(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        return this.getFireSpreadSpeed(WD.meta(aWorld, aX, aY, aZ));
    }

    public float getExplosionResistance(Entity aEntity, World aWorld, int aX, int aY, int aZ, double eX, double eY, double eZ) {
        return this.getExplosionResistance(WD.meta((IBlockAccess)aWorld, aX, aY, aZ));
    }

    public float func_149638_a(Entity aEntity) {
        return this.getExplosionResistance((byte)0);
    }

    public float func_149712_f(World aWorld, int aX, int aY, int aZ) {
        return 1.0f;
    }

    @Override
    public Block getBlock() {
        return this;
    }

    @Override
    public byte maxMeta() {
        return 1;
    }

    public final void func_149695_a(World aWorld, int aX, int aY, int aZ, Block aBlock) {
        if (this.useGravity(WD.meta((IBlockAccess)aWorld, aX, aY, aZ))) {
            aWorld.func_147464_a(aX, aY, aZ, (Block)this, 2);
        }
        this.onNeighborBlockChange2(aWorld, aX, aY, aZ, aBlock);
    }

    public final void func_149726_b(World aWorld, int aX, int aY, int aZ) {
        if (this.useGravity(WD.meta((IBlockAccess)aWorld, aX, aY, aZ))) {
            aWorld.func_147464_a(aX, aY, aZ, (Block)this, 2);
        }
        this.onBlockAdded2(aWorld, aX, aY, aZ);
    }

    public IIcon func_149673_e(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        return this.func_149691_a(aSide, WD.meta(aWorld, aX, aY, aZ));
    }

    @Override
    public String name(byte aMeta) {
        return aMeta == Short.MAX_VALUE ? this.mNameInternal : this.mNameInternal + "." + aMeta;
    }

    @Override
    public boolean useGravity(byte aMeta) {
        return false;
    }

    @Override
    public boolean doesWalkSpeed(byte aMeta) {
        return false;
    }

    @Override
    public boolean doesPistonPush(byte aMeta) {
        return false;
    }

    @Override
    public boolean canSilkHarvest(byte aMeta) {
        return true;
    }

    @Override
    public boolean canCreatureSpawn(byte aMeta) {
        return false;
    }

    @Override
    public boolean isSealable(byte aMeta, byte aSide) {
        return this.isSideSolid(aMeta, aSide);
    }

    @Override
    public boolean isFireSource(byte aMeta) {
        return false;
    }

    @Override
    public boolean isFlammable(byte aMeta) {
        return this.getFlammability(aMeta) > 0;
    }

    @Override
    public void addInformation(ItemStack aStack, byte aMeta, EntityPlayer aPlayer, List<String> aList, boolean aF3_H) {
    }

    @Override
    public float getExplosionResistance(byte aMeta) {
        return 10.0f;
    }

    @Override
    public int getFlammability(byte aMeta) {
        return 0;
    }

    @Override
    public int getFireSpreadSpeed(byte aMeta) {
        return 0;
    }

    @Override
    public int getItemStackLimit(ItemStack aStack) {
        return UT.Code.bindStack(OP.block.mDefaultStackSize);
    }

    @Override
    public ItemStack onItemRightClick(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        return aStack;
    }

    public boolean checkNoEntityCollision(World aWorld, int aX, int aY, int aZ, byte aMeta, Entity aExceptThisOne) {
        return aWorld.func_72917_a(AxisAlignedBB.func_72330_a((double)aX, (double)aY, (double)aZ, (double)(aX + 1), (double)(aY + 1), (double)(aZ + 1)), aExceptThisOne);
    }

    public boolean isSideSolid(int aMeta, byte aSide) {
        return true;
    }

    public void updateTick2(World aWorld, int aX, int aY, int aZ, Random aRandom) {
    }

    public void onNeighborBlockChange2(World aWorld, int aX, int aY, int aZ, Block aBlock) {
    }

    public void onBlockAdded2(World aWorld, int aX, int aY, int aZ) {
    }

    public final void func_149674_a(World aWorld, int aX, int aY, int aZ, Random aRandom) {
        if (aWorld.field_72995_K || this.checkGravity(aWorld, aX, aY, aZ)) {
            return;
        }
        this.updateTick2(aWorld, aX, aY, aZ, aRandom);
    }

    public boolean checkGravity(World aWorld, int aX, int aY, int aZ) {
        byte aMeta = WD.meta((IBlockAccess)aWorld, aX, aY, aZ);
        if (aY > 0 && this.useGravity(aMeta) && BlockFalling.func_149831_e((World)aWorld, (int)aX, (int)(aY - 1), (int)aZ)) {
            if (!BlockFalling.field_149832_M && aWorld.func_72904_c(aX - 32, aY - 32, aZ - 32, aX + 32, aY + 32, aZ + 32)) {
                if (!aWorld.field_72995_K) {
                    aWorld.func_72838_d((Entity)new EntityFallingBlock(aWorld, (double)aX + 0.5, (double)aY + 0.5, (double)aZ + 0.5, (Block)this, (int)aMeta));
                }
            } else {
                aWorld.func_147468_f(aX, aY, aZ);
                while (BlockFalling.func_149831_e((World)aWorld, (int)aX, (int)(aY - 1), (int)aZ) && aY > 0) {
                    --aY;
                }
                if (aY > 0) {
                    WD.set(aWorld, aX, aY, aZ, (Block)this, (long)aMeta, 2L);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onItemUseFirst(ItemBlockBase aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float aHitX, float aHitY, float aHitZ) {
        return false;
    }

    @Override
    public boolean onItemUse(ItemBlockBase aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float aHitX, float aHitY, float aHitZ) {
        if (aStack.field_77994_a == 0) {
            return false;
        }
        Block tBlock = aWorld.func_147439_a(aX, aY, aZ);
        if (tBlock == Blocks.field_150431_aC && (WD.meta((IBlockAccess)aWorld, aX, aY, aZ) & 7) < 1) {
            aSide = 1;
        } else if (tBlock != Blocks.field_150395_bd && tBlock != Blocks.field_150329_H && tBlock != Blocks.field_150330_I && !tBlock.isReplaceable((IBlockAccess)aWorld, aX, aY, aZ)) {
            aX += CS.OFFX[aSide];
            aY += CS.OFFY[aSide];
            aZ += CS.OFFZ[aSide];
        }
        if (!aWorld.func_147439_a(aX, aY, aZ).isReplaceable((IBlockAccess)aWorld, aX, aY, aZ)) {
            return false;
        }
        if (!this.func_149705_a(aWorld, aX, aY, aZ, aSide, aStack)) {
            return false;
        }
        byte aMeta = UT.Code.bind4(aItem.func_77647_b(ST.meta(aStack)));
        if (!this.checkNoEntityCollision(aWorld, aX, aY, aZ, aMeta, null)) {
            return false;
        }
        if (!aPlayer.func_82247_a(aX, aY, aZ, aSide, aStack) || aY == 255 && this.func_149688_o().func_76220_a() || !aWorld.func_147472_a((Block)this, aX, aY, aZ, false, aSide, (Entity)aPlayer, aStack)) {
            return false;
        }
        if (aItem.placeBlockAt(aStack, aPlayer, aWorld, aX, aY, aZ, aSide, aHitX, aHitY, aHitZ, this.func_149660_a(aWorld, aX, aY, aZ, aSide, aHitX, aHitY, aHitZ, aMeta))) {
            aWorld.func_72908_a((double)((float)aX + 0.5f), (double)((float)aY + 0.5f), (double)((float)aZ + 0.5f), this.field_149762_H.func_150496_b(), (this.field_149762_H.func_150497_c() + 1.0f) / 2.0f, this.field_149762_H.func_150494_d() * 0.8f);
            --aStack.field_77994_a;
        }
        return true;
    }

    public final int func_149745_a(Random aRandom) {
        return this.quantityDropped(0, 0, aRandom);
    }
}

