/**
 * Copyright (c) 2023 GregTech-6 Team
 *
 * This file is part of GregTech.
 *
 * GregTech is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GregTech is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with GregTech. If not, see <http://www.gnu.org/licenses/>.
 */

package gregapi.cover.covers;

import gregapi.cover.CoverData;
import gregapi.data.LH;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.ITexture;
import gregapi.tileentity.connectors.ITileEntityConnector;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

import java.util.List;

import static gregapi.data.CS.*;

/**
 * @author Gregorius Techneticies
 */
public class CoverShutter extends AbstractCoverAttachment {
	public CoverShutter() {}
	
	@Override
	public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
		super.addToolTips(aList, aStack, aF3_H);
		aList.add(LH.Chat.CYAN + LH.get(LH.TOOL_TO_TOGGLE_CONTROLLER_COVER));
		aList.add(LH.Chat.DGRAY + LH.get(LH.TOOL_TO_TOGGLE_SCREWDRIVER));
	}
	
	@Override
	public long onToolClick(byte aCoverSide, CoverData aData, String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
		if (aTool.equals(TOOL_screwdriver)) {
			aData.visual(aCoverSide, (short)(aData.mVisuals[aCoverSide] == 0 ? 1 : 0));
			if (aChatReturn != null) aChatReturn.add(aData.mVisuals[aCoverSide] == 0 ? "Normal Shutter" : "Inverted Shutter");
			if (aData.mTileEntity instanceof ITileEntityConnector) {
				if ((aData.mVisuals[aCoverSide] == 0) == aData.mStopped) {
					((ITileEntityConnector)aData.mTileEntity).disconnect(aCoverSide, T);
				} else {
					((ITileEntityConnector)aData.mTileEntity).connect(aCoverSide, T);
				}
			}
			return 1000;
		}
		if (aTool.equals(TOOL_magnifyingglass)) {
			if (aChatReturn != null) aChatReturn.add(aData.mVisuals[aCoverSide] == 0 ? "Normal Shutter" : "Inverted Shutter");
			return 1;
		}
		return 0;
	}
	
	@Override
	public void onStoppedUpdate(byte aCoverSide, CoverData aData, boolean aStopped) {
		if (aData.mTileEntity instanceof ITileEntityConnector) {
			if ((aData.mVisuals[aCoverSide] == 0) == aStopped) {
				((ITileEntityConnector)aData.mTileEntity).disconnect(aCoverSide, T);
			} else {
				((ITileEntityConnector)aData.mTileEntity).connect(aCoverSide, T);
			}
		}
	}
	
	@Override public boolean interceptItemInsert (byte aCoverSide, CoverData aData, int aSlot, ItemStack aStack, byte aSide) {return (aData.mVisuals[aCoverSide] == 0) == aData.mStopped;}
	@Override public boolean interceptItemExtract(byte aCoverSide, CoverData aData, int aSlot, ItemStack aStack, byte aSide) {return (aData.mVisuals[aCoverSide] == 0) == aData.mStopped;}
	@Override public boolean interceptFluidFill  (byte aCoverSide, CoverData aData, byte aSide, FluidStack aFluidToFill) {return (aData.mVisuals[aCoverSide] == 0) == aData.mStopped;}
	@Override public boolean interceptFluidDrain (byte aCoverSide, CoverData aData, byte aSide, FluidStack aFluidToDrain) {return (aData.mVisuals[aCoverSide] == 0) == aData.mStopped;}
	
	@Override public ITexture getCoverTextureSurface(byte aCoverSide, CoverData aData) {return aData.mVisuals[aCoverSide]==0?sTextureNormal:sTextureInverted;}
	@Override public ITexture getCoverTextureAttachment(byte aCoverSide, CoverData aData, byte aTextureSide) {return ALONG_AXIS[aCoverSide][aTextureSide] ? BlockTextureMulti.get(BACKGROUND_COVER, aData.mVisuals[aCoverSide]==0?sTextureNormal:sTextureInverted) : BACKGROUND_COVER;}
	@Override public ITexture getCoverTextureHolder(byte aCoverSide, CoverData aData, byte aTextureSide) {return BACKGROUND_COVER;}
	@Override public boolean needsVisualsSaved(byte aCoverSide, CoverData aData) {return T;}
	@Override public boolean showsConnectorFront(byte aCoverSide, CoverData aData) {return F;}
	
	public static final ITexture
	sTextureInverted = BlockTextureDefault.get("machines/covers/shutter/inverted"),
	sTextureNormal = BlockTextureDefault.get("machines/covers/shutter/normal");
}
