/*
 * Decompiled with CFR 0.152.
 */
package gregtech.worldgen.nether;

import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.util.ST;
import gregapi.util.WD;
import gregapi.worldgen.WorldgenObject;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class WorldgenRacks
extends WorldgenObject {
    @SafeVarargs
    public WorldgenRacks(String aName, boolean aDefault, List<WorldgenObject> ... aLists) {
        super(aName, aDefault, aLists);
    }

    @Override
    public boolean generate(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
        if (aRandom.nextBoolean() || this.checkForMajorWorldgen(aWorld, aMinX, aMinZ, aMaxX, aMaxZ)) {
            return false;
        }
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry("gt.multitileentity");
        if (tRegistry == null) {
            return false;
        }
        block26: for (int i = 0; i < 16; ++i) {
            int tZ;
            int tX;
            Block tContact;
            int tY;
            int tH = Math.max(0, tY - 40);
            for (tY = aRandom.nextInt(WD.bedrock(aWorld, tX = aMinX + aRandom.nextInt(16), 255, tZ = aMinZ + aRandom.nextInt(16)) ? 200 : 80) + 47; tY > tH && !(tContact = aChunk.getBlock(tX & 0xF, tY, tZ & 0xF)).getMaterial().isLiquid() && tContact != Blocks.farmland; --tY) {
                if (tContact == CS.NB || tContact.isAir((IBlockAccess)aWorld, tX, tY, tZ) || tContact.getMaterial() != Material.grass && tContact.getMaterial() != Material.ground && tContact.getMaterial() != Material.sand && tContact.getMaterial() != Material.rock) continue;
                if (!WD.easyRep(aWorld, tX, tY + 1, tZ)) continue block26;
                switch (aRandom.nextInt(24)) {
                    case 0: {
                        tRegistry.mBlock.placeBlock(aWorld, tX, tY + 1, tZ, (byte)6, (short)32757, ST.save("gt.value", OP.gem.mat(MT.NetherQuartz, 1L)), false, true);
                        break;
                    }
                    case 1: {
                        tRegistry.mBlock.placeBlock(aWorld, tX, tY + 1, tZ, (byte)6, (short)32757, ST.save("gt.value", OP.gem.mat(MT.Glowstone, 1L)), false, true);
                        break;
                    }
                    case 2: {
                        tRegistry.mBlock.placeBlock(aWorld, tX, tY + 1, tZ, (byte)6, (short)32757, ST.save("gt.value", (aRandom.nextInt(4) == 0 ? OP.oreRaw : OP.rockGt).mat(MT.AncientDebris, 1L)), false, true);
                        break;
                    }
                    case 3: {
                        tRegistry.mBlock.placeBlock(aWorld, tX, tY + 1, tZ, (byte)6, (short)32757, ST.save("gt.value", tContact == Blocks.nether_brick ? (aRandom.nextInt(4) == 0 ? OP.oreRaw : OP.rockGt).mat(MT.AncientDebris, 1L) : OP.gem.mat(MT.NetherQuartz, 1L)), false, true);
                        break;
                    }
                    case 4: {
                        tRegistry.mBlock.placeBlock(aWorld, tX, tY + 1, tZ, (byte)6, (short)32757, ST.save("gt.value", tContact == Blocks.nether_brick ? (aRandom.nextInt(4) == 0 ? OP.oreRaw : OP.rockGt).mat(MT.AncientDebris, 1L) : OP.gem.mat(MT.Glowstone, 1L)), false, true);
                        break;
                    }
                    case 5: {
                        tRegistry.mBlock.placeBlock(aWorld, tX, tY + 1, tZ, (byte)6, (short)32757, ST.save("gt.value", tContact == Blocks.nether_brick ? (aRandom.nextInt(4) == 0 ? OP.oreRaw : OP.rockGt).mat(MT.AncientDebris, 1L) : OP.rockGt.mat(MT.Obsidian, 1L)), false, true);
                        break;
                    }
                    case 6: {
                        tRegistry.mBlock.placeBlock(aWorld, tX, tY + 1, tZ, (byte)6, (short)32757, ST.save("gt.value", tContact == Blocks.soul_sand || IL.NeLi_SoulSoil.equal(tContact) || IL.NePl_SoulSoil.equal(tContact) ? OP.gem.mat(MT.Gloomstone, 1L) : ST.make(Items.flint, 1L, 0L)), false, true);
                        break;
                    }
                    case 7: {
                        tRegistry.mBlock.placeBlock(aWorld, tX, tY + 1, tZ, (byte)6, (short)32757, ST.save("gt.value", tContact == Blocks.soul_sand || IL.NeLi_SoulSoil.equal(tContact) || IL.NePl_SoulSoil.equal(tContact) ? OP.gem.mat(MT.Gloomstone, 1L) : ST.make(Items.flint, 1L, 0L)), false, true);
                        break;
                    }
                    case 8: {
                        tRegistry.mBlock.placeBlock(aWorld, tX, tY + 1, tZ, (byte)6, (short)32757, ST.save("gt.value", tContact == Blocks.soul_sand || IL.NeLi_SoulSoil.equal(tContact) || IL.NePl_SoulSoil.equal(tContact) ? OP.gem.mat(MT.NetherQuartz, 1L) : ST.make(Items.flint, 1L, 0L)), false, true);
                        break;
                    }
                    case 9: {
                        tRegistry.mBlock.placeBlock(aWorld, tX, tY + 1, tZ, (byte)6, (short)32757, ST.save("gt.value", tContact == Blocks.soul_sand || IL.NeLi_SoulSoil.equal(tContact) || IL.NePl_SoulSoil.equal(tContact) ? OP.gem.mat(MT.NetherQuartz, 1L) : ST.make(Items.flint, 1L, 0L)), false, true);
                        break;
                    }
                    case 10: {
                        tRegistry.mBlock.placeBlock(aWorld, tX, tY + 1, tZ, (byte)6, (short)32757, ST.save("gt.value", tContact == Blocks.soul_sand || IL.NeLi_SoulSoil.equal(tContact) || IL.NePl_SoulSoil.equal(tContact) ? OP.gem.mat(MT.NetherQuartz, 1L) : ST.make(Items.flint, 1L, 0L)), false, true);
                        break;
                    }
                    case 11: {
                        tRegistry.mBlock.placeBlock(aWorld, tX, tY + 1, tZ, (byte)6, (short)32757, ST.save("gt.value", tContact == Blocks.soul_sand || IL.NeLi_SoulSoil.equal(tContact) || IL.NePl_SoulSoil.equal(tContact) ? OP.gem.mat(MT.NetherQuartz, 1L) : ST.make(Items.flint, 1L, 0L)), false, true);
                        break;
                    }
                    case 12: {
                        tRegistry.mBlock.placeBlock(aWorld, tX, tY + 1, tZ, (byte)6, (short)32757, ST.save("gt.value", OP.rockGt.mat(MT.Obsidian, 1L)), false, true);
                        break;
                    }
                    case 13: {
                        tRegistry.mBlock.placeBlock(aWorld, tX, tY + 1, tZ, (byte)6, (short)32757, ST.save("gt.value", OP.rockGt.mat(MT.STONES.Basalt, 1L)), false, true);
                        break;
                    }
                    case 14: {
                        tRegistry.mBlock.placeBlock(aWorld, tX, tY + 1, tZ, (byte)6, (short)32757, ST.save("gt.value", OP.rockGt.mat(MT.STONES.Basalt, 1L)), false, true);
                        break;
                    }
                    case 15: {
                        tRegistry.mBlock.placeBlock(aWorld, tX, tY + 1, tZ, (byte)6, (short)32757, ST.save("gt.value", OP.rockGt.mat(MT.STONES.Basalt, 1L)), false, true);
                        break;
                    }
                    case 16: {
                        tRegistry.mBlock.placeBlock(aWorld, tX, tY + 1, tZ, (byte)6, (short)32757, ST.save("gt.value", tContact == Blocks.gravel || IL.NeLi_Gravel.equal(tContact) ? ST.make(Items.flint, 1L, 0L) : OP.rockGt.mat(MT.STONES.Blackstone, 1L)), false, true);
                        break;
                    }
                    case 17: {
                        tRegistry.mBlock.placeBlock(aWorld, tX, tY + 1, tZ, (byte)6, (short)32757, ST.save("gt.value", tContact == Blocks.gravel || IL.NeLi_Gravel.equal(tContact) ? ST.make(Items.flint, 1L, 0L) : OP.rockGt.mat(MT.STONES.Blackstone, 1L)), false, true);
                        break;
                    }
                    case 18: {
                        tRegistry.mBlock.placeBlock(aWorld, tX, tY + 1, tZ, (byte)6, (short)32757, ST.save("gt.value", tContact == Blocks.gravel || IL.NeLi_Gravel.equal(tContact) ? ST.make(Items.flint, 1L, 0L) : OP.rockGt.mat(MT.STONES.Blackstone, 1L)), false, true);
                        break;
                    }
                    case 19: {
                        tRegistry.mBlock.placeBlock(aWorld, tX, tY + 1, tZ, (byte)6, (short)32757, ST.save("gt.value", tContact == Blocks.gravel || IL.NeLi_Gravel.equal(tContact) ? ST.make(Items.flint, 1L, 0L) : OP.rockGt.mat(MT.STONES.Blackstone, 1L)), false, true);
                        break;
                    }
                    case 20: {
                        tRegistry.mBlock.placeBlock(aWorld, tX, tY + 1, tZ, (byte)6, (short)32757, ST.save("gt.value", tContact == Blocks.gravel || IL.NeLi_Gravel.equal(tContact) ? ST.make(Items.flint, 1L, 0L) : OP.rockGt.mat(MT.STONES.Blackstone, 1L)), false, true);
                        break;
                    }
                    case 21: {
                        tRegistry.mBlock.placeBlock(aWorld, tX, tY + 1, tZ, (byte)6, (short)32757, ST.save("gt.value", tContact == Blocks.gravel || IL.NeLi_Gravel.equal(tContact) ? ST.make(Items.flint, 1L, 0L) : OP.rockGt.mat(MT.STONES.Blackstone, 1L)), false, true);
                        break;
                    }
                    case 22: {
                        tRegistry.mBlock.placeBlock(aWorld, tX, tY + 1, tZ, (byte)6, (short)32757, ST.save("gt.value", tContact == Blocks.gravel || IL.NeLi_Gravel.equal(tContact) ? ST.make(Items.flint, 1L, 0L) : OP.rockGt.mat(MT.STONES.Blackstone, 1L)), false, true);
                        break;
                    }
                    case 23: {
                        tRegistry.mBlock.placeBlock(aWorld, tX, tY + 1, tZ, (byte)6, (short)32757, ST.save("gt.value", tContact == Blocks.gravel || IL.NeLi_Gravel.equal(tContact) ? ST.make(Items.flint, 1L, 0L) : OP.rockGt.mat(MT.STONES.Blackstone, 1L)), false, true);
                        break;
                    }
                    default: {
                        tRegistry.mBlock.placeBlock(aWorld, tX, tY + 1, tZ, (byte)6, (short)32757, null, false, true);
                        break;
                    }
                }
                continue block26;
            }
        }
        return true;
    }
}

