/*
 * Decompiled with CFR 0.152.
 */
package gregtech.worldgen;

import gregapi.data.CS;
import gregapi.util.WD;
import gregapi.worldgen.WorldgenObject;
import gregtech.blocks.fluids.BlockSwamp;
import gregtech.blocks.fluids.BlockWaterlike;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class WorldgenSwamp
extends WorldgenObject {
    public int mHeight = this.getConfigFile().get((Object)this.mCategory, "Height", (long)this.mHeight);

    @SafeVarargs
    public WorldgenSwamp(String aName, boolean aDefault, List<WorldgenObject> ... aLists) {
        super(aName, aDefault, aLists);
    }

    @Override
    public boolean generate(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
        boolean temp = true;
        for (String tName : aBiomeNames) {
            if (!CS.BIOMES_SWAMP.contains(tName)) continue;
            temp = false;
            break;
        }
        if (temp) {
            return false;
        }
        int tHeight = WD.waterLevel(aWorld, this.mHeight);
        ExtendedBlockStorage[] tStorages = aChunk.getBlockStorageArray();
        for (int tX = 0; tX < 16; ++tX) {
            block2: for (int tZ = 0; tZ < 16; ++tZ) {
                boolean tPlacedNone = true;
                for (int tY = tHeight; tY > 0; --tY) {
                    ExtendedBlockStorage tStorage = tStorages[tY >> 4];
                    if (tStorage == null) continue;
                    Block tBlock = tStorage.getBlockByExtId(tX, tY & 0xF, tZ);
                    if (tBlock.isOpaqueCube()) continue block2;
                    if (tBlock != Blocks.water && tBlock != Blocks.flowing_water && (!(tBlock instanceof BlockWaterlike) || !CS.BIOMES_SWAMP.contains(aBiomes[tX][tZ].biomeName))) continue;
                    if (tPlacedNone) {
                        tPlacedNone = false;
                        BlockSwamp.PLACEMENT_ALLOWED = true;
                        if (!aWorld.setBlock(aMinX + tX, tY, aMinZ + tZ, (Block)CS.BlocksGT.Swamp, 0, 0)) {
                            aWorld.setBlock(aMinX + tX, tY, aMinZ + tZ, Blocks.water, 0, 0);
                            aChunk.lastSaveTime = Long.MAX_VALUE;
                            return false;
                        }
                        BlockSwamp.PLACEMENT_ALLOWED = false;
                    } else {
                        tStorage.func_150818_a(tX, tY & 0xF, tZ, (Block)CS.BlocksGT.Swamp);
                    }
                    temp = true;
                }
            }
        }
        return temp;
    }
}

