/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.sensors;

import gregapi.data.BI;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.old.Textures;
import gregapi.render.IIconContainer;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.machines.MultiTileEntitySensorTE;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;

public class MultiTileEntityFluidometer
extends MultiTileEntitySensorTE {
    public static IIconContainer sTextureFront;
    public static IIconContainer sTextureBack;
    public static IIconContainer sTextureSide;
    public static IIconContainer sOverlayFront;
    public static IIconContainer sOverlayBack;
    public static IIconContainer sOverlaySide;

    @Override
    public String getSensorDescription() {
        return LH.get("gt.tooltip.sensor.fluidometer");
    }

    @Override
    public long getCurrentValue(DelegatorTileEntity<TileEntity> aDelegator) {
        FluidTankInfo[] tInfo;
        if (aDelegator.mTileEntity instanceof IFluidHandler && (tInfo = ((IFluidHandler)aDelegator.mTileEntity).getTankInfo(CS.FORGE_DIR[aDelegator.mSideOfTileEntity])) != null) {
            long rFluid = 0L;
            for (FluidTankInfo tTank : tInfo) {
                if (tTank == null || tTank.fluid == null) continue;
                rFluid += (long)tTank.fluid.amount;
            }
            return rFluid;
        }
        Block tBlock = aDelegator.getBlock();
        if (tBlock == Blocks.water || tBlock == Blocks.flowing_water || tBlock == Blocks.lava || tBlock == Blocks.flowing_lava) {
            return aDelegator.getMetaData() == 0 ? 1000L : 0L;
        }
        if (tBlock instanceof IFluidBlock) {
            FluidStack tFluid = ((IFluidBlock)tBlock).drain(aDelegator.mWorld, aDelegator.mX, aDelegator.mY, aDelegator.mZ, false);
            return tFluid == null ? 0L : (long)tFluid.amount;
        }
        return 0L;
    }

    @Override
    public long getCurrentMax(DelegatorTileEntity<TileEntity> aDelegator) {
        FluidTankInfo[] tInfo;
        if (aDelegator.mTileEntity instanceof IFluidHandler && (tInfo = ((IFluidHandler)aDelegator.mTileEntity).getTankInfo(CS.FORGE_DIR[aDelegator.mSideOfTileEntity])) != null) {
            long rCapacity = 0L;
            for (FluidTankInfo tTank : tInfo) {
                if (tTank == null) continue;
                rCapacity += (long)tTank.capacity;
            }
            return rCapacity;
        }
        return 0L;
    }

    @Override
    public short[] getSymbolColor() {
        return CS.CA_BLUE_255;
    }

    @Override
    public IIconContainer getSymbolIcon() {
        return BI.CHAR_LITER;
    }

    @Override
    public IIconContainer getTextureFront() {
        return sTextureFront;
    }

    @Override
    public IIconContainer getTextureBack() {
        return sTextureBack;
    }

    @Override
    public IIconContainer getTextureSide() {
        return sTextureSide;
    }

    @Override
    public IIconContainer getOverlayFront() {
        return sOverlayFront;
    }

    @Override
    public IIconContainer getOverlayBack() {
        return sOverlayBack;
    }

    @Override
    public IIconContainer getOverlaySide() {
        return sOverlaySide;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.redstone.sensors.fluidometer";
    }

    static {
        LH.add("gt.tooltip.sensor.fluidometer", "Measures Fluids (In Liters)");
        sTextureFront = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/fluidometer/colored/front");
        sTextureBack = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/fluidometer/colored/back");
        sTextureSide = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/fluidometer/colored/side");
        sOverlayFront = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/fluidometer/overlay/front");
        sOverlayBack = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/fluidometer/overlay/back");
        sOverlaySide = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/fluidometer/overlay/side");
    }
}

