/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.sensors;

import gregapi.data.BI;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.old.Textures;
import gregapi.render.IIconContainer;
import gregapi.tileentity.connectors.MultiTileEntityWireElectric;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.energy.EnergyCompat;
import gregapi.tileentity.machines.MultiTileEntitySensorTE;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.NodeStats;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.tileentity.TileEntity;

public class MultiTileEntityElectrometer
extends MultiTileEntitySensorTE {
    public static IIconContainer sTextureFront;
    public static IIconContainer sTextureBack;
    public static IIconContainer sTextureSide;
    public static IIconContainer sOverlayFront;
    public static IIconContainer sOverlayBack;
    public static IIconContainer sOverlaySide;

    @Override
    public String getSensorDescription() {
        return LH.get("gt.tooltip.sensor.electrometer");
    }

    @Override
    public long getCurrentValue(DelegatorTileEntity<TileEntity> aDelegator) {
        NodeStats tStats;
        TileEntity tTileEntity;
        if (aDelegator.mTileEntity instanceof MultiTileEntityWireElectric) {
            return ((MultiTileEntityWireElectric)aDelegator.mTileEntity).mWattageLast;
        }
        if (EnergyCompat.IC_ENERGY && EnergyNet.instance != null && (tTileEntity = EnergyNet.instance.getTileEntity(aDelegator.mWorld, aDelegator.mX, aDelegator.mY, aDelegator.mZ)) != null && (tStats = EnergyNet.instance.getNodeStats(tTileEntity)) != null) {
            if (tTileEntity instanceof IEnergyConductor) {
                return (long)tStats.getEnergyOut();
            }
            if (tTileEntity instanceof IEnergyEmitter) {
                return (long)tStats.getEnergyOut();
            }
            if (tTileEntity instanceof IEnergyAcceptor) {
                return (long)tStats.getEnergyIn();
            }
        }
        return 0L;
    }

    @Override
    public long getCurrentMax(DelegatorTileEntity<TileEntity> aDelegator) {
        if (aDelegator.mTileEntity instanceof MultiTileEntityWireElectric) {
            return ((MultiTileEntityWireElectric)aDelegator.mTileEntity).mAmperage * ((MultiTileEntityWireElectric)aDelegator.mTileEntity).mVoltage;
        }
        if (EnergyCompat.IC_ENERGY) {
            TileEntity tTileEntity;
            TileEntity tileEntity = tTileEntity = aDelegator.mTileEntity instanceof IEnergyTile || EnergyNet.instance == null ? (TileEntity)aDelegator.mTileEntity : EnergyNet.instance.getTileEntity(aDelegator.mWorld, aDelegator.mX, aDelegator.mY, aDelegator.mZ);
            if (tTileEntity instanceof IEnergyConductor) {
                return (long)((IEnergyConductor)tTileEntity).getConductorBreakdownEnergy();
            }
            if (tTileEntity instanceof IEnergySink) {
                return CS.V[((IEnergySink)tTileEntity).getSinkTier()];
            }
            if (tTileEntity instanceof IEnergySource) {
                return CS.V[((IEnergySource)tTileEntity).getSourceTier()];
            }
        }
        return 0L;
    }

    @Override
    public short[] getSymbolColor() {
        return CS.CA_RED_255;
    }

    @Override
    public IIconContainer getSymbolIcon() {
        return BI.CHAR_EU;
    }

    @Override
    public IIconContainer getTextureFront() {
        return sTextureFront;
    }

    @Override
    public IIconContainer getTextureBack() {
        return sTextureBack;
    }

    @Override
    public IIconContainer getTextureSide() {
        return sTextureSide;
    }

    @Override
    public IIconContainer getOverlayFront() {
        return sOverlayFront;
    }

    @Override
    public IIconContainer getOverlayBack() {
        return sOverlayBack;
    }

    @Override
    public IIconContainer getOverlaySide() {
        return sOverlaySide;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.redstone.sensors.electrometer";
    }

    static {
        LH.add("gt.tooltip.sensor.electrometer", "Measures Electricity Flow (In EU)");
        sTextureFront = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/electrometer/colored/front");
        sTextureBack = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/electrometer/colored/back");
        sTextureSide = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/electrometer/colored/side");
        sOverlayFront = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/electrometer/overlay/front");
        sOverlayBack = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/electrometer/overlay/back");
        sOverlaySide = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/electrometer/overlay/side");
    }
}

