/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.portals;

import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.render.BlockTextureCopied;
import gregapi.render.ITexture;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import gregtech.tileentity.portals.MultiTileEntityMiniPortal;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

public class MultiTileEntityMiniPortalEndOfTime
extends MultiTileEntityMiniPortal {
    public static List<MultiTileEntityMiniPortal> sListEndOfTimeSide = new ArrayListNoNulls<MultiTileEntityMiniPortal>();
    public static List<MultiTileEntityMiniPortal> sListWorldSide = new ArrayListNoNulls<MultiTileEntityMiniPortal>();
    public ITexture sEndOfTimePortal = BlockTextureCopied.get(ST.block(MD.ExU, "dark_portal", ST.block(MD.ExS, "deepPortal", (Block)Blocks.portal)), 6, 0, CS.UNCOLOURED, false, true, true);
    public ITexture sEndOfTimePortalFrame = BlockTextureCopied.get(ST.block(MD.ExU, "dark_portal", ST.block(MD.ExS, "deepPortal", Blocks.stonebrick)), 6, 2, CS.UNCOLOURED, false, false, false);

    @Override
    public List<MultiTileEntityMiniPortal> getPortalListA() {
        return sListWorldSide;
    }

    @Override
    public List<MultiTileEntityMiniPortal> getPortalListB() {
        return sListEndOfTimeSide;
    }

    @Override
    public void addToolTips2(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.tileentity.portal.endoftime.tooltip.1"));
        aList.add(LH.Chat.CYAN + LH.get("gt.tileentity.portal.endoftime.tooltip.2"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.tileentity.portal.endoftime.tooltip.3"));
    }

    @Override
    public void findTargetPortal() {
        block4: {
            block5: {
                this.mTarget = null;
                if (!MD.ExU.mLoaded && !MD.ExS.mLoaded || this.worldObj == null || !this.isServerSide()) break block4;
                if (this.worldObj.provider.dimensionId != 0) break block5;
                long tShortestDistance = 262144L;
                for (MultiTileEntityMiniPortal tTarget : sListEndOfTimeSide) {
                    if (tTarget == this || tTarget.isDead()) continue;
                    long tXDifference = this.xCoord - tTarget.xCoord * 128;
                    long tZDifference = this.zCoord - tTarget.zCoord * 128;
                    long tTempDist = tXDifference * tXDifference + tZDifference * tZDifference;
                    if (tTempDist < tShortestDistance) {
                        tShortestDistance = tTempDist;
                        this.mTarget = tTarget;
                        continue;
                    }
                    if (tTempDist != tShortestDistance || this.mTarget != null && Math.abs(tTarget.yCoord - this.yCoord) >= Math.abs(this.mTarget.yCoord - this.yCoord)) continue;
                    this.mTarget = tTarget;
                }
                break block4;
            }
            if (!WD.dimLM(this.worldObj)) break block4;
            long tShortestDistance = 262144L;
            for (MultiTileEntityMiniPortal tTarget : sListWorldSide) {
                if (tTarget == this || tTarget.isDead()) continue;
                long tXDifference = tTarget.xCoord - this.xCoord * 128;
                long tZDifference = tTarget.zCoord - this.zCoord * 128;
                long tTempDist = tXDifference * tXDifference + tZDifference * tZDifference;
                if (tTempDist < tShortestDistance) {
                    tShortestDistance = tTempDist;
                    this.mTarget = tTarget;
                    continue;
                }
                if (tTempDist != tShortestDistance || this.mTarget != null && Math.abs(tTarget.yCoord - this.yCoord) >= Math.abs(this.mTarget.yCoord - this.yCoord)) continue;
                this.mTarget = tTarget;
            }
        }
    }

    @Override
    public void addThisPortalToLists() {
        if ((MD.ExU.mLoaded || MD.ExS.mLoaded) && this.worldObj != null && this.isServerSide()) {
            if (this.worldObj.provider.dimensionId == 0) {
                if (!sListWorldSide.contains(this)) {
                    sListWorldSide.add(this);
                }
                for (MultiTileEntityMiniPortal tPortal : sListEndOfTimeSide) {
                    tPortal.findTargetPortal();
                }
                this.findTargetPortal();
            } else if (WD.dimLM(this.worldObj)) {
                if (!sListEndOfTimeSide.contains(this)) {
                    sListEndOfTimeSide.add(this);
                }
                for (MultiTileEntityMiniPortal tPortal : sListWorldSide) {
                    tPortal.findTargetPortal();
                }
                this.findTargetPortal();
            } else {
                this.setPortalInactive();
            }
        }
    }

    @Override
    public boolean onBlockActivated2(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        ItemStack aStack;
        if (this.isServerSide() && ST.valid(aStack = aPlayer.inventory.getCurrentItem()) && aStack.stackSize > 0 && OM.is_("ingotBedrockium", aStack)) {
            this.setPortalActive();
            if (this.mTarget != null) {
                UT.Entities.sendchat((Object)aPlayer, "X: " + this.mTarget.xCoord + "   Y: " + this.mTarget.yCoord + "   Z: " + this.mTarget.zCoord);
            }
            if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                --aStack.stackSize;
            }
        }
        return true;
    }

    @Override
    public float getBlockHardness() {
        return Blocks.stone.getBlockHardness(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public float getExplosionResistance2() {
        return Blocks.stone.getExplosionResistance(null);
    }

    @Override
    public ITexture getPortalTexture() {
        return this.sEndOfTimePortal;
    }

    @Override
    public ITexture getFrameTexture() {
        return this.sEndOfTimePortalFrame;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.portal.endoftime";
    }

    static {
        LH.add("gt.tileentity.portal.endoftime.tooltip.1", "Only works between the Last Millenium and the Overworld with a x128 Distance Factor!");
        LH.add("gt.tileentity.portal.endoftime.tooltip.2", "Margin of Error to still work: 512 Meters.");
        LH.add("gt.tileentity.portal.endoftime.tooltip.3", "Requires a Bedrockium Ingot for activation");
    }
}

