/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.portals;

import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.render.BlockTextureCopied;
import gregapi.render.ITexture;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import gregtech.tileentity.portals.MultiTileEntityMiniPortal;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

public class MultiTileEntityMiniPortalEnd
extends MultiTileEntityMiniPortal {
    public static List<MultiTileEntityMiniPortal> sListEndSide = new ArrayListNoNulls<MultiTileEntityMiniPortal>();
    public static List<MultiTileEntityMiniPortal> sListWorldSide = new ArrayListNoNulls<MultiTileEntityMiniPortal>();
    public ITexture sEndPortal = BlockTextureCopied.get((Block)Blocks.portal, 6, 0, CS.DYE_Black, false, true, true);
    public ITexture sEndPortalFrame = BlockTextureCopied.get(Blocks.end_portal_frame, 1, 0);

    @Override
    public List<MultiTileEntityMiniPortal> getPortalListA() {
        return sListWorldSide;
    }

    @Override
    public List<MultiTileEntityMiniPortal> getPortalListB() {
        return sListEndSide;
    }

    @Override
    public void addToolTips2(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.tileentity.portal.end.tooltip.1"));
        aList.add(LH.Chat.CYAN + LH.get("gt.tileentity.portal.end.tooltip.2"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.tileentity.portal.end.tooltip.3"));
    }

    @Override
    public void findTargetPortal() {
        block4: {
            block5: {
                this.mTarget = null;
                if (this.worldObj == null || !this.isServerSide()) break block4;
                if (this.worldObj.provider.dimensionId != 0) break block5;
                long tShortestDistance = 262144L;
                for (MultiTileEntityMiniPortal tTarget : sListEndSide) {
                    if (tTarget == this || tTarget.isDead()) continue;
                    long tXDifference = this.xCoord - tTarget.xCoord * 128;
                    long tZDifference = this.zCoord - tTarget.zCoord * 128;
                    long tTempDist = tXDifference * tXDifference + tZDifference * tZDifference;
                    if (tTempDist < tShortestDistance) {
                        tShortestDistance = tTempDist;
                        this.mTarget = tTarget;
                        continue;
                    }
                    if (tTempDist != tShortestDistance || this.mTarget != null && Math.abs(tTarget.yCoord - this.yCoord) >= Math.abs(this.mTarget.yCoord - this.yCoord)) continue;
                    this.mTarget = tTarget;
                }
                break block4;
            }
            if (this.worldObj.provider.dimensionId != 1) break block4;
            long tShortestDistance = 262144L;
            for (MultiTileEntityMiniPortal tTarget : sListWorldSide) {
                if (tTarget == this || tTarget.isDead()) continue;
                long tXDifference = tTarget.xCoord - this.xCoord * 128;
                long tZDifference = tTarget.zCoord - this.zCoord * 128;
                long tTempDist = tXDifference * tXDifference + tZDifference * tZDifference;
                if (tTempDist < tShortestDistance) {
                    tShortestDistance = tTempDist;
                    this.mTarget = tTarget;
                    continue;
                }
                if (tTempDist != tShortestDistance || this.mTarget != null && Math.abs(tTarget.yCoord - this.yCoord) >= Math.abs(this.mTarget.yCoord - this.yCoord)) continue;
                this.mTarget = tTarget;
            }
        }
    }

    @Override
    public void addThisPortalToLists() {
        if (this.worldObj != null && this.isServerSide()) {
            if (this.worldObj.provider.dimensionId == 0) {
                if (!sListWorldSide.contains(this)) {
                    sListWorldSide.add(this);
                }
                for (MultiTileEntityMiniPortal tPortal : sListEndSide) {
                    tPortal.findTargetPortal();
                }
                this.findTargetPortal();
            } else if (this.worldObj.provider.dimensionId == 1) {
                if (!sListEndSide.contains(this)) {
                    sListEndSide.add(this);
                }
                for (MultiTileEntityMiniPortal tPortal : sListWorldSide) {
                    tPortal.findTargetPortal();
                }
                this.findTargetPortal();
            } else {
                this.setPortalInactive();
            }
        }
    }

    @Override
    public boolean onBlockActivated2(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        ItemStack aStack;
        if (this.isServerSide() && ST.valid(aStack = aPlayer.inventory.getCurrentItem()) && aStack.stackSize > 0 && OM.is_("gemEnderEye", aStack)) {
            this.setPortalActive();
            if (this.mTarget != null) {
                UT.Entities.sendchat((Object)aPlayer, "X: " + this.mTarget.xCoord + "   Y: " + this.mTarget.yCoord + "   Z: " + this.mTarget.zCoord);
            }
            if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                --aStack.stackSize;
            }
        }
        return true;
    }

    @Override
    public float getBlockHardness() {
        return Blocks.end_stone.getBlockHardness(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public float getExplosionResistance2() {
        return Blocks.end_stone.getExplosionResistance(null);
    }

    @Override
    public ITexture getPortalTexture() {
        return this.sEndPortal;
    }

    @Override
    public ITexture getFrameTexture() {
        return this.sEndPortalFrame;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.portal.end";
    }

    static {
        LH.add("gt.tileentity.portal.end.tooltip.1", "Only works between the End and the Overworld with a x128 Distance Factor!");
        LH.add("gt.tileentity.portal.end.tooltip.2", "Margin of Error to still work: 512 Meters.");
        LH.add("gt.tileentity.portal.end.tooltip.3", "Requires Ender Eye for activation");
    }
}

