/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.multiblocks;

import gregapi.code.ArrayListNoNulls;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.energy.ITileEntityEnergyDataCapacitor;
import gregapi.tileentity.multiblocks.IMultiBlockEnergy;
import gregapi.tileentity.multiblocks.ITileEntityMultiBlockController;
import gregapi.tileentity.multiblocks.TileEntityBase10MultiBlockBase;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;

public class MultiTileEntityLightningRod
extends TileEntityBase10MultiBlockBase
implements ITileEntityEnergy,
ITileEntityEnergyDataCapacitor,
IMultiBlockEnergy {
    public long mEnergy = 0L;
    public long mCapacity = 0L;
    public byte mSize = 0;
    public TagData mEnergyTypeEmitted = TD.Energy.EU;
    public static List<MultiTileEntityLightningRod> ALL_LIGHTNING_RODS = new ArrayListNoNulls<MultiTileEntityLightningRod>();

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        this.mEnergy = aNBT.getLong("gt.energy");
        this.mCapacity = aNBT.getLong("gt.capacity");
        if (aNBT.hasKey("gt.energy.emitted")) {
            this.mEnergyTypeEmitted = TagData.createTagData(aNBT.getString("gt.energy.emitted"));
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.energy", this.mEnergy);
    }

    @Override
    public boolean checkStructure2(ChunkCoordinates aCoordinates, Entity aPlayer, IInventory aInventory) {
        boolean tSuccess = true;
        this.mSize = 0;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                if (!ITileEntityMultiBlockController.Util.checkAndSetTargetOffset(this, i, 0, j, 18004, this.getMultiTileEntityRegistryID(), 0, -1, aCoordinates, aPlayer, aInventory)) {
                    tSuccess = false;
                }
                if (!ITileEntityMultiBlockController.Util.checkAndSetTargetOffset(this, i, 1, j, 18041, this.getMultiTileEntityRegistryID(), 0, -1, aCoordinates, aPlayer, aInventory)) {
                    tSuccess = false;
                }
                if (!ITileEntityMultiBlockController.Util.checkAndSetTargetOffset(this, i, 2, j, 18004, this.getMultiTileEntityRegistryID(), 0, -1, aCoordinates, aPlayer, aInventory)) {
                    tSuccess = false;
                }
                if (!ITileEntityMultiBlockController.Util.checkAndSetTargetOffset(this, i, 3, j, 18041, this.getMultiTileEntityRegistryID(), 0, -1, aCoordinates, aPlayer, aInventory)) {
                    tSuccess = false;
                }
                if (ITileEntityMultiBlockController.Util.checkAndSetTargetOffset(this, i, 4, j, 18004, this.getMultiTileEntityRegistryID(), 0, -1, aCoordinates, aPlayer, aInventory)) continue;
                tSuccess = false;
            }
        }
        if (tSuccess) {
            while (ITileEntityMultiBlockController.Util.checkAndSetTargetOffset(this, 0, 5 + this.mSize, 0, 18104, this.getMultiTileEntityRegistryID(), 0, -1, aCoordinates, aPlayer, aInventory)) {
                this.mSize = (byte)(this.mSize + 1);
            }
        }
        return tSuccess;
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.structure") + ":");
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.lightningrod.1"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.lightningrod.2"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.lightningrod.3"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.lightningrod.4"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.lightningrod.5"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.lightningrod.6"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.lightningrod.7"));
        aList.add(LH.Chat.YELLOW + LH.get("gt.tooltip.multiblock.lightningrod.8"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.tooltip.multiblock.lightningrod.9"));
        aList.add(LH.Chat.GREEN + LH.get("gt.lang.energy.output") + ": " + LH.Chat.WHITE + CS.VREC[6] + " " + this.mEnergyTypeEmitted.getLocalisedChatNameShort() + LH.Chat.WHITE + "/p (up to 16 Amps)");
        aList.add(LH.Chat.WHITE + this.mCapacity + " " + this.mEnergyTypeEmitted.getLocalisedChatNameShort() + LH.Chat.GRAY + " per Lightning Strike");
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public boolean isInsideStructure(int aX, int aY, int aZ) {
        return aY >= this.yCoord && aX >= this.xCoord - 1 && aZ >= this.zCoord - 1 && aX <= this.xCoord + 1 && aZ <= this.zCoord + 1 && (aY < this.yCoord + 5 || aX == this.xCoord && aZ == this.zCoord && aY <= this.yCoord + this.mSize + 4);
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide) {
            if (this.checkStructure(this.mSize < 100 && aTimer % 1200L == 300L && (this.worldObj.isRaining() || this.worldObj.isThundering()))) {
                if (this.mEnergy >= CS.VREC[6]) {
                    this.mEnergy -= Math.max(1L, ITileEntityEnergy.Util.emitEnergyToSide(this.mEnergyTypeEmitted, (byte)0, CS.VREC[6], 16L, this)) * CS.VREC[6];
                } else {
                    this.mEnergy = 0L;
                    if (this.mSize > 0 && this.yCoord + this.mSize >= 100 && this.rng(1000000) < Math.min(100, this.mSize) && (this.worldObj.isThundering() || this.worldObj.isRaining() && this.rng(10) == 0)) {
                        int tCount = 1;
                        for (MultiTileEntityLightningRod tLightningRod : ALL_LIGHTNING_RODS) {
                            if (tLightningRod == this || tLightningRod.mSize <= 0 || tLightningRod.getWorld() != this.worldObj || Math.abs(tLightningRod.xCoord - this.xCoord) >= 256 || Math.abs(tLightningRod.zCoord - this.zCoord) >= 256) continue;
                            ++tCount;
                        }
                        if (this.rng(tCount) == 0) {
                            boolean temp = true;
                            int j = this.worldObj.getHeight();
                            for (int i = this.yCoord + this.mSize + 5; i < j; ++i) {
                                if (WD.air(this.worldObj, this.xCoord, i, this.zCoord)) continue;
                                temp = false;
                                break;
                            }
                            if (temp) {
                                this.worldObj.addWeatherEffect((Entity)new EntityLightningBolt(this.worldObj, (double)this.xCoord, (double)(this.yCoord + this.mSize + 4), (double)this.zCoord));
                                this.mEnergy = this.mCapacity;
                            }
                        }
                    }
                }
            } else {
                this.mEnergy = 0L;
            }
        }
    }

    @Override
    public void onTickFirst2(boolean aIsServerSide) {
        super.onTickFirst2(aIsServerSide);
        if (aIsServerSide && !ALL_LIGHTNING_RODS.contains(this)) {
            ALL_LIGHTNING_RODS.add(this);
        }
    }

    @Override
    public void validate() {
        super.validate();
        if (this.isServerSide() && !ALL_LIGHTNING_RODS.contains(this)) {
            ALL_LIGHTNING_RODS.add(this);
        }
    }

    @Override
    public void invalidate() {
        if (this.isServerSide()) {
            ALL_LIGHTNING_RODS.remove(this);
        }
        super.invalidate();
    }

    @Override
    public void onChunkUnload() {
        if (this.isServerSide()) {
            ALL_LIGHTNING_RODS.remove(this);
        }
        super.onChunkUnload();
    }

    @Override
    public byte getDefaultSide() {
        return 0;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_BOTTOM;
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return aEmitting && aEnergyType == this.mEnergyTypeEmitted;
    }

    @Override
    public boolean isEnergyEmittingTo(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return this.isEnergyType(aEnergyType, aSide, false);
    }

    @Override
    public boolean isEnergyCapacitorType(TagData aEnergyType, byte aSide) {
        return aEnergyType == this.mEnergyTypeEmitted;
    }

    @Override
    public long getEnergySizeOutputRecommended(TagData aEnergyType, byte aSide) {
        return 2048L;
    }

    @Override
    public long getEnergySizeOutputMin(TagData aEnergyType, byte aSide) {
        return 1024L;
    }

    @Override
    public long getEnergySizeOutputMax(TagData aEnergyType, byte aSide) {
        return 4096L;
    }

    @Override
    public long getEnergyStored(TagData aEnergyType, byte aSide) {
        return aEnergyType == this.mEnergyTypeEmitted ? this.mEnergy : 0L;
    }

    @Override
    public long getEnergyCapacity(TagData aEnergyType, byte aSide) {
        return aEnergyType == this.mEnergyTypeEmitted ? this.mCapacity : 0L;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return this.mEnergyTypeEmitted.AS_LIST;
    }

    @Override
    public Collection<TagData> getEnergyCapacitorTypes(byte aSide) {
        return this.mEnergyTypeEmitted.AS_LIST;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.multiblock.lightningrod";
    }

    static {
        LH.add("gt.tooltip.multiblock.lightningrod.1", "Bottom: 3x3 of Tungsten Walls with Main at Center");
        LH.add("gt.tooltip.multiblock.lightningrod.2", "Then: Full 3x3 of Large Niobium-Titanium Coils");
        LH.add("gt.tooltip.multiblock.lightningrod.3", "Then: Full 3x3 of Tungsten Walls");
        LH.add("gt.tooltip.multiblock.lightningrod.4", "Then: Full 3x3 of Large Niobium-Titanium Coils");
        LH.add("gt.tooltip.multiblock.lightningrod.5", "Top: 3x3 of Tungsten Walls");
        LH.add("gt.tooltip.multiblock.lightningrod.6", "Centered Above: 1x1 Pillar of simple Lightning Rod Blocks");
        LH.add("gt.tooltip.multiblock.lightningrod.7", "The Tip of the Rod has to be at Y = 100 or above");
        LH.add("gt.tooltip.multiblock.lightningrod.8", "Optimum Efficiency at a Rod Length of 100m");
        LH.add("gt.tooltip.multiblock.lightningrod.9", "Reduced Efficiency if too close to another Lightning Rod (256m)");
    }
}

