/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.multiblocks;

import gregapi.data.LH;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.multiblocks.ITileEntityMultiBlockController;
import gregapi.tileentity.multiblocks.TileEntityBase10MultiBlockMachine;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidHandler;

public class MultiTileEntityAutoclave
extends TileEntityBase10MultiBlockMachine {
    @Override
    public boolean checkStructure2(ChunkCoordinates aCoordinates, Entity aPlayer, IInventory aInventory) {
        int tZ;
        int tY;
        int tX = this.getOffsetXN(this.mFacing);
        if (this.worldObj.blockExists(tX - 1, tY = this.yCoord + 1, (tZ = this.getOffsetZN(this.mFacing)) - 1) && this.worldObj.blockExists(tX + 1, tY, tZ - 1) && this.worldObj.blockExists(tX - 1, tY, tZ + 1) && this.worldObj.blockExists(tX + 1, tY, tZ + 1)) {
            boolean tSuccess = true;
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    for (int k = -1; k <= 1; ++k) {
                        if (i == 0 && j == 0 && k == 0) {
                            if (this.getAir(tX + i, tY + j, tZ + k)) {
                                this.worldObj.setBlockToAir(tX + i, tY + j, tZ + k);
                                continue;
                            }
                            tSuccess = false;
                            continue;
                        }
                        if (ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + i, tY + j, tZ + k, 18022, this.getMultiTileEntityRegistryID(), 0, -64, aCoordinates, aPlayer, aInventory)) continue;
                        tSuccess = false;
                    }
                }
            }
            return tSuccess;
        }
        return this.mStructureOkay;
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.structure") + ":");
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.autoclave.1"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.autoclave.2"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.autoclave.3"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public boolean isInsideStructure(int aX, int aY, int aZ) {
        int tX = this.getOffsetXN(this.mFacing);
        int tY = this.yCoord;
        int tZ = this.getOffsetZN(this.mFacing);
        return aX >= tX - 1 && aY >= tY && aZ >= tZ - 1 && aX <= tX + 1 && aY <= tY + 2 && aZ <= tZ + 1;
    }

    @Override
    public DelegatorTileEntity<IFluidHandler> getFluidOutputTarget(byte aSide, Fluid aOutput) {
        return this.getAdjacentTank((byte)0);
    }

    @Override
    public DelegatorTileEntity<TileEntity> getItemOutputTarget(byte aSide) {
        return this.getAdjacentTileEntity((byte)0);
    }

    @Override
    public DelegatorTileEntity<IInventory> getItemInputTarget(byte aSide) {
        return null;
    }

    @Override
    public DelegatorTileEntity<IFluidHandler> getFluidInputTarget(byte aSide) {
        return null;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.multiblock.autoclave";
    }

    static {
        LH.add("gt.tooltip.multiblock.autoclave.1", "3x3x3 Hollow of Dense Stainless Steel Walls");
        LH.add("gt.tooltip.multiblock.autoclave.2", "Main Block centered on Side-Bottom and facing outwards");
        LH.add("gt.tooltip.multiblock.autoclave.3", "Input and Output at any Blocks");
    }
}

