/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.inventories;

import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.TD;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityConnectedInventory;
import gregapi.tileentity.base.TileEntityBase07Paintable;
import gregapi.tileentity.inventories.MultiTileEntityMassStorage;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class MultiTileEntityStorageInserter
extends TileEntityBase07Paintable
implements ITileEntityConnectedInventory {
    public static IIconContainer sColored = new Textures.BlockIcons.CustomIcon("machines/massstorage/inserter/colored/sides");
    public static IIconContainer sOverlay = new Textures.BlockIcons.CustomIcon("machines/massstorage/inserter/overlay/sides");

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        int i;
        if (!UT.Entities.isPlayer(aPlayer)) {
            return true;
        }
        ArrayListNoNulls<MultiTileEntityMassStorage> tList = new ArrayListNoNulls<MultiTileEntityMassStorage>();
        int tX = this.getOffsetX(aSide);
        int tY = this.getOffsetY(aSide);
        int tZ = this.getOffsetZ(aSide);
        boolean[] tDirectionsToGo = new boolean[]{true, true, true, true};
        boolean tOnlyHand = aPlayer.inventory.getCurrentItem() != null;
        for (i = 0; i <= 6 && this.checkColumn(aPlayer, tX, --tY, tZ, tList, tOnlyHand); ++i) {
            if (i != 6) continue;
            return true;
        }
        for (i = 0; i < 50 && UT.Code.containsBoolean(true, tDirectionsToGo) && (!tOnlyHand || aPlayer.inventory.getCurrentItem() != null); ++i) {
            if (tDirectionsToGo[0] && this.checkColumn(aPlayer, tX + i, tY, tZ, tList, tOnlyHand)) {
                tDirectionsToGo[0] = false;
            }
            if (tOnlyHand && aPlayer.inventory.getCurrentItem() == null) break;
            if (tDirectionsToGo[1] && this.checkColumn(aPlayer, tX - i, tY, tZ, tList, tOnlyHand)) {
                tDirectionsToGo[1] = false;
            }
            if (tOnlyHand && aPlayer.inventory.getCurrentItem() == null) break;
            if (tDirectionsToGo[2] && this.checkColumn(aPlayer, tX, tY, tZ + i, tList, tOnlyHand)) {
                tDirectionsToGo[2] = false;
            }
            if (tOnlyHand && aPlayer.inventory.getCurrentItem() == null) break;
            if (!tDirectionsToGo[3] || !this.checkColumn(aPlayer, tX, tY, tZ - i, tList, tOnlyHand)) continue;
            tDirectionsToGo[3] = false;
        }
        for (MultiTileEntityMassStorage tTileEntity : tList) {
            if (tOnlyHand && aPlayer.inventory.getCurrentItem() == null) break;
            this.tryInsert(aPlayer, tTileEntity, tOnlyHand);
        }
        ST.update((Entity)aPlayer);
        return true;
    }

    public boolean checkColumn(EntityPlayer aPlayer, int aX, int aY, int aZ, ArrayListNoNulls<MultiTileEntityMassStorage> aList, boolean aOnlyHand) {
        Block tBlock;
        if (!WD.floor(this.worldObj, aX, aY, aZ)) {
            return true;
        }
        boolean temp = true;
        for (int i = 1; !(i >= 8 || (tBlock = WD.block((IBlockAccess)this.worldObj, aX, aY + i, aZ)).getMaterial() != Material.carpet && WD.hasCollide(this.worldObj, aX, aY + i, aZ, tBlock)); ++i) {
            for (byte tSide : CS.ALL_SIDES_HORIZONTAL) {
                TileEntity tTileEntity = this.getTileEntity(aX + CS.OFFX[tSide], aY + i, aZ + CS.OFFZ[tSide]);
                if (tTileEntity instanceof MultiTileEntityStorageInserter) {
                    temp = false;
                    continue;
                }
                if (!(tTileEntity instanceof MultiTileEntityMassStorage) || ((MultiTileEntityMassStorage)tTileEntity).mFacing != CS.OPOS[tSide]) continue;
                temp = false;
                if (((MultiTileEntityMassStorage)tTileEntity).slotHas(1)) {
                    this.tryInsert(aPlayer, (MultiTileEntityMassStorage)tTileEntity, aOnlyHand);
                    if (!aOnlyHand || aPlayer.inventory.getCurrentItem() != null) continue;
                    return temp;
                }
                aList.add((MultiTileEntityMassStorage)tTileEntity);
            }
        }
        return temp;
    }

    public void tryInsert(EntityPlayer aPlayer, MultiTileEntityMassStorage aStorage, boolean aOnlyHand) {
        if (aPlayer.inventory.getCurrentItem() != null) {
            aPlayer.inventory.mainInventory[aPlayer.inventory.currentItem] = aStorage.insertItems(aPlayer.inventory.mainInventory[aPlayer.inventory.currentItem], true);
        }
        if (!aOnlyHand) {
            for (int i = 9; i < aPlayer.inventory.mainInventory.length; ++i) {
                if (aPlayer.inventory.mainInventory[i] == null || ST.nonautoinsert(aPlayer.inventory.mainInventory[i]) || !aStorage.slotHas(1) && aPlayer.inventory.mainInventory[i].getMaxStackSize() <= 1) continue;
                aPlayer.inventory.mainInventory[i] = aStorage.insertItems(aPlayer.inventory.mainInventory[i], false);
            }
        }
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aShouldSideBeRendered[aSide] ? BlockTextureMulti.get(BlockTextureDefault.get(sColored, this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)), BlockTextureDefault.get(sOverlay)) : null;
    }

    @Override
    public boolean canDrop(int aSlot) {
        return true;
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.storage.inserter";
    }
}

