/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.inventories;

import gregapi.block.multitileentity.MultiTileEntityContainer;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.inventories.MultiTileEntitySafe;
import gregapi.util.UT;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class MultiTileEntitySafeMechanical
extends MultiTileEntitySafe {
    public static IIconContainer[] sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/safes/mechanical/colored/front"), new Textures.BlockIcons.CustomIcon("machines/safes/mechanical/colored/back"), new Textures.BlockIcons.CustomIcon("machines/safes/mechanical/colored/side")};
    public static IIconContainer[] sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/safes/mechanical/overlay/front"), new Textures.BlockIcons.CustomIcon("machines/safes/mechanical/overlay/back"), new Textures.BlockIcons.CustomIcon("machines/safes/mechanical/overlay/side")};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.hasKey("gt.owner") && !CS.OWNERSHIP_RESET) {
            this.mOwner = UUID.fromString(aNBT.getString("gt.owner"));
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        if (this.mOwner != null) {
            aNBT.setString("gt.owner", this.mOwner.toString());
        }
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.owner.controlled"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public boolean onPlaced(ItemStack aStack, EntityPlayer aPlayer, MultiTileEntityContainer aMTEContainer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (aPlayer != null && aPlayer.isSneaking()) {
            this.allowInteraction((Entity)aPlayer);
        }
        return super.onPlaced(aStack, aPlayer, aMTEContainer, aWorld, aX, aY, aZ, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public boolean allowInteraction(Entity aEntity) {
        if (this.mOwner == null && aEntity != null && !CS.OWNERSHIP_RESET) {
            this.mOwner = aEntity.getUniqueID();
            this.updateClientData();
        }
        return super.allowInteraction(aEntity);
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        return aSendAll ? this.getClientDataPacketByteArray(aSendAll, (byte)UT.Code.getR(this.mRGBa), (byte)UT.Code.getG(this.mRGBa), (byte)UT.Code.getB(this.mRGBa), this.getDirectionData()) : this.getClientDataPacketByte(aSendAll, this.getVisualData());
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        this.mRGBa = UT.Code.getRGBInt(new short[]{UT.Code.unsignB(aData[0]), UT.Code.unsignB(aData[1]), UT.Code.unsignB(aData[2])});
        this.setDirectionData(aData[3]);
        return true;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (!aShouldSideBeRendered[aSide]) {
            return null;
        }
        int aIndex = aSide == this.mFacing ? 0 : (aSide == CS.OPOS[this.mFacing] ? 1 : 2);
        return BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[aIndex], this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)), BlockTextureDefault.get(sOverlays[aIndex]));
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.safe.mechanical";
    }
}

