/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.food;

import enviromine.handlers.EM_StatusManager;
import enviromine.trackers.EnviroDataTracker;
import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityItemInternal;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.data.OD;
import gregapi.item.IItemRottable;
import gregapi.item.multiitem.MultiItemRandom;
import gregapi.item.multiitem.food.FoodStatFluid;
import gregapi.item.multiitem.food.IFoodStat;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityQuickObstructionCheck;
import gregapi.tileentity.notick.TileEntityBase03MultiTileEntities;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import squeek.applecore.api.food.FoodValues;

public class MultiTileEntitySandwich
extends TileEntityBase03MultiTileEntities
implements IMultiTileEntity.IMTE_SyncDataByteArray,
IMultiTileEntity.IMTE_IsProvidingWeakPower,
IMultiTileEntity.IMTE_IsProvidingStrongPower,
IMultiTileEntity.IMTE_GetComparatorInputOverride,
IMultiTileEntity.IMTE_GetBlockHardness,
IMultiTileEntity.IMTE_IsSideSolid,
IMultiTileEntity.IMTE_GetLightOpacity,
IMultiTileEntity.IMTE_GetExplosionResistance,
ITileEntityQuickObstructionCheck,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState,
IMultiTileEntity.IMTE_GetMaxStackSize,
IMultiTileEntity.IMTE_OnlyPlaceableWhenSneaking,
IMultiTileEntity.IMTE_CanPlace,
IMultiTileEntity.IMTE_OnItemRightClick,
IMultiTileEntity.IMTE_AddToolTips,
IMultiTileEntity.IMTE_GetFoodValues,
IMultiTileEntity.IMTE_OnEaten,
IMultiTileEntity.IMTE_GetItemUseAction,
IMultiTileEntity.IMTE_GetMaxItemUseDuration,
IItemRottable {
    public ItemStack[] mStacks = new ItemStack[16];
    public byte[] mDisplay = new byte[]{-2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    public byte mSize = 1;
    public boolean mRedstone = false;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.hasKey("gt.redstone")) {
            this.mRedstone = aNBT.getBoolean("gt.redstone");
        }
        for (int i = 0; i < this.mStacks.length; ++i) {
            this.mStacks[i] = ST.load(aNBT, "sandwich." + i);
        }
        if (!UT.Code.containsSomething(this.mStacks)) {
            this.mStacks[11] = IL.Food_Toast_Sliced.get(1L, new Object[0]);
            this.mStacks[10] = IL.Food_Pickle_Sliced.get(1L, new Object[0]);
            this.mStacks[9] = ST.make(CS.ItemsGT.BOTTLES, 1L, 1020L);
            this.mStacks[8] = IL.Food_Tomato_Sliced.get(1L, new Object[0]);
            this.mStacks[7] = ST.make(CS.ItemsGT.BOTTLES, 1L, 3101L);
            this.mStacks[6] = IL.Food_Onion_Sliced.get(1L, new Object[0]);
            this.mStacks[5] = IL.Food_Cheese_Sliced.get(1L, new Object[0]);
            this.mStacks[4] = IL.Food_Cucumber_Sliced.get(1L, new Object[0]);
            this.mStacks[2] = IL.Food_Meat.get(1L, new Object[0]);
            this.mStacks[0] = IL.Food_Toast_Sliced.get(1L, new Object[0]);
        }
        this.updateSandwich();
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setBoolean(aNBT, "gt.redstone", this.mRedstone);
        for (int i = 0; i < this.mStacks.length; ++i) {
            ST.save(aNBT, "sandwich." + i, this.mStacks[i]);
        }
    }

    @Override
    public final NBTTagCompound writeItemNBT(NBTTagCompound aNBT) {
        aNBT = super.writeItemNBT(aNBT);
        UT.NBT.setBoolean(aNBT, "gt.redstone", this.mRedstone);
        for (int i = 0; i < this.mStacks.length; ++i) {
            ST.save(aNBT, "sandwich." + i, ST.amount(1L, this.mStacks[i]));
        }
        return aNBT;
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        if (MD.APC.mLoaded) {
            for (ItemStack tStack : this.mStacks) {
                if (!ST.valid(tStack)) continue;
                aList.add(1, LH.Chat.GRAY + tStack.getDisplayName());
            }
        } else {
            aList.add(1, LH.Chat.RED + "Food: " + this.getTotalFood() + " - Saturation: " + this.getTotalSaturation());
            for (ItemStack tStack : this.mStacks) {
                if (!ST.valid(tStack)) continue;
                aList.add(2, LH.Chat.GRAY + tStack.getDisplayName());
            }
        }
    }

    @Override
    public ArrayListNoNulls<ItemStack> getDrops(int aFortune, boolean aSilkTouch) {
        MultiTileEntityRegistry tRegistry;
        ArrayListNoNulls<ItemStack> rList = ST.arraylist(new ItemStack[0]);
        int tCount = 0;
        for (int i = 0; i < this.mStacks.length; ++i) {
            if (!ST.valid(this.mStacks[i])) continue;
            ++tCount;
        }
        if (tCount == 1 && ST.valid(this.mStacks[0]) && ST.container(this.mStacks[0], true) == null) {
            rList.add(this.mStacks[0]);
        }
        if (rList.isEmpty() && (tRegistry = MultiTileEntityRegistry.getRegistry(this.getMultiTileEntityRegistryID())) != null) {
            rList.add(tRegistry.getItem(this.getMultiTileEntityID(), this.mStacks[0].stackSize, this.writeItemNBT(UT.NBT.make())));
        }
        return rList;
    }

    @Override
    public boolean onBlockActivated2(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return true;
        }
        ItemStack aStack = aPlayer.getCurrentEquippedItem();
        int tStackSize = this.addIngredient(aStack);
        if (tStackSize > 0) {
            ItemStack tContainer = ST.mul(tStackSize, ST.container(aStack, true));
            ST.use((Entity)aPlayer, aStack, tStackSize);
            ST.give((Entity)aPlayer, tContainer);
            return true;
        }
        return true;
    }

    public int addIngredient(ItemStack aStack) {
        if (ST.invalid(aStack)) {
            return 0;
        }
        this.updateSandwich();
        if (ST.equal(this.getIngredientTop(), aStack)) {
            return 0;
        }
        int rStackSize = this.getIngredientCount();
        if (IL.Bottle_Empty.equal(ST.container(aStack, true), true, true)) {
            rStackSize = (int)UT.Code.divup(rStackSize, 4L);
        }
        if (aStack.stackSize < rStackSize) {
            return 0;
        }
        if (!this.mRedstone && OD.itemRedstone.is(aStack)) {
            this.mRedstone = true;
            this.updateSandwich();
            this.causeBlockUpdate();
            this.playCollect();
            return rStackSize;
        }
        if (this.mSize >= 16) {
            return 0;
        }
        if (ST.valid(this.mStacks[this.mSize]) || this.mSize == 0) {
            CS.ERR.println("ERROR: Attempted to add Sandwich Ingredient to already occupied Slot: " + this.mSize + " ; Clientside: " + this.worldObj.isRemote);
            for (int i = 0; i < this.mStacks.length; i = (int)((byte)(i + 1))) {
                if (ST.valid(this.mStacks[i])) {
                    CS.ERR.println(i + ": " + ST.regName(this.mStacks[i]) + ":" + ST.meta(this.mStacks[i]) + " ; Display: " + this.mDisplay[i]);
                    continue;
                }
                CS.ERR.println(i + ": null ; Display: " + this.mDisplay[i]);
            }
            CS.ERR.println("==================================================");
            return 0;
        }
        Byte tID = CS.Sandwiches.INGREDIENTS.get(aStack);
        if (tID == null) {
            tID = CS.Sandwiches.INGREDIENTS.get(aStack, 32767L);
        }
        if (tID == null || this.mSize + Math.max(1, CS.Sandwiches.INGREDIENT_MODEL_THICKNESS[UT.Code.unsignB(tID)]) > 16) {
            return 0;
        }
        this.mStacks[this.mSize] = ST.amount(rStackSize, aStack);
        this.updateSandwich();
        this.causeBlockUpdate();
        this.playCollect();
        return rStackSize;
    }

    public int getTotalFood() {
        int rFood = 0;
        for (ItemStack aStack : this.mStacks) {
            if (!ST.valid(aStack)) continue;
            rFood += Math.max(1, ST.food(aStack));
        }
        return rFood;
    }

    public float getTotalSaturation() {
        float rSaturation = 0.0f;
        for (ItemStack aStack : this.mStacks) {
            if (!ST.valid(aStack)) continue;
            rSaturation = Math.max(rSaturation, ST.saturation(aStack));
        }
        return rSaturation + 0.5f;
    }

    public float getTotalHydration() {
        float rHydration = 0.0f;
        for (ItemStack aStack : this.mStacks) {
            if (!ST.valid(aStack)) continue;
            rHydration += ST.hydration(aStack);
        }
        return rHydration;
    }

    public ItemStack getIngredientTop() {
        for (int i = this.mStacks.length - 1; i >= 0; --i) {
            if (!ST.valid(this.mStacks[i])) continue;
            return this.mStacks[i];
        }
        return null;
    }

    public int getIngredientCount() {
        return ST.valid(this.mStacks[0]) ? this.mStacks[0].stackSize : 1;
    }

    public void updateSandwich() {
        if (this.worldObj == null || this.isServerSide()) {
            for (int i = 0; i < this.mStacks.length; i = (int)((byte)(i + 1))) {
                Byte tID = CS.Sandwiches.INGREDIENTS.get(this.mStacks[i]);
                if (tID == null) {
                    tID = CS.Sandwiches.INGREDIENTS.get(this.mStacks[i], 32767L);
                }
                this.mDisplay[i] = tID == null ? -1 : (int)tID.byteValue();
            }
            this.updateSandwichSize();
            this.updateClientData();
        }
    }

    public void updateSandwichSize() {
        for (int i = 0; i < this.mDisplay.length; i = (int)((byte)(i + 1))) {
            if (this.mDisplay[i] == -1) continue;
            this.mSize = (byte)UT.Code.bind(1L, 16L, i + Math.max(1, CS.Sandwiches.INGREDIENT_MODEL_THICKNESS[UT.Code.unsignB(this.mDisplay[i])]));
        }
    }

    @Override
    public int getComparatorInputOverride(byte aSide) {
        return UT.Code.bind4(this.mSize - 1);
    }

    @Override
    public int isProvidingStrongPower(byte aOppositeSide) {
        return this.mRedstone ? (int)UT.Code.bind4(this.mSize - 1) : 0;
    }

    @Override
    public int isProvidingWeakPower(byte aOppositeSide) {
        return this.mRedstone ? (int)UT.Code.bind4(this.mSize - 1) : 0;
    }

    @Override
    public boolean canPlace(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return WD.block((IBlockAccess)aWorld, aX, aY - 1, aZ).isSideSolid((IBlockAccess)aWorld, aX, aY - 1, aZ, CS.FORGE_DIR[1]);
    }

    @Override
    public ItemStack onItemRightClick(MultiTileEntityItemInternal aItem, ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        if (UT.Entities.isCreative(aPlayer) || aPlayer.getFoodStats().needFood()) {
            aPlayer.setItemInUse(aStack, Math.max(FoodStatFluid.INSTANCE.getFoodLevel(aStack.getItem(), aStack, null) * 8, 32));
            return aStack;
        }
        return aStack;
    }

    @Override
    public int getMaxItemUseDuration(MultiTileEntityItemInternal aItem, ItemStack aStack) {
        return Math.max(this.getTotalFood() * 8, 32);
    }

    @Override
    public EnumAction getItemUseAction(MultiTileEntityItemInternal aItem, ItemStack aStack) {
        return EnumAction.eat;
    }

    @Override
    public ItemStack onEaten(MultiTileEntityItemInternal aItem, ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        if (MD.APC.mLoaded) {
            aPlayer.getFoodStats().func_151686_a((ItemFood)UT.Reflection.callConstructor("squeek.applecore.api.food.ItemFoodProxy", 0, null, true, aStack.getItem()), aStack);
        } else {
            aPlayer.getFoodStats().addStats(this.getTotalFood(), this.getTotalSaturation());
        }
        if (!aWorld.isRemote && MD.ENVM.mLoaded) {
            try {
                EnviroDataTracker tTracker = EM_StatusManager.lookupTracker((EntityLivingBase)aPlayer);
                if (tTracker != null && tTracker.bodyTemp >= 0.0f) {
                    float tHydration = this.getTotalHydration();
                    if (tHydration > 0.0f) {
                        tTracker.hydrate(tHydration);
                    } else if (tHydration < 0.0f) {
                        tTracker.dehydrate(-tHydration);
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        boolean temp = true;
        for (ItemStack tStack : this.mStacks) {
            IFoodStat tStat;
            if (!ST.valid(tStack) || !(ST.item_(tStack) instanceof MultiItemRandom) || (tStat = ((MultiItemRandom)ST.item_((ItemStack)tStack)).mFoodStats.get(ST.meta_(tStack))) == null) continue;
            tStat.onEaten((Item)aItem, tStack, aPlayer, false, temp);
            temp = false;
        }
        ST.use((Entity)aPlayer, aStack, 1L);
        return aStack;
    }

    @Override
    public FoodValues getFoodValues(MultiTileEntityItemInternal aItem, ItemStack aStack) {
        return new FoodValues(this.getTotalFood(), this.getTotalSaturation());
    }

    @Override
    public ItemStack getRotten(ItemStack aStack) {
        return IL.ENVM_Rotten_Food.get(aStack.stackSize, new Object[0]);
    }

    @Override
    public ItemStack getRotten(ItemStack aStack, World aWorld, int aX, int aY, int aZ) {
        return IL.ENVM_Rotten_Food.get(aStack.stackSize, new Object[0]);
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        return this.getClientDataPacketByteArray(aSendAll, this.mDisplay);
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        System.arraycopy(aData, 0, this.mDisplay, 0, 16);
        this.updateSandwichSize();
        return true;
    }

    @Override
    public ITexture getTexture(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return (CS.SIDES_VERTICAL[aSide] ? CS.Sandwiches.INGREDIENT_TEXTURES_TOP : CS.Sandwiches.INGREDIENT_TEXTURES_SIDES)[UT.Code.unsignB(this.mDisplay[aRenderPass / 4])];
    }

    @Override
    public boolean usesRenderPass(int aRenderPass, boolean[] aShouldSideBeRendered) {
        short tID = UT.Code.unsignB(this.mDisplay[aRenderPass / 4]);
        if (tID == 255) {
            return false;
        }
        return aRenderPass % 4 == 0 || UT.Code.unsignB(CS.Sandwiches.INGREDIENT_MODEL_IDS[tID]) == 14;
    }

    @Override
    public int getRenderPasses(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 64;
    }

    @Override
    public boolean setBlockBounds(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        short tID = UT.Code.unsignB(this.mDisplay[aRenderPass / 4]);
        short tModel = UT.Code.unsignB(CS.Sandwiches.INGREDIENT_MODEL_IDS[tID]);
        short tThickness = CS.Sandwiches.INGREDIENT_MODEL_THICKNESS[tID];
        if (tModel == 252 && aRenderPass >= 4) {
            float tOffset = (float)(16 - (aRenderPass /= 4)) * 5.0E-4f;
            switch (UT.Code.unsignB(CS.Sandwiches.INGREDIENT_MODEL_IDS[UT.Code.unsignB(this.mDisplay[aRenderPass - 1])])) {
                case 2: 
                case 3: 
                case 14: 
                case 252: {
                    return this.box(aBlock, CS.PX_P[2] - tOffset, CS.PX_P[1] / 2.0f, CS.PX_P[2] - tOffset, CS.PX_N[2] + tOffset, CS.PX_P[aRenderPass + tThickness], CS.PX_N[2] + tOffset);
                }
            }
            return this.box(aBlock, CS.PX_P[1] - tOffset, CS.PX_P[aRenderPass] - CS.PX_P[1] / 2.0f, CS.PX_P[1] - tOffset, CS.PX_N[1] + tOffset, CS.PX_P[aRenderPass + tThickness], CS.PX_N[1] + tOffset);
        }
        switch (tModel) {
            case 1: {
                return this.box(aBlock, CS.PX_P[1], CS.PX_P[aRenderPass / 4], CS.PX_P[1], CS.PX_N[1], CS.PX_P[aRenderPass / 4 + tThickness], CS.PX_N[1]);
            }
            case 2: {
                return this.box(aBlock, CS.PX_P[2], CS.PX_P[aRenderPass / 4], CS.PX_P[2], CS.PX_N[2], CS.PX_P[aRenderPass / 4 + tThickness], CS.PX_N[2]);
            }
            case 3: {
                return this.box(aBlock, CS.PX_P[3], CS.PX_P[aRenderPass / 4], CS.PX_P[3], CS.PX_N[3], CS.PX_P[aRenderPass / 4 + tThickness], CS.PX_N[3]);
            }
            case 14: {
                switch (aRenderPass % 4) {
                    default: {
                        return this.box(aBlock, CS.PX_P[1], CS.PX_P[aRenderPass / 4], CS.PX_P[1], CS.PX_N[9], CS.PX_P[aRenderPass / 4 + tThickness], CS.PX_N[9]);
                    }
                    case 1: {
                        return this.box(aBlock, CS.PX_P[1], CS.PX_P[aRenderPass / 4], CS.PX_P[9], CS.PX_N[9], CS.PX_P[aRenderPass / 4 + tThickness], CS.PX_N[1]);
                    }
                    case 2: {
                        return this.box(aBlock, CS.PX_P[9], CS.PX_P[aRenderPass / 4], CS.PX_P[1], CS.PX_N[1], CS.PX_P[aRenderPass / 4 + tThickness], CS.PX_N[9]);
                    }
                    case 3: 
                }
                return this.box(aBlock, CS.PX_P[9], CS.PX_P[aRenderPass / 4], CS.PX_P[9], CS.PX_N[1], CS.PX_P[aRenderPass / 4 + tThickness], CS.PX_N[1]);
            }
            case 252: {
                return this.box(aBlock, CS.PX_P[1], CS.PX_P[aRenderPass / 4], CS.PX_P[1], CS.PX_N[1], CS.PX_P[aRenderPass / 4 + tThickness], CS.PX_N[1]);
            }
            case 253: {
                return this.box(aBlock, CS.PX_P[1] / 2.0f, CS.PX_P[aRenderPass / 4], CS.PX_P[1] / 2.0f, CS.PX_N[1] + CS.PX_P[1] / 2.0f, CS.PX_P[aRenderPass / 4 + tThickness], CS.PX_N[1] + CS.PX_P[1] / 2.0f);
            }
            case 254: {
                return this.box(aBlock, CS.PX_P[1] / 2.0f, CS.PX_P[aRenderPass / 4], CS.PX_P[1] / 2.0f, CS.PX_N[1] + CS.PX_P[1] / 2.0f, CS.PX_P[aRenderPass / 4 + tThickness], CS.PX_N[1] + CS.PX_P[1] / 2.0f);
            }
        }
        return this.box(aBlock, CS.PX_P[1], CS.PX_P[aRenderPass / 4], CS.PX_P[1], CS.PX_N[1], CS.PX_P[aRenderPass / 4 + tThickness], CS.PX_N[1]);
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        this.box(aBlock, CS.PX_P[1], 0.0, CS.PX_P[1], CS.PX_N[1], CS.PX_P[Math.max(1, this.mSize)], CS.PX_N[1]);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return this.box(CS.PX_P[1], 0.0, CS.PX_P[1], CS.PX_N[1], CS.PX_P[Math.max(1, this.mSize)], CS.PX_N[1]);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return this.box(CS.PX_P[1], 0.0, CS.PX_P[1], CS.PX_N[1], CS.PX_P[Math.max(1, this.mSize)], CS.PX_N[1]);
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return false;
    }

    @Override
    public boolean isSurfaceOpaque(byte aSide) {
        return false;
    }

    @Override
    public boolean isSideSolid(byte aSide) {
        return false;
    }

    @Override
    public boolean isObstructingBlockAt(byte aSide) {
        return false;
    }

    @Override
    public boolean onlyPlaceableWhenSneaking() {
        return true;
    }

    @Override
    public byte getMaxStackSize(ItemStack aStack, byte aDefault) {
        return 16;
    }

    @Override
    public boolean checkObstruction(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return false;
    }

    @Override
    public int getLightOpacity() {
        return 0;
    }

    @Override
    public float getExplosionResistance2() {
        return 0.0f;
    }

    @Override
    public float getBlockHardness() {
        return 0.25f;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.sandwich";
    }
}

