/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.energy.reactors;

import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.data.MT;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.ITexture;
import gregapi.util.ST;
import gregapi.util.UT;
import gregtech.tileentity.energy.reactors.MultiTileEntityReactorCore;
import gregtech.tileentity.energy.reactors.MultiTileEntityReactorRodBase;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class MultiTileEntityReactorRodNuclear
extends MultiTileEntityReactorRodBase {
    public long mDurability = 0L;
    public int mNeutronSelf = 128;
    public int mNeutronOther = 128;
    public int mNeutronDiv = 8;
    public int mNeutronMax = 128;
    public short mDepleted = (short)-1;
    public boolean mModerated = false;
    public boolean oModerated = false;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        this.mDurability = aNBT.getLong(aNBT.hasKey("gt.durability") ? "gt.durability" : "gt.maxdurability");
        if (aNBT.hasKey("gt.nuclear.self")) {
            this.mNeutronSelf = aNBT.getInteger("gt.nuclear.self");
        }
        if (aNBT.hasKey("gt.nuclear.other")) {
            this.mNeutronOther = aNBT.getInteger("gt.nuclear.other");
        }
        if (aNBT.hasKey("gt.nuclear.div")) {
            this.mNeutronDiv = aNBT.getInteger("gt.nuclear.div");
        }
        if (aNBT.hasKey("gt.nuclear.max")) {
            this.mNeutronMax = aNBT.getInteger("gt.nuclear.max");
        }
        if (aNBT.hasKey("gt.nuclear.mod")) {
            this.mModerated = aNBT.getBoolean("gt.nuclear.mod");
        }
        if (aNBT.hasKey("gt.nuclear.mod.o")) {
            this.oModerated = aNBT.getBoolean("gt.nuclear.mod.o");
        }
        if (aNBT.hasKey("gt.value")) {
            this.mDepleted = aNBT.getShort("gt.value");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.durability", this.mDurability);
        UT.NBT.setBoolean(aNBT, "gt.nuclear.mod", this.mModerated);
        UT.NBT.setBoolean(aNBT, "gt.nuclear.mod.o", this.oModerated);
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        UT.NBT.setNumber(aNBT, "gt.durability", this.mDurability);
        UT.NBT.setBoolean(aNBT, "gt.nuclear.mod", this.mModerated);
        UT.NBT.setBoolean(aNBT, "gt.nuclear.mod.o", this.oModerated);
        return super.writeItemNBT2(aNBT);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.DGRAY + "Used in Nuclear Reactor Core");
        aList.add(LH.Chat.CYAN + "The " + LH.Chat.GREEN + "Emission" + LH.Chat.CYAN + " describes how many Neutrons are emitted to adjacent Rods");
        aList.add(LH.Chat.CYAN + "The " + LH.Chat.GREEN + "Self" + LH.Chat.CYAN + " describes how many Neutrons naturally onto this Rod");
        aList.add(LH.Chat.CYAN + "The " + LH.Chat.GREEN + "Maximum" + LH.Chat.CYAN + " describes how many Neutrons can be on this Rod while lasting the advertised duration");
        aList.add(LH.Chat.CYAN + "A greater " + LH.Chat.YELLOW + "Factor" + LH.Chat.CYAN + " means the Rod emits more extra Neutrons for the amount of Neutrons on it");
        if (this.mModerated || this.oModerated) {
            aList.add(LH.Chat.DBLUE + "This Fuel is " + LH.Chat.WHITE + "Moderated");
        }
        aList.add(LH.Chat.CYAN + "Remaining: " + LH.Chat.WHITE + this.mDurability / 120000L + LH.Chat.CYAN + " Minutes");
        switch ((int)(CS.CLIENT_TIME / 100L % 10L)) {
            case 0: {
                aList.add(LH.Chat.CYAN + "When used with Distilled or Semiheavy Water:");
                aList.add(LH.Chat.GREEN + "Emission: " + LH.Chat.WHITE + this.mNeutronOther + LH.Chat.PURPLE + " Neutrons/t");
                aList.add(LH.Chat.GREEN + "Self: " + LH.Chat.WHITE + this.mNeutronSelf + LH.Chat.PURPLE + " Neutrons/t");
                aList.add(LH.Chat.GREEN + "Maximum: " + LH.Chat.WHITE + this.mNeutronMax + LH.Chat.PURPLE + " Neutrons/t");
                aList.add(LH.Chat.YELLOW + "Factor: " + LH.Chat.WHITE + "1/" + this.mNeutronDiv);
                aList.add(LH.Chat.GREEN + "Fuel rods will be " + LH.Chat.WHITE + "Moderated");
                if (this.mNeutronDiv > 4) break;
                aList.add(LH.Chat.RED + "This Fuel is" + LH.Chat.BLINKING_RED + " Critical");
                break;
            }
            case 1: {
                aList.add(LH.Chat.CYAN + "When used with Heavy Water:");
                aList.add(LH.Chat.GREEN + "Emission: " + LH.Chat.WHITE + this.mNeutronOther + LH.Chat.PURPLE + " Neutrons/t");
                aList.add(LH.Chat.GREEN + "Self: " + LH.Chat.WHITE + this.mNeutronSelf + LH.Chat.PURPLE + " Neutrons/t");
                aList.add(LH.Chat.GREEN + "Maximum: " + LH.Chat.WHITE + UT.Code.divup(this.mNeutronMax, 8L) + LH.Chat.PURPLE + " Neutrons/t");
                aList.add(LH.Chat.YELLOW + "Factor: " + LH.Chat.WHITE + "1/" + this.mNeutronDiv);
                aList.add(LH.Chat.GREEN + "Fuel rods will be " + LH.Chat.WHITE + "Moderated");
                if (this.mNeutronDiv > 4) break;
                aList.add(LH.Chat.RED + "This Fuel is" + LH.Chat.BLINKING_RED + " Critical");
                break;
            }
            case 2: {
                aList.add(LH.Chat.CYAN + "When used with Tritiated Water:");
                aList.add(LH.Chat.GREEN + "Emission: " + LH.Chat.WHITE + this.mNeutronOther + LH.Chat.PURPLE + " Neutrons/t");
                aList.add(LH.Chat.GREEN + "Self: " + LH.Chat.WHITE + this.mNeutronSelf + LH.Chat.PURPLE + " Neutrons/t");
                aList.add(LH.Chat.GREEN + "Maximum: " + LH.Chat.WHITE + UT.Code.divup(this.mNeutronMax, 16L) + LH.Chat.PURPLE + " Neutrons/t");
                aList.add(LH.Chat.YELLOW + "Factor: " + LH.Chat.WHITE + "1/" + this.mNeutronDiv);
                aList.add(LH.Chat.GREEN + "Fuel rods will be " + LH.Chat.WHITE + "Moderated");
                if (this.mNeutronDiv > 4) break;
                aList.add(LH.Chat.RED + "This Fuel is" + LH.Chat.BLINKING_RED + " Critical");
                break;
            }
            case 3: {
                aList.add(LH.Chat.CYAN + "When used with molten Tin:");
                aList.add(LH.Chat.GREEN + "Emission: " + LH.Chat.WHITE + this.mNeutronOther + LH.Chat.PURPLE + " Neutrons/t");
                aList.add(LH.Chat.GREEN + "Self: " + LH.Chat.WHITE + this.mNeutronSelf + LH.Chat.PURPLE + " Neutrons/t");
                aList.add(LH.Chat.GREEN + "Maximum: " + LH.Chat.WHITE + this.mNeutronMax + LH.Chat.PURPLE + " Neutrons/t");
                aList.add(LH.Chat.YELLOW + "Factor: " + LH.Chat.WHITE + "1/" + (this.mNeutronDiv - 1));
                aList.add(LH.Chat.GREEN + "1/3 the Heat per Neutron");
                if (this.mNeutronDiv > 5) break;
                aList.add(LH.Chat.RED + "This Fuel is" + LH.Chat.BLINKING_RED + " Critical");
                break;
            }
            case 4: {
                aList.add(LH.Chat.CYAN + "When used with molten Sodium:");
                aList.add(LH.Chat.GREEN + "Emission: " + LH.Chat.WHITE + this.mNeutronOther + LH.Chat.PURPLE + " Neutrons/t");
                aList.add(LH.Chat.GREEN + "Self: " + LH.Chat.WHITE + this.mNeutronSelf + LH.Chat.PURPLE + " Neutrons/t");
                aList.add(LH.Chat.GREEN + "Maximum: " + LH.Chat.WHITE + this.mNeutronMax + LH.Chat.PURPLE + " Neutrons/t");
                aList.add(LH.Chat.YELLOW + "Factor: " + LH.Chat.WHITE + "1/" + (this.mNeutronDiv - 1));
                aList.add(LH.Chat.GREEN + "1/6 the Heat per Neutron");
                if (this.mNeutronDiv > 5) break;
                aList.add(LH.Chat.RED + "This Fuel is" + LH.Chat.BLINKING_RED + " Critical");
                break;
            }
            case 5: {
                aList.add(LH.Chat.CYAN + "When used with Industrial Coolant:");
                aList.add(LH.Chat.GREEN + "Emission: " + LH.Chat.WHITE + this.mNeutronOther * 4 + LH.Chat.PURPLE + " Neutrons/t");
                aList.add(LH.Chat.GREEN + "Self: " + LH.Chat.WHITE + this.mNeutronSelf * 4 + LH.Chat.PURPLE + " Neutrons/t");
                aList.add(LH.Chat.GREEN + "Maximum: " + LH.Chat.WHITE + this.mNeutronMax + LH.Chat.PURPLE + " Neutrons/t");
                aList.add(LH.Chat.YELLOW + "Factor: " + LH.Chat.WHITE + "1/" + this.mNeutronDiv * 2);
                if (this.mNeutronDiv > 2) break;
                aList.add(LH.Chat.RED + "This Fuel is" + LH.Chat.BLINKING_RED + " Critical");
                break;
            }
            case 6: {
                aList.add(LH.Chat.CYAN + "When used with Molten Lithium Chloride:");
                aList.add(LH.Chat.GREEN + "Emission: " + LH.Chat.WHITE + ((long)this.mNeutronOther - UT.Code.divup(this.mNeutronOther, 2L)) + LH.Chat.PURPLE + " Neutrons/t");
                aList.add(LH.Chat.GREEN + "Self: " + LH.Chat.WHITE + this.mNeutronSelf * 5 + LH.Chat.PURPLE + " Neutrons/t");
                aList.add(LH.Chat.GREEN + "Maximum: " + LH.Chat.WHITE + ((long)this.mNeutronMax + UT.Code.divup(this.mNeutronMax, 4L)) + LH.Chat.PURPLE + " Neutrons/t");
                aList.add(LH.Chat.YELLOW + "Factor: " + LH.Chat.WHITE + "1/" + this.mNeutronDiv);
                if (this.mNeutronDiv > 4) break;
                aList.add(LH.Chat.RED + "This Fuel is" + LH.Chat.BLINKING_RED + " Critical");
                break;
            }
            case 7: {
                aList.add(LH.Chat.CYAN + "When used with Molten Thorium Salt:");
                aList.add(LH.Chat.GREEN + "Emission: " + LH.Chat.WHITE + ((long)this.mNeutronOther - UT.Code.divup(this.mNeutronOther, 2L)) + LH.Chat.PURPLE + " Neutrons/t");
                aList.add(LH.Chat.GREEN + "Self: " + LH.Chat.WHITE + this.mNeutronSelf * 0 + LH.Chat.PURPLE + " Neutrons/t");
                aList.add(LH.Chat.GREEN + "Maximum: " + LH.Chat.WHITE + this.mNeutronMax * 4 + LH.Chat.PURPLE + " Neutrons/t");
                aList.add(LH.Chat.YELLOW + "Factor: " + LH.Chat.WHITE + "1/" + (this.mNeutronDiv - 1));
                if (this.mNeutronDiv > 5) break;
                aList.add(LH.Chat.RED + "This Fuel is" + LH.Chat.BLINKING_RED + " Critical");
                break;
            }
            case 8: {
                aList.add(LH.Chat.CYAN + "When used with Carbon Dioxide:");
                aList.add(LH.Chat.GREEN + "Emission: " + LH.Chat.WHITE + this.mNeutronOther + LH.Chat.PURPLE + " Neutrons/t");
                aList.add(LH.Chat.GREEN + "Self: " + LH.Chat.WHITE + this.mNeutronSelf * 3 + LH.Chat.PURPLE + " Neutrons/t");
                aList.add(LH.Chat.GREEN + "Maximum: " + LH.Chat.WHITE + this.mNeutronMax + LH.Chat.PURPLE + " Neutrons/t");
                aList.add(LH.Chat.YELLOW + "Factor: " + LH.Chat.WHITE + "1/" + this.mNeutronDiv);
                if (this.mNeutronDiv > 4) break;
                aList.add(LH.Chat.RED + "This Fuel is" + LH.Chat.BLINKING_RED + " Critical");
                break;
            }
            case 9: {
                aList.add(LH.Chat.CYAN + "When used with Helium:");
                aList.add(LH.Chat.GREEN + "Emission: " + LH.Chat.WHITE + ((long)this.mNeutronOther - UT.Code.divup(this.mNeutronOther, 2L)) + LH.Chat.PURPLE + " Neutrons/t");
                aList.add(LH.Chat.GREEN + "Self: " + LH.Chat.WHITE + this.mNeutronSelf + LH.Chat.PURPLE + " Neutrons/t");
                aList.add(LH.Chat.GREEN + "Maximum: " + LH.Chat.WHITE + this.mNeutronMax + LH.Chat.PURPLE + " Neutrons/t");
                aList.add(LH.Chat.YELLOW + "Factor: " + LH.Chat.WHITE + "1/" + this.mNeutronDiv);
                if (this.mNeutronDiv > 4) break;
                aList.add(LH.Chat.RED + "This Fuel is" + LH.Chat.BLINKING_RED + " Critical");
            }
        }
    }

    @Override
    public int getReactorRodNeutronEmission(MultiTileEntityReactorCore aReactor, int aSlot, ItemStack aStack) {
        int tNeutronOther = this.mNeutronOther;
        int tNeutronSelf = this.mNeutronSelf;
        int tNeutronDiv = this.mNeutronDiv;
        if (FL.Coolant_IC2.is(aReactor.mTanks[0])) {
            tNeutronOther *= 4;
            tNeutronSelf *= 4;
            tNeutronDiv *= 2;
        } else if (MT.CO2.mGas.isFluidEqual(aReactor.mTanks[0].getFluid())) {
            tNeutronSelf *= 3;
        } else if (MT.He.mGas.isFluidEqual(aReactor.mTanks[0].getFluid())) {
            tNeutronOther = (int)((long)tNeutronOther - UT.Code.divup(this.mNeutronOther, 2L));
        } else if (MT.LiCl.mLiquid.isFluidEqual(aReactor.mTanks[0].getFluid())) {
            tNeutronOther = (int)((long)tNeutronOther - UT.Code.divup(this.mNeutronOther, 2L));
            tNeutronSelf *= 5;
        } else if (FL.Thorium_Salt.is(aReactor.mTanks[0])) {
            tNeutronOther = (int)((long)tNeutronOther - UT.Code.divup(this.mNeutronOther, 2L));
            tNeutronSelf = 0;
            --tNeutronDiv;
        } else if (MT.Sn.mLiquid.isFluidEqual(aReactor.mTanks[0].getFluid()) || MT.Na.mLiquid.isFluidEqual(aReactor.mTanks[0].getFluid())) {
            --tNeutronDiv;
        }
        int n = aSlot;
        aReactor.mNeutronCounts[n] = aReactor.mNeutronCounts[n] + tNeutronSelf;
        long tEmission = (long)tNeutronOther + UT.Code.divup(Math.max(aReactor.oNeutronCounts[aSlot] - tNeutronSelf, 0), tNeutronDiv);
        return UT.Code.bindInt(tEmission);
    }

    @Override
    public boolean getReactorRodNeutronReaction(MultiTileEntityReactorCore aReactor, int aSlot, ItemStack aStack) {
        long tDurabilityLoss;
        aReactor.mEnergy += (long)aReactor.oNeutronCounts[aSlot];
        int tNeutronMax = this.getReactorRodNeutronMaximum(aReactor, aSlot, aStack);
        if (FL.distw(aReactor.mTanks[0]) || MT.HDO.mLiquid.isFluidEqual(aReactor.mTanks[0].getFluid()) || MT.D2O.mLiquid.isFluidEqual(aReactor.mTanks[0].getFluid()) || MT.T2O.mLiquid.isFluidEqual(aReactor.mTanks[0].getFluid())) {
            this.oModerated = true;
            this.mModerated = true;
        }
        long l = tDurabilityLoss = aReactor.oNeutronCounts[aSlot] <= tNeutronMax ? 100L : UT.Code.divup(400 * aReactor.oNeutronCounts[aSlot], tNeutronMax);
        if (this.oModerated) {
            tDurabilityLoss *= 4L;
        }
        this.mDurability = tDurabilityLoss > this.mDurability ? -1L : this.mDurability - tDurabilityLoss;
        UT.NBT.set(aStack, this.writeItemNBT(aStack.hasTagCompound() ? aStack.getTagCompound() : UT.NBT.make()));
        if (this.mDurability <= 0L) {
            ST.meta(aStack, this.mDepleted);
            ST.nbt(aStack, null);
            aReactor.updateClientData();
        }
        return true;
    }

    @Override
    public int getReactorRodNeutronReflection(MultiTileEntityReactorCore aReactor, int aSlot, ItemStack aStack, int aNeutrons, boolean aModerated) {
        if (aModerated) {
            this.mModerated = true;
            UT.NBT.set(aStack, this.writeItemNBT(aStack.hasTagCompound() ? aStack.getTagCompound() : UT.NBT.make()));
        }
        int n = aSlot;
        aReactor.mNeutronCounts[n] = aReactor.mNeutronCounts[n] + aNeutrons;
        return 0;
    }

    @Override
    public int getReactorRodNeutronMaximum(MultiTileEntityReactorCore aReactor, int aSlot, ItemStack aStack) {
        if (MT.LiCl.mLiquid.isFluidEqual(aReactor.mTanks[0].getFluid())) {
            return this.mNeutronMax + (int)UT.Code.divup(this.mNeutronMax, 4L);
        }
        if (FL.Thorium_Salt.is(aReactor.mTanks[0])) {
            return this.mNeutronMax * 4;
        }
        if (MT.D2O.mLiquid.isFluidEqual(aReactor.mTanks[0].getFluid())) {
            return (int)UT.Code.divup(this.mNeutronMax, 8L);
        }
        if (MT.T2O.mLiquid.isFluidEqual(aReactor.mTanks[0].getFluid())) {
            return (int)UT.Code.divup(this.mNeutronMax, 16L);
        }
        return this.mNeutronMax;
    }

    @Override
    public boolean isModerated(MultiTileEntityReactorCore aReactor, int aSlot, ItemStack aStack) {
        return this.oModerated;
    }

    @Override
    public void updateModeration(MultiTileEntityReactorCore aReactor, int aSlot, ItemStack aStack) {
        this.oModerated = this.mModerated;
        this.mModerated = false;
        UT.NBT.set(aStack, this.writeItemNBT(aStack.hasTagCompound() ? aStack.getTagCompound() : UT.NBT.make()));
    }

    @Override
    public ITexture getReactorRodTextureSides(MultiTileEntityReactorCore aReactor, int aSlot, ItemStack aStack, boolean aActive) {
        return BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[1], this.mRGBa, true), BlockTextureDefault.get(sOverlays[1], aActive ? CS.UNCOLOURED : MT.Pb.fRGBaSolid));
    }

    @Override
    public ITexture getReactorRodTextureTop(MultiTileEntityReactorCore aReactor, int aSlot, ItemStack aStack, boolean aActive) {
        return BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[0], this.mRGBa, true), BlockTextureDefault.get(sOverlays[0], aActive ? CS.UNCOLOURED : MT.Pb.fRGBaSolid));
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.generator.reactor.rods.nuclear";
    }
}

