/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.energy.reactors;

import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.util.UT;
import gregtech.tileentity.energy.reactors.MultiTileEntityReactorCore;
import gregtech.tileentity.energy.reactors.MultiTileEntityReactorRodBase;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class MultiTileEntityReactorRodModerator
extends MultiTileEntityReactorRodBase {
    short mModeration = 0;
    short oModeration = 0;

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.DGRAY + "Used in Nuclear Reactor Core");
        aList.add(LH.Chat.CYAN + "Reflects neutrons back times the number of fuel rods touching when active");
        aList.add(LH.Chat.CYAN + "Touching Fuel Rods become moderated and moderate touching Fuel Rods");
        aList.add(LH.Chat.CYAN + "Moderated Fuel Rods can't be used for Breeding and only last a quarter as long");
    }

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.hasKey("gt.nuclear.mod")) {
            this.mModeration = aNBT.getShort("gt.nuclear.mod");
        }
        if (aNBT.hasKey("gt.nuclear.mod.o")) {
            this.oModeration = aNBT.getShort("gt.nuclear.mod.o");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.nuclear.mod", this.mModeration);
        UT.NBT.setNumber(aNBT, "gt.nuclear.mod.o", this.oModeration);
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        UT.NBT.setNumber(aNBT, "gt.nuclear.mod", this.mModeration);
        UT.NBT.setNumber(aNBT, "gt.nuclear.mod.o", this.oModeration);
        return super.writeItemNBT2(aNBT);
    }

    @Override
    public int getReactorRodNeutronEmission(MultiTileEntityReactorCore aReactor, int aSlot, ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean getReactorRodNeutronReaction(MultiTileEntityReactorCore aReactor, int aSlot, ItemStack aStack) {
        if (CS.SERVER_TIME % 20L == 19L) {
            this.oModeration = this.mModeration;
            this.mModeration = 0;
            UT.NBT.set(aStack, this.writeItemNBT(aStack.hasTagCompound() ? aStack.getTagCompound() : UT.NBT.make()));
        }
        return false;
    }

    @Override
    public int getReactorRodNeutronReflection(MultiTileEntityReactorCore aReactor, int aSlot, ItemStack aStack, int aNeutrons, boolean aModerated) {
        if (aNeutrons > 0) {
            this.mModeration = (short)(this.mModeration + 1);
            UT.NBT.set(aStack, this.writeItemNBT(aStack.hasTagCompound() ? aStack.getTagCompound() : UT.NBT.make()));
        }
        return this.oModeration * aNeutrons;
    }

    @Override
    public boolean isModerated(MultiTileEntityReactorCore aReactor, int aSlot, ItemStack aStack) {
        return true;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.generator.reactor.rods.moderator";
    }
}

