/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.energy.reactors;

import gregapi.data.LH;
import gregapi.util.ST;
import gregapi.util.UT;
import gregtech.tileentity.energy.reactors.MultiTileEntityReactorCore;
import gregtech.tileentity.energy.reactors.MultiTileEntityReactorRodBase;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class MultiTileEntityReactorRodBreeder
extends MultiTileEntityReactorRodBase {
    public long mDurability = 0L;
    public short mProduct = (short)-1;
    public int mNeutronLoss = 0;
    public String mProductName = "";

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        this.mDurability = aNBT.getLong(aNBT.hasKey("gt.durability") ? "gt.durability" : "gt.maxdurability");
        if (aNBT.hasKey("gt.nuclear.loss")) {
            this.mNeutronLoss = aNBT.getInteger("gt.nuclear.loss");
        }
        if (aNBT.hasKey("gt.value")) {
            this.mProduct = aNBT.getShort("gt.value");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.durability", this.mDurability);
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        UT.NBT.setNumber(aNBT, "gt.durability", this.mDurability);
        return super.writeItemNBT2(aNBT);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.DGRAY + "Used in Nuclear Reactor Core");
        aList.add(LH.Chat.CYAN + "Absorbs Neutrons to breed into an " + LH.Chat.WHITE + "Enriched Rod");
        aList.add(LH.Chat.CYAN + "Emits half the Heat per Neutron on this Rod");
        aList.add(LH.Chat.CYAN + "Can't breed with Neutrons from " + LH.Chat.RED + "Moderated" + LH.Chat.CYAN + " Fuel Rods");
        aList.add(LH.Chat.CYAN + "The " + LH.Chat.YELLOW + "Loss" + LH.Chat.CYAN + " value gets subtracted from Neutrons entering this Rod");
        aList.add(LH.Chat.CYAN + "This applies to each side where Neutrons enter, not to the total of all sides");
        aList.add(LH.Chat.CYAN + "Remaining Neutrons on this Rod get added to the breeding process");
        if (this.mProductName.equals("")) {
            this.mProductName = ST.meta(aStack.copy(), this.mProduct).getDisplayName();
        }
        aList.add(LH.Chat.GREEN + "Turns into: " + LH.Chat.WHITE + this.mProductName);
        aList.add(LH.Chat.CYAN + "Needed: " + LH.Chat.WHITE + this.mDurability + LH.Chat.PURPLE + " Neutrons");
        aList.add(LH.Chat.YELLOW + "Loss: " + LH.Chat.WHITE + this.mNeutronLoss + LH.Chat.PURPLE + " Neutrons");
    }

    @Override
    public int getReactorRodNeutronEmission(MultiTileEntityReactorCore aReactor, int aSlot, ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean getReactorRodNeutronReaction(MultiTileEntityReactorCore aReactor, int aSlot, ItemStack aStack) {
        aReactor.mEnergy += (long)(aReactor.oNeutronCounts[aSlot] / 2);
        this.mDurability -= (long)aReactor.oNeutronCounts[aSlot];
        if (this.mDurability <= 0L) {
            ST.meta(aStack, this.mProduct);
            ST.nbt(aStack, null);
            this.mDurability = 0L;
            aReactor.updateClientData();
        }
        UT.NBT.set(aStack, this.writeItemNBT(aStack.hasTagCompound() ? aStack.getTagCompound() : UT.NBT.make()));
        return true;
    }

    @Override
    public int getReactorRodNeutronReflection(MultiTileEntityReactorCore aReactor, int aSlot, ItemStack aStack, int aNeutrons, boolean aModerated) {
        if (!aModerated && aNeutrons > this.mNeutronLoss) {
            int n = aSlot;
            aReactor.mNeutronCounts[n] = aReactor.mNeutronCounts[n] + (aNeutrons - this.mNeutronLoss);
        }
        return 0;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.generator.reactor.rods.breeder";
    }
}

