/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.energy.converters;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.code.TagData;
import gregapi.data.BI;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.fluid.FluidTankGT;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityFunnelAccessible;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.data.ITileEntityGibbl;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.energy.ITileEntityEnergyDataCapacitor;
import gregapi.util.UT;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class MultiTileEntityBoilerTank
extends TileEntityBase09FacingSingle
implements ITileEntityEnergy,
ITileEntityFunnelAccessible,
ITileEntityGibbl,
ITileEntityEnergyDataCapacitor,
IFluidHandler,
IMultiTileEntity.IMTE_RemovedByPlayer,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_OnEntityCollidedWithBlock {
    protected byte mBarometer = 0;
    protected byte oBarometer = 0;
    protected short mEfficiency = (short)10000;
    protected short mCoolDownResetTimer = (short)128;
    protected long mEnergy = 0L;
    protected long mCapacity = 640000L;
    protected long mOutput = 64L;
    protected TagData mEnergyTypeAccepted = TD.Energy.HU;
    protected FluidTankGT[] mTanks = new FluidTankGT[]{new FluidTankGT(4000L), new FluidTankGT(64000L)};
    public static IIconContainer[] sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/tanks/boiler_steam/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/tanks/boiler_steam/colored/top"), new Textures.BlockIcons.CustomIcon("machines/tanks/boiler_steam/colored/side")};
    public static IIconContainer[] sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/tanks/boiler_steam/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/tanks/boiler_steam/overlay/top"), new Textures.BlockIcons.CustomIcon("machines/tanks/boiler_steam/overlay/side")};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        this.mEnergy = aNBT.getLong("gt.energy");
        if (aNBT.hasKey("gt.visual")) {
            this.mBarometer = aNBT.getByte("gt.visual");
        }
        if (aNBT.hasKey("gt.output.su")) {
            this.mOutput = aNBT.getLong("gt.output.su");
        }
        this.mCapacity = this.mOutput * 10000L;
        this.mTanks[1].setCapacity(this.mCapacity);
        if (aNBT.hasKey("gt.capacity")) {
            this.mCapacity = aNBT.getLong("gt.capacity");
        }
        if (aNBT.hasKey("gt.capacity.su")) {
            this.mTanks[1].setCapacity(aNBT.getLong("gt.capacity.su"));
        }
        if (aNBT.hasKey("gt.eff")) {
            this.mEfficiency = (short)UT.Code.bind_(0L, 10000L, aNBT.getShort("gt.eff"));
        }
        if (aNBT.hasKey("gt.energy.accepted")) {
            this.mEnergyTypeAccepted = TagData.createTagData(aNBT.getString("gt.energy.accepted"));
        }
        for (int i = 0; i < this.mTanks.length; ++i) {
            this.mTanks[i].readFromNBT(aNBT, "gt.tank." + i);
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.energy", this.mEnergy);
        if (this.mEfficiency != 10000) {
            aNBT.setShort("gt.eff", this.mEfficiency);
        }
        for (int i = 0; i < this.mTanks.length; ++i) {
            this.mTanks[i].writeToNBT(aNBT, "gt.tank." + i);
        }
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.energy.convert.from") + " 1 L " + FL.name(FluidRegistry.WATER, true) + " " + LH.get("gt.lang.energy.convert.to") + " 160 L " + FL.name(FL.Steam.make(0L), true) + " " + LH.get("gt.lang.energy.convert.using") + " 80 " + this.mEnergyTypeAccepted.getLocalisedNameShort());
        aList.add(LH.getToolTipEfficiency(this.mEfficiency));
        aList.add(LH.Chat.GREEN + LH.get("gt.lang.energy.input") + ": " + LH.Chat.WHITE + this.mOutput / (long)CS.STEAM_PER_EU + " " + this.mEnergyTypeAccepted.getLocalisedChatNameShort() + LH.Chat.WHITE + "/t (" + LH.get("gt.lang.face.any") + ")");
        aList.add(LH.Chat.GREEN + LH.get("gt.lang.energy.capacity") + ": " + LH.Chat.WHITE + this.mCapacity + " " + this.mEnergyTypeAccepted.getLocalisedChatNameShort() + LH.Chat.WHITE);
        aList.add(LH.Chat.RED + LH.get("gt.lang.energy.output") + ": " + LH.Chat.WHITE + UT.Code.units(this.mOutput, 10000L, this.mEfficiency, false) + " " + TD.Energy.STEAM.getLocalisedChatNameLong() + LH.Chat.WHITE + "/t (" + LH.get("gt.lang.face.top") + ")");
        aList.add(LH.Chat.RED + LH.get("gt.lang.energy.capacity") + ": " + LH.Chat.WHITE + this.mCapacity + " " + TD.Energy.STEAM.getLocalisedChatNameLong() + LH.Chat.WHITE);
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.requirement.water.pure"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.funnel.tank"));
        aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.explosion.steam"));
        aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.meltdown"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.chisel.to.decalcify"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.magnifyingglass.to.detail"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            long tAmount;
            long tConversions = Math.min(this.mTanks[1].capacity() / 2560L, Math.min(this.mEnergy / 80L, this.mTanks[0].amount()));
            if (tConversions > 0L) {
                this.mTanks[0].remove(tConversions);
                if (this.rng(10) == 0 && this.mEfficiency > 5000 && this.mTanks[0].has() && !FL.distw(this.mTanks[0])) {
                    this.mEfficiency = (short)((long)this.mEfficiency - tConversions);
                    if (this.mEfficiency < 5000) {
                        this.mEfficiency = (short)5000;
                    }
                }
                this.mTanks[1].setFluid(FL.Steam.make(this.mTanks[1].amount() + UT.Code.units(tConversions, 10000L, this.mEfficiency * 160, false)));
                this.mEnergy -= tConversions * 80L;
                this.mCoolDownResetTimer = (short)128;
            }
            short s = this.mCoolDownResetTimer;
            this.mCoolDownResetTimer = (short)(s - 1);
            if (s <= 0) {
                this.mCoolDownResetTimer = 0;
                this.mEnergy -= this.mOutput * 64L / (long)CS.STEAM_PER_EU;
                CS.GarbageGT.trash(this.mTanks[1], this.mOutput * 64L);
                if (this.mEnergy <= 0L) {
                    this.mEnergy = 0L;
                    this.mCoolDownResetTimer = (short)128;
                }
            }
            if ((tAmount = this.mTanks[1].amount() - this.mTanks[1].capacity() / 2L) > 0L) {
                FL.move(this.mTanks[1], this.getAdjacentTank((byte)1), Math.min(tAmount > this.mTanks[1].capacity() / 4L ? this.mOutput * 2L : this.mOutput, tAmount));
            }
            this.mBarometer = (byte)UT.Code.scale(this.mTanks[1].amount(), this.mTanks[1].capacity(), 31L, false);
            if (this.mEnergy > this.mCapacity || this.mTanks[1].isFull()) {
                this.explode(false);
            }
        }
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L) {
            return rReturn;
        }
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("plunger")) {
            if (this.mTanks[0].has()) {
                return CS.GarbageGT.trash(this.mTanks[0]);
            }
            return CS.GarbageGT.trash(this.mTanks[1]);
        }
        if (aTool.equals("chisel")) {
            int rResult = 10000 - this.mEfficiency;
            if (rResult > 0) {
                if (this.mBarometer > 15) {
                    this.explode(false);
                } else {
                    if (this.mEnergy + this.mTanks[1].amount() / (long)CS.STEAM_PER_EU > 2000L) {
                        UT.Entities.applyHeatDamage(aPlayer, (float)(this.mEnergy + this.mTanks[1].amount() / 2L) / 2000.0f);
                    }
                    this.mTanks[1].setEmpty();
                    this.mEfficiency = (short)10000;
                    this.mEnergy = 0L;
                    return rResult;
                }
            }
            return 0L;
        }
        if (aTool.equals("thermometer")) {
            if (aChatReturn != null) {
                aChatReturn.add("Stored Heat Units: " + this.mEnergy + " / " + this.mCapacity + " HU");
            }
            return 10000L;
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                if (this.mEfficiency < 10000) {
                    aChatReturn.add("Calcification: " + LH.percent(10000 - this.mEfficiency) + "%");
                } else {
                    aChatReturn.add("No Calcification in this Boiler");
                }
                aChatReturn.add(this.mTanks[0].content("WARNING: NO WATER!!!"));
            }
            return 1L;
        }
        return 0L;
    }

    @Override
    public boolean removedByPlayer(World aWorld, EntityPlayer aPlayer, boolean aWillHarvest) {
        if (this.mBarometer > 4 && this.isServerSide() && !UT.Entities.isCreative(aPlayer)) {
            this.explode(true);
        }
        return this.worldObj.setBlockToAir(this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void onExploded(Explosion aExplosion) {
        super.onExploded(aExplosion);
        if (this.isServerSide() && this.mBarometer > 4) {
            this.explode(true);
        }
    }

    @Override
    public void explode(boolean aInstant) {
        this.explode(aInstant, Math.max(1.0, Math.sqrt(this.mTanks[1].amount()) / 100.0));
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        this.mBarometer = UT.Code.bind5(this.mBarometer);
        return this.mBarometer != this.oBarometer || super.onTickCheck(aTimer);
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oBarometer = this.mBarometer;
    }

    @Override
    public void setVisualData(byte aData) {
        this.mBarometer = (byte)(aData & 0x1F);
    }

    @Override
    public int funnelFill(byte aSide, FluidStack aFluid, boolean aDoFill) {
        return FL.water(aFluid) ? this.mTanks[0].fill(aFluid, aDoFill) : 0;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aShouldSideBeRendered[aSide] ? BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[CS.FACES_TBS[aSide]], this.mRGBa), BlockTextureDefault.get(sOverlays[CS.FACES_TBS[aSide]]), aSide != this.mFacing ? null : BlockTextureDefault.get(BI.BAROMETER), aSide != this.mFacing ? null : BlockTextureDefault.get(BI.BAROMETER_SCALE[this.mBarometer], CS.CA_RED_64)) : null;
    }

    @Override
    public void onEntityCollidedWithBlock(Entity aEntity) {
        if (this.mEnergy + this.mTanks[1].amount() / (long)CS.STEAM_PER_EU > 2000L) {
            UT.Entities.applyHeatDamage(aEntity, Math.min(10.0f, (float)(this.mEnergy + this.mTanks[1].amount() / 2L) / 2000.0f));
        }
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return this.box(CS.PX_P[2], CS.PX_P[2], CS.PX_P[2], CS.PX_N[2], CS.PX_N[2], CS.PX_N[2]);
    }

    @Override
    public byte getVisualData() {
        return this.mBarometer;
    }

    @Override
    public byte getDefaultSide() {
        return 3;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_HORIZONTAL;
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return !aEmitting && aEnergyType == this.mEnergyTypeAccepted;
    }

    @Override
    public boolean isEnergyAcceptingFrom(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return this.isEnergyType(aEnergyType, aSide, false);
    }

    @Override
    public boolean isEnergyCapacitorType(TagData aEnergyType, byte aSide) {
        return aEnergyType == this.mEnergyTypeAccepted;
    }

    @Override
    public long doInject(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoInject) {
        if (aDoInject) {
            this.mEnergy += Math.abs(aAmount * aSize);
            this.mCoolDownResetTimer = (short)Math.max(this.mCoolDownResetTimer, 32);
        }
        return aAmount;
    }

    @Override
    public long getEnergyDemanded(TagData aEnergyType, byte aSide, long aSize) {
        return this.mOutput / 2L;
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, byte aSide) {
        return this.mOutput / 2L;
    }

    @Override
    public long getEnergySizeInputMin(TagData aEnergyType, byte aSide) {
        return 1L;
    }

    @Override
    public long getEnergySizeInputMax(TagData aEnergyType, byte aSide) {
        return Long.MAX_VALUE;
    }

    @Override
    public long getEnergyStored(TagData aEnergyType, byte aSide) {
        return aEnergyType == this.mEnergyTypeAccepted ? this.mEnergy : 0L;
    }

    @Override
    public long getEnergyCapacity(TagData aEnergyType, byte aSide) {
        return aEnergyType == this.mEnergyTypeAccepted ? this.mCapacity : 0L;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return this.mEnergyTypeAccepted.AS_LIST;
    }

    @Override
    public Collection<TagData> getEnergyCapacitorTypes(byte aSide) {
        return this.mEnergyTypeAccepted.AS_LIST;
    }

    @Override
    protected IFluidTank getFluidTankFillable2(byte aSide, FluidStack aFluidToFill) {
        return CS.SIDES_BOTTOM_HORIZONTAL[aSide] && FL.water(aFluidToFill) ? this.mTanks[0] : null;
    }

    @Override
    protected IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        return null;
    }

    @Override
    protected IFluidTank[] getFluidTanks2(byte aSide) {
        return this.mTanks;
    }

    @Override
    public long getGibblValue(byte aSide) {
        return this.mTanks[1].amount();
    }

    @Override
    public long getGibblMax(byte aSide) {
        return this.mTanks[1].capacity();
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.tank.boiler_steam";
    }
}

