/*
 * Decompiled with CFR 0.152.
 */
package gregtech.render;

import gregapi.data.CS;
import java.util.Collection;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderPlayerEvent;
import org.lwjgl.opengl.GL11;

public class PlayerModelRenderer
extends RenderPlayer {
    private final ResourceLocation[] mResources = new ResourceLocation[]{new ResourceLocation(CS.RES_PATH_MODEL + "BrainTech.png"), new ResourceLocation(CS.RES_PATH_MODEL + "Silver.png"), new ResourceLocation(CS.RES_PATH_MODEL + "MrBrain.png"), new ResourceLocation(CS.RES_PATH_MODEL + "Dev.png"), new ResourceLocation(CS.RES_PATH_MODEL + "Gold.png"), new ResourceLocation(CS.RES_PATH_MODEL + "Crazy.png"), new ResourceLocation(CS.RES_PATH_MODEL + "Sus.png")};
    private final Collection<String> mSupporterListSilver;
    private final Collection<String> mSupporterListGold;

    public PlayerModelRenderer(Collection<String> aSupporterListSilver, Collection<String> aSupporterListGold) {
        this.mSupporterListSilver = aSupporterListSilver;
        this.mSupporterListGold = aSupporterListGold;
        this.setRenderManager(RenderManager.instance);
    }

    private ResourceLocation getResource(String aPlayer) {
        if ((aPlayer = aPlayer.toLowerCase()).startsWith("gregori")) {
            return this.mResources[6];
        }
        if (aPlayer.equalsIgnoreCase("GregoriusT")) {
            return this.mResources[6];
        }
        if (aPlayer.equalsIgnoreCase("OvermindDL1")) {
            return this.mResources[3];
        }
        if (aPlayer.equalsIgnoreCase("jihuayu123")) {
            return this.mResources[3];
        }
        if (aPlayer.equalsIgnoreCase("Yuesha_Kev14")) {
            return this.mResources[3];
        }
        if (aPlayer.equalsIgnoreCase("Evanvenir")) {
            return this.mResources[3];
        }
        if (aPlayer.equalsIgnoreCase("CrazyJ1984")) {
            return this.mResources[5];
        }
        if (aPlayer.equalsIgnoreCase("Mr_Brain")) {
            return this.mResources[2];
        }
        if (aPlayer.equalsIgnoreCase("Friedi4321")) {
            return this.mResources[0];
        }
        if (this.mSupporterListGold.contains(aPlayer)) {
            return this.mResources[4];
        }
        if (this.mSupporterListSilver.contains(aPlayer)) {
            return this.mResources[1];
        }
        return null;
    }

    public void receiveRenderSpecialsEvent(RenderPlayerEvent.Specials.Pre aEvent) {
        AbstractClientPlayer aPlayer = (AbstractClientPlayer)aEvent.entityPlayer;
        float aPartialTicks = aEvent.partialRenderTick;
        if (aPlayer.isInvisible() || aPlayer.getActivePotionEffect(Potion.invisibility) != null) {
            return;
        }
        try {
            ResourceLocation tResource = this.getResource(aPlayer.getCommandSenderName());
            if (tResource == null) {
                tResource = this.getResource(aPlayer.getUniqueID().toString());
            }
            if (tResource != null && !aPlayer.getHideCape()) {
                this.bindTexture(tResource);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.125f);
                double d0 = aPlayer.field_71091_bM + (aPlayer.field_71094_bP - aPlayer.field_71091_bM) * (double)aPartialTicks - (aPlayer.prevPosX + (aPlayer.posX - aPlayer.prevPosX) * (double)aPartialTicks);
                double d1 = aPlayer.field_71096_bN + (aPlayer.field_71095_bQ - aPlayer.field_71096_bN) * (double)aPartialTicks - (aPlayer.prevPosY + (aPlayer.posY - aPlayer.prevPosY) * (double)aPartialTicks);
                double d2 = aPlayer.field_71097_bO + (aPlayer.field_71085_bR - aPlayer.field_71097_bO) * (double)aPartialTicks - (aPlayer.prevPosZ + (aPlayer.posZ - aPlayer.prevPosZ) * (double)aPartialTicks);
                float f6 = aPlayer.prevRenderYawOffset + (aPlayer.renderYawOffset - aPlayer.prevRenderYawOffset) * aPartialTicks;
                double d3 = MathHelper.sin((float)(f6 * (float)Math.PI / 180.0f));
                double d4 = -MathHelper.cos((float)(f6 * (float)Math.PI / 180.0f));
                float f7 = (float)d1 * 10.0f;
                float f8 = (float)(d0 * d3 + d2 * d4) * 100.0f;
                float f9 = (float)(d0 * d4 - d2 * d3) * 100.0f;
                if (f7 < -6.0f) {
                    f7 = -6.0f;
                }
                if (f7 > 32.0f) {
                    f7 = 32.0f;
                }
                if (f8 < 0.0f) {
                    f8 = 0.0f;
                }
                float f10 = aPlayer.prevCameraYaw + (aPlayer.cameraYaw - aPlayer.prevCameraYaw) * aPartialTicks;
                f7 += MathHelper.sin((float)((aPlayer.prevDistanceWalkedModified + (aPlayer.distanceWalkedModified - aPlayer.prevDistanceWalkedModified) * aPartialTicks) * 6.0f)) * 32.0f * f10;
                if (aPlayer.isSneaking()) {
                    f7 += 25.0f;
                }
                GL11.glRotatef((float)(6.0f + f8 / 2.0f + f7), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)(f9 / 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)(-f9 / 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                ((ModelBiped)this.mainModel).renderCloak(0.0625f);
                GL11.glPopMatrix();
            }
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
    }
}

