/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.tools.early;

import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.data.RM;
import gregapi.item.multiitem.MultiItemTool;
import gregapi.item.multiitem.behaviors.Behavior_Tool;
import gregapi.item.multiitem.tools.ToolStats;
import gregapi.oredict.OreDictMaterial;
import gregapi.recipes.Recipe;
import gregapi.render.IIconContainer;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;

public class GT_Tool_HardHammer
extends ToolStats {
    public static final List<String> mEffectiveList = new ArrayListNoNulls<String>(false, "EntityTowerGuardian".toLowerCase(), "EntityStoneSoldier".toLowerCase(), "EntityStone".toLowerCase(), "EntityGeonach".toLowerCase());
    public static GT_Tool_HardHammer INSTANCE;

    public GT_Tool_HardHammer() {
        if (INSTANCE == null && this.getClass() == GT_Tool_HardHammer.class) {
            INSTANCE = this;
        }
    }

    @Override
    public float getNormalDamageAgainstEntity(float aOriginalDamage, Entity aEntity, ItemStack aStack, EntityPlayer aPlayer) {
        String tName = UT.Reflection.getLowercaseClass(aEntity);
        return aEntity instanceof EntityIronGolem || mEffectiveList.contains(tName) || tName.contains("golem") ? aOriginalDamage * 2.0f : aOriginalDamage;
    }

    @Override
    public int getToolDamagePerBlockBreak() {
        return 25;
    }

    @Override
    public int getToolDamagePerDropConversion() {
        return 50;
    }

    @Override
    public int getToolDamagePerContainerCraft() {
        return 400;
    }

    @Override
    public int getToolDamagePerEntityAttack() {
        return 200;
    }

    @Override
    public int getHurtResistanceTime(int aOriginalHurtResistance, Entity aEntity) {
        return aOriginalHurtResistance * 2;
    }

    @Override
    public float getBaseDamage() {
        return 5.0f;
    }

    @Override
    public float getSpeedMultiplier() {
        return 0.75f;
    }

    @Override
    public float getExhaustionPerAttack(Entity aEntity) {
        return 0.6f;
    }

    @Override
    public String getCraftingSound() {
        return "random.anvil_land";
    }

    @Override
    public String getBreakingSound() {
        return "random.anvil_break";
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    @Override
    public boolean isWeapon() {
        return true;
    }

    @Override
    public boolean isMiningTool() {
        return true;
    }

    @Override
    public boolean isMinableBlock(Block aBlock, byte aMetaData) {
        String tTool = aBlock.getHarvestTool((int)aMetaData);
        return tTool != null && (tTool.equalsIgnoreCase("hammer") || tTool.equalsIgnoreCase("pickaxe")) || aBlock instanceof BlockSilverfish || aBlock == Blocks.mob_spawner || aBlock.getMaterial() == Material.rock || aBlock.getMaterial() == Material.glass || aBlock.getMaterial() == Material.ice || aBlock.getMaterial() == Material.packedIce || RM.Hammer.containsInput(ST.make(aBlock, 1L, (long)aMetaData), null, CS.NI);
    }

    @Override
    public float getMiningSpeed(Block aBlock, byte aMetaData, float aDefault, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ) {
        return aBlock == Blocks.mob_spawner ? aDefault * 128.0f : aDefault;
    }

    @Override
    public int convertBlockDrops(List<ItemStack> aDrops, ItemStack aStack, EntityPlayer aPlayer, Block aBlock, long aAvailableDurability, int aX, int aY, int aZ, byte aMetaData, int aFortune, boolean aSilkTouch, BlockEvent.HarvestDropsEvent aEvent) {
        Recipe tRecipe;
        int rConversions = 0;
        if (aBlock.hasTileEntity((int)aMetaData) || null == (tRecipe = RM.Hammer.findRecipe(null, null, true, Integer.MAX_VALUE, null, CS.ZL_FS, ST.make(aBlock, 1L, (long)aMetaData)))) {
            ArrayListNoNulls<ItemStack> tDrops = ST.arraylist(new ItemStack[0]);
            for (int i = 0; i < aDrops.size(); ++i) {
                tRecipe = RM.Hammer.findRecipe(null, null, true, Integer.MAX_VALUE, null, CS.ZL_FS, ST.amount(1L, aDrops.get(i)));
                if (tRecipe == null) continue;
                byte tStackSize = (byte)aDrops.get((int)i).stackSize;
                rConversions += tStackSize;
                aDrops.remove(i--);
                if (tRecipe.mOutputs.length <= 0) continue;
                for (byte j = 0; j < tStackSize; j = (byte)(j + 1)) {
                    ItemStack[] tHammeringOutput = tRecipe.getOutputs();
                    for (int k = 0; k < tHammeringOutput.length; ++k) {
                        tDrops.add(tHammeringOutput[k]);
                    }
                }
            }
            aDrops.addAll(tDrops);
        } else {
            aDrops.clear();
            ItemStack[] tHammeringOutput = tRecipe.getOutputs(CS.RNGSUS);
            for (int k = 0; k < tHammeringOutput.length; ++k) {
                if (tHammeringOutput[k] == null) continue;
                aDrops.add(tHammeringOutput[k]);
            }
            ++rConversions;
        }
        return rConversions;
    }

    @Override
    public IIconContainer getIcon(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? MultiItemTool.getPrimaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.Steel).mTextureSetsItems.get(OP.toolHeadHammer.mIconIndexItem) : MultiItemTool.getSecondaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.WOODS.Spruce).mTextureSetsItems.get(OP.stick.mIconIndexItem);
    }

    @Override
    public short[] getRGBa(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? MultiItemTool.getPrimaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.Steel).mRGBaSolid : MultiItemTool.getSecondaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.WOODS.Spruce).mRGBaSolid;
    }

    @Override
    public void onStatsAddedToTool(MultiItemTool aItem, int aID) {
        aItem.addItemBehavior(aID, new Behavior_Tool("hammer", "random.anvil_land", 100L, true, CS.SFX.RANDOM_PITCH));
        aItem.addItemBehavior(aID, new Behavior_Tool("prospector", "random.anvil_use", 10L, true, CS.SFX.RANDOM_PITCH));
    }

    @Override
    public String getDeathMessage() {
        return "[VICTIM] was squashed by [KILLER]";
    }
}

