/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.behaviors;

import gregapi.data.FL;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.util.UT;
import gregapi.util.WD;
import ic2.api.crops.ICropTile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class Behavior_Watering_Crops
extends IBehavior.AbstractBehaviorDefault {
    public static final IBehavior<MultiItem> INSTANCE = new Behavior_Watering_Crops();

    @Override
    public boolean onItemUseFirst(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float hitX, float hitY, float hitZ) {
        if (aWorld.isRemote || aPlayer == null || !aPlayer.canPlayerEdit(aX, aY, aZ, (int)aSide, aStack)) {
            return false;
        }
        FluidStack mFluid = ((IFluidContainerItem)aItem).getFluid(aStack);
        if (FL.water(mFluid)) {
            TileEntity tTileEntity = WD.te(aWorld, aX, aY, aZ, false);
            try {
                if (tTileEntity instanceof ICropTile) {
                    int tHydration = ((ICropTile)tTileEntity).getHydrationStorage();
                    int tDrained = Math.min((200 - tHydration) / 10, mFluid.amount);
                    if (tDrained > 0) {
                        ((IFluidContainerItem)aItem).drain(aStack, tDrained, true);
                        ((ICropTile)tTileEntity).setHydrationStorage(tHydration + tDrained * 10);
                        UT.Sounds.send("liquid.water", aWorld, aX, aY, aZ);
                    }
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }
}

