/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.behaviors;

import gregapi.block.IBlockDecolorable;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.tileentity.ITileEntityDecolorable;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class Behavior_Spray_Color_Remover
extends IBehavior.AbstractBehaviorDefault {
    private final ItemStack mEmpty;
    private final ItemStack mUsed;
    private final ItemStack mFull;
    private final long mUses;

    public Behavior_Spray_Color_Remover(ItemStack aEmpty, ItemStack aUsed, ItemStack aFull, long aUses) {
        this.mEmpty = aEmpty;
        this.mUsed = aUsed;
        this.mFull = aFull;
        this.mUses = aUses * 10L;
    }

    @Override
    public boolean onItemUseFirst(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float hitX, float hitY, float hitZ) {
        if (aWorld.isRemote || aStack.stackSize != 1) {
            return false;
        }
        boolean rOutput = false;
        if (!aPlayer.canPlayerEdit(aX, aY, aZ, (int)aSide, aStack)) {
            return false;
        }
        NBTTagCompound tNBT = aStack.getTagCompound();
        if (tNBT == null) {
            tNBT = UT.NBT.make();
        }
        long tUses = tNBT.getLong("gt.remaining");
        if (ST.equal(aStack, this.mFull, true)) {
            aStack.func_150996_a(this.mUsed.getItem());
            ST.meta_(aStack, ST.meta_(this.mUsed));
            tUses = this.mUses;
        }
        if (ST.equal(aStack, this.mUsed, true) && Behavior_Spray_Color_Remover.decolorize(aWorld, aX, aY, aZ, aSide)) {
            UT.Sounds.send(CS.SFX.IC_SPRAY, aWorld, aX, aY, aZ);
            if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                tUses -= 10L;
            }
            rOutput = true;
        }
        tNBT.removeTag("gt.remaining");
        if (tUses > 0L) {
            UT.NBT.setNumber(tNBT, "gt.remaining", tUses);
        }
        UT.NBT.set(aStack, tNBT);
        if (tUses <= 0L) {
            if (this.mEmpty == null) {
                --aStack.stackSize;
            } else {
                aStack.func_150996_a(this.mEmpty.getItem());
                ST.meta_(aStack, ST.meta_(this.mEmpty));
            }
        }
        return rOutput;
    }

    private static boolean decolorize(World aWorld, int aX, int aY, int aZ, byte aSide) {
        DelegatorTileEntity<TileEntity> aDelegator = WD.te(aWorld, aX, aY, aZ, aSide, true);
        if (aDelegator.mTileEntity instanceof ITileEntityDecolorable) {
            return ((ITileEntityDecolorable)aDelegator.mTileEntity).removePaint(aDelegator.mSideOfTileEntity);
        }
        Block aBlock = aDelegator.getBlock();
        if (aBlock instanceof IBlockDecolorable) {
            return ((IBlockDecolorable)aBlock).removePaint(aWorld, aDelegator.mX, aDelegator.mY, aDelegator.mZ, aDelegator.mSideOfTileEntity);
        }
        if (aBlock == Blocks.stained_hardened_clay) {
            return aDelegator.setBlock(Blocks.hardened_clay);
        }
        if (aBlock == Blocks.stained_glass_pane) {
            return aDelegator.setBlock(Blocks.glass_pane);
        }
        if (aBlock == Blocks.stained_glass) {
            return aDelegator.setBlock(Blocks.glass);
        }
        if (aBlock == CS.BlocksGT.Grass) {
            return aDelegator.setBlock((Block)Blocks.grass);
        }
        return false;
    }

    @Override
    public List<String> getAdditionalToolTips(MultiItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(LH.get("gt.behaviour.paintremoverspray.tooltip"));
        NBTTagCompound tNBT = aStack.getTagCompound();
        long tRemaining = ST.equal(aStack, this.mFull, true) ? this.mUses : (tNBT == null ? 0L : tNBT.getLong("gt.remaining"));
        aList.add(LH.get("gt.behaviour.paintremoverspray.uses") + " " + tRemaining / 10L + "." + tRemaining % 10L);
        aList.add(LH.get("gt.behaviour.unstackable"));
        return aList;
    }

    static {
        LH.add("gt.behaviour.paintremoverspray.tooltip", "Can Decolor things");
        LH.add("gt.behaviour.paintremoverspray.uses", "Remaining Uses:");
        LH.add("gt.behaviour.unstackable", "Not usable when stacked!");
    }
}

