/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.behaviors;

import gregapi.block.IBlockToolable;
import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class Behavior_Lighter
extends IBehavior.AbstractBehaviorDefault {
    private final ItemStack mEmptyLighter;
    private final ItemStack mUsedLighter;
    private final ItemStack mFullLighter;
    private final long mFuelAmount;
    private final long mChance;

    public Behavior_Lighter(long aChance) {
        this.mFullLighter = null;
        this.mUsedLighter = null;
        this.mEmptyLighter = null;
        this.mFuelAmount = 1L;
        this.mChance = UT.Code.bind(0L, 10000L, aChance);
    }

    public Behavior_Lighter(ItemStack aEmptyLighter, ItemStack aUsedLighter, ItemStack aFullLighter, long aFuelAmount, long aChance) {
        this.mFullLighter = aFullLighter;
        this.mUsedLighter = aUsedLighter;
        this.mEmptyLighter = aEmptyLighter;
        this.mFuelAmount = aFuelAmount;
        this.mChance = UT.Code.bind(0L, 10000L, aChance);
    }

    @Override
    public boolean onLeftClickEntity(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, Entity aEntity) {
        if (aPlayer.worldObj.isRemote || aStack.stackSize != 1 && (this.mFuelAmount != 1L || this.mEmptyLighter != null)) {
            return false;
        }
        boolean rOutput = false;
        if (aEntity instanceof EntityCreeper) {
            this.prepare(aStack);
            long tFuelAmount = UT.NBT.getLighterFuel(aStack);
            if (ST.equal(aStack, this.mUsedLighter, true)) {
                UT.Sounds.send("fire.ignite", aEntity);
                ((EntityCreeper)aEntity).func_146079_cb();
                if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                    --tFuelAmount;
                }
                rOutput = true;
            }
            UT.NBT.setLighterFuel(aStack, tFuelAmount);
            if (tFuelAmount <= 0L) {
                this.useUp(aStack);
            }
        }
        return rOutput;
    }

    @Override
    public boolean onItemUseFirst(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (aWorld.isRemote || aStack.stackSize != 1 && (this.mFuelAmount != 1L || this.mEmptyLighter != null)) {
            return false;
        }
        this.prepare(aStack);
        if (ST.invalid(this.mUsedLighter)) {
            UT.Sounds.send("fire.ignite", aWorld, aX, aY, aZ);
            long tDamage = 0L;
            if ((long)CS.RNGSUS.nextInt(10000) < this.mChance) {
                ArrayListNoNulls<String> tChatReturn = new ArrayListNoNulls<String>();
                tDamage = IBlockToolable.Util.onToolClick("igniter", Long.MAX_VALUE, 3L, (Entity)aPlayer, tChatReturn, (IInventory)aPlayer.inventory, aPlayer.isSneaking(), aStack, aWorld, aSide, aX, aY, aZ, aHitX, aHitY, aHitZ);
                UT.Entities.sendchat((Object)aPlayer, tChatReturn, false);
            } else {
                tDamage = 10000L;
            }
            if (tDamage != 0L) {
                if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                    this.useUp(aStack);
                }
                return true;
            }
        } else if (ST.equal(aStack, this.mUsedLighter, true)) {
            UT.Sounds.send("fire.ignite", aWorld, aX, aY, aZ);
            long tDamage = 0L;
            if ((long)CS.RNGSUS.nextInt(10000) < this.mChance) {
                ArrayListNoNulls<String> tChatReturn = new ArrayListNoNulls<String>();
                tDamage = IBlockToolable.Util.onToolClick("igniter", Long.MAX_VALUE, 3L, (Entity)aPlayer, tChatReturn, (IInventory)aPlayer.inventory, aPlayer.isSneaking(), aStack, aWorld, aSide, aX, aY, aZ, aHitX, aHitY, aHitZ);
                UT.Entities.sendchat((Object)aPlayer, tChatReturn, false);
            } else {
                tDamage = 10000L;
            }
            if (tDamage != 0L) {
                if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                    long tFuelAmount = UT.NBT.getLighterFuel(aStack) - UT.Code.units(tDamage, 10000L, 1L, true);
                    UT.NBT.setLighterFuel(aStack, tFuelAmount);
                    if (tFuelAmount <= 0L) {
                        this.useUp(aStack);
                    }
                }
                return true;
            }
        }
        return false;
    }

    private void prepare(ItemStack aStack) {
        if (ST.valid(this.mFullLighter) && ST.equal(aStack, this.mFullLighter, true)) {
            aStack.func_150996_a(this.mUsedLighter.getItem());
            ST.meta_(aStack, ST.meta_(this.mUsedLighter));
            UT.NBT.setLighterFuel(aStack, this.mFuelAmount);
        }
    }

    private void useUp(ItemStack aStack) {
        if (ST.invalid(this.mEmptyLighter)) {
            --aStack.stackSize;
        } else {
            aStack.func_150996_a(this.mEmptyLighter.getItem());
            ST.meta_(aStack, ST.meta_(this.mEmptyLighter));
        }
    }

    @Override
    public List<String> getAdditionalToolTips(MultiItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(LH.get("gt.behaviour.lighter.tooltip"));
        NBTTagCompound tNBT = aStack.getTagCompound();
        if (this.mFuelAmount > 1L) {
            long tFuelAmount = ST.invalid(this.mFullLighter) ? 1L : (tNBT == null ? (ST.equal(aStack, this.mFullLighter, true) ? this.mFuelAmount : 0L) : UT.NBT.getLighterFuel(aStack));
            aList.add(LH.get("gt.behaviour.lighter.uses") + " " + tFuelAmount);
        } else {
            aList.add(LH.get("gt.behaviour.singleuse"));
        }
        if (this.mChance < 10000L) {
            aList.add(LH.get("gt.behaviour.lighter.chance") + " " + this.mChance / 100L + "." + this.mChance % 100L + "%");
        }
        if (aStack.stackSize != 1 && (this.mFuelAmount != 1L || ST.valid(this.mEmptyLighter))) {
            aList.add(LH.Chat.RED + LH.get("gt.lang.requirement.unstacked"));
        }
        return aList;
    }

    static {
        LH.add("gt.behaviour.lighter.tooltip", "Can light things on Fire");
        LH.add("gt.behaviour.lighter.uses", "Remaining Uses:");
        LH.add("gt.behaviour.lighter.chance", "Chance:");
        LH.add("gt.behaviour.singleuse", "Single Use");
    }
}

