/*
 * Decompiled with CFR 0.152.
 */
package gregtech.blocks.tool;

import gregapi.block.MaterialMachines;
import gregapi.block.misc.BlockBaseMachineUpdate;
import gregapi.data.LH;
import gregapi.render.IIconContainer;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class BlockLongDistPipe
extends BlockBaseMachineUpdate {
    public final long[] mTemperatures;

    public BlockLongDistPipe(String aUnlocalised, IIconContainer[] aIcons, long[] aTemperatures) {
        super(null, aUnlocalised, MaterialMachines.instance, soundTypeMetal, 5L, aIcons, -1);
        this.mTemperatures = aTemperatures;
        LH.add(aUnlocalised + ".0", "Long Distance Item Pipeline");
        for (int i = 1; i < this.maxMeta(); ++i) {
            LH.add(aUnlocalised + "." + i, "Long Distance Fluid Pipeline (" + this.mTemperatures[i] + " K)");
        }
    }

    @Override
    public String getHarvestTool(int aMeta) {
        return "wrench";
    }

    @Override
    public int getHarvestLevel(int aMeta) {
        return 3;
    }

    @Override
    public boolean isSealable(byte aMeta, byte aSide) {
        return true;
    }

    @Override
    public float getBlockHardness(World aWorld, int aX, int aY, int aZ) {
        return Blocks.iron_block.getBlockHardness(aWorld, aX, aY, aZ);
    }

    @Override
    public float getExplosionResistance(Entity aEntity, World aWorld, int aX, int aY, int aZ, double eX, double eY, double eZ) {
        return 20.0f;
    }

    @Override
    public float getExplosionResistance(Entity aEntity) {
        return 20.0f;
    }

    @Override
    public float getExplosionResistance(byte aMeta) {
        return 20.0f;
    }
}

