/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.misc;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.MT;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterial;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityQuickObstructionCheck;
import gregapi.tileentity.notick.TileEntityBase03MultiTileEntities;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public abstract class MultiTileEntityPlaceable
extends TileEntityBase03MultiTileEntities
implements IMultiTileEntity.IMTE_SyncDataByteArray,
IMultiTileEntity.IMTE_CanEntityDestroy,
IMultiTileEntity.IMTE_GetBlockHardness,
IMultiTileEntity.IMTE_IsSideSolid,
IMultiTileEntity.IMTE_GetLightOpacity,
IMultiTileEntity.IMTE_GetExplosionResistance,
ITileEntityQuickObstructionCheck,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState {
    public ItemStack mStack;
    public ITexture mTextureSides;
    public ITexture mTextureTop;
    public OreDictMaterial mMaterial = MT.Empty;
    public byte mSize = 1;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        this.mStack = ST.load(aNBT, "gt.value");
        if (ST.valid(this.mStack)) {
            this.mSize = UT.Code.bindStack(ST.size(this.mStack));
            OreDictItemData tData = OM.anydata(this.mStack);
            if (tData != null && tData.nonemptyMaterial()) {
                this.mMaterial = tData.mMaterial.mMaterial;
            }
        }
        super.readFromNBT2(aNBT);
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        ST.save(aNBT, "gt.value", this.mStack);
    }

    @Override
    public ArrayListNoNulls<ItemStack> getDrops(int aFortune, boolean aSilkTouch) {
        return ST.arraylist(this.mStack);
    }

    @Override
    public boolean onBlockActivated2(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return true;
        }
        ItemStack aStack = aPlayer.getCurrentEquippedItem();
        if (ST.invalid(this.mStack) || this.mStack.stackSize <= 0) {
            return this.setToAir();
        }
        if (ST.equal(aStack, this.mStack)) {
            if (this.mStack.stackSize >= 64) {
                return true;
            }
            if (this.mStack.stackSize + aStack.stackSize > 64) {
                aStack.stackSize -= 64 - this.mStack.stackSize;
                this.mStack.stackSize = 64;
                this.mSize = ST.size(this.mStack);
                this.updateClientData();
                this.playCollect();
                return true;
            }
            this.mStack.stackSize += aStack.stackSize;
            this.mSize = ST.size(this.mStack);
            this.updateClientData();
            aStack.stackSize = 0;
            this.playCollect();
            return true;
        }
        if (ST.give((Entity)aPlayer, ST.amount(1L, this.mStack), true, this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5)) {
            TileEntity tTileEntity;
            MultiTileEntityPlaceable tSelected = this;
            for (int i = 1; i < 255 && (tTileEntity = this.getTileEntityAtSideAndDistance((byte)1, i)) instanceof MultiTileEntityPlaceable && ST.equal(this.mStack, ((MultiTileEntityPlaceable)tTileEntity).mStack); ++i) {
                tSelected = (MultiTileEntityPlaceable)tTileEntity;
            }
            tSelected.playCollect();
            if (--tSelected.mStack.stackSize <= 0) {
                return tSelected.setToAir();
            }
            tSelected.mSize = ST.size(tSelected.mStack);
            tSelected.updateClientData();
            return true;
        }
        return true;
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        return this.getClientDataPacketByteArray(aSendAll, UT.Code.toByteS(this.mMaterial.mID, 0), UT.Code.toByteS(this.mMaterial.mID, 1), this.mSize);
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        this.mMaterial = OreDictMaterial.MATERIAL_ARRAY[UT.Code.bind15(UT.Code.combine(aData[0], aData[1]))];
        this.mSize = aData[2];
        return true;
    }

    @Override
    public ITexture getTexture(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return CS.SIDES_HORIZONTAL[aSide] ? this.mTextureSides : this.mTextureTop;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return false;
    }

    @Override
    public boolean isSurfaceOpaque(byte aSide) {
        return false;
    }

    @Override
    public boolean isSideSolid(byte aSide) {
        return false;
    }

    @Override
    public boolean isObstructingBlockAt(byte aSide) {
        return false;
    }

    @Override
    public boolean checkObstruction(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return false;
    }

    @Override
    public boolean canEntityDestroy(Entity aEntity) {
        return !(aEntity instanceof EntityDragon);
    }

    @Override
    public int getLightOpacity() {
        return 1;
    }

    @Override
    public float getExplosionResistance2() {
        return 0.0f;
    }

    @Override
    public float getBlockHardness() {
        return 0.25f;
    }
}

