/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.energy;

import appeng.tile.powersink.IC2;
import buildcraft.api.power.ILaserTarget;
import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import com.builtbroken.mc.api.energy.IEnergyBuffer;
import com.builtbroken.mc.api.energy.IEnergyBufferProvider;
import com.rwtema.funkylocomotion.blocks.TileBooster;
import com.rwtema.funkylocomotion.blocks.TilePusher;
import cr0s.warpdrive.block.TileEntityAbstractEnergy;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.MD;
import gregapi.data.TD;
import gregapi.tileentity.ITileEntityEnergy;
import gregapi.tileentity.base.TileEntityBase01Root;
import gregapi.util.UT;
import gregtech.api.interfaces.tileentity.IEnergyConnected;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import micdoodle8.mods.galacticraft.api.power.EnergySource;
import micdoodle8.mods.galacticraft.api.power.IEnergyHandlerGC;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class EnergyCompat {
    public static boolean RF_ENERGY = false;
    public static boolean RF_ENERGY_NEW = false;
    public static boolean AE_ENERGY = false;
    public static boolean FL_ENERGY = false;
    public static boolean WD_ENERGY = false;
    public static boolean IC_ENERGY = false;
    public static boolean BB_ENERGY = false;
    public static boolean GC_ENERGY = false;
    public static boolean BC_LASER = false;

    public static void checkAvailabilities() {
        try {
            TilePusher.class.getCanonicalName();
            TileBooster.class.getCanonicalName();
            FL_ENERGY = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            TileEntityAbstractEnergy.class.getCanonicalName();
            WD_ENERGY = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            IEnergyHandler.class.getCanonicalName();
            IEnergyConnection.class.getCanonicalName();
            RF_ENERGY = true;
            IEnergyReceiver.class.getCanonicalName();
            RF_ENERGY_NEW = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            IC2.class.getCanonicalName();
            AE_ENERGY = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            IEnergyTile.class.getCanonicalName();
            IEnergySink.class.getCanonicalName();
            IEnergySource.class.getCanonicalName();
            IEnergyConductor.class.getCanonicalName();
            IC_ENERGY = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            IEnergyBufferProvider.class.getCanonicalName();
            IEnergyBuffer.class.getCanonicalName();
            BB_ENERGY = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            IEnergyHandlerGC.class.getCanonicalName();
            EnergySource.class.getCanonicalName();
            IConnector.class.getCanonicalName();
            NetworkType.class.getCanonicalName();
            EnergyConfigHandler.class.getCanonicalName();
            GC_ENERGY = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            ILaserTarget.class.getCanonicalName();
            BC_LASER = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean isElectricRFReceiver(TileEntity aReceiver) {
        if (aReceiver == null) {
            return false;
        }
        String tClass = null;
        if (MD.OMT.mLoaded && (tClass = aReceiver.getClass().getName()).startsWith("openmodularturrets")) {
            return true;
        }
        if (MD.IE.mLoaded) {
            if (tClass == null) {
                tClass = aReceiver.getClass().getName();
            }
            if (tClass.startsWith("blusunrize.immersiveengineering")) {
                return true;
            }
        }
        if (MD.OC.mLoaded) {
            if (tClass == null) {
                tClass = aReceiver.getClass().getName();
            }
            if (tClass.startsWith("li.cil.oc")) {
                return true;
            }
        }
        if (MD.TG.mLoaded) {
            if (tClass == null) {
                tClass = aReceiver.getClass().getName();
            }
            if (tClass.startsWith("techguns")) {
                return true;
            }
        }
        return false;
    }

    public static boolean canConnectElectricity(TileEntity aThis, TileEntity aTarget, byte aSide) {
        if (aTarget == null) {
            return false;
        }
        if (aTarget instanceof gregapi.tileentity.energy.ITileEntityEnergy) {
            return ((gregapi.tileentity.energy.ITileEntityEnergy)aTarget).isEnergyAcceptingFrom(TD.Energy.EU, aSide, true) || ((gregapi.tileentity.energy.ITileEntityEnergy)aTarget).isEnergyEmittingTo(TD.Energy.EU, aSide, true);
        }
        if (aTarget instanceof ITileEntityEnergy) {
            return ((ITileEntityEnergy)aTarget).isEnergyAcceptingFrom(TD.Energy.EU, aSide, true) || ((ITileEntityEnergy)aTarget).isEnergyEmittingTo(TD.Energy.EU, aSide, true);
        }
        if (aTarget instanceof IEnergyConnected) {
            return ((IEnergyConnected)aTarget).inputEnergyFrom(aSide) || ((IEnergyConnected)aTarget).outputsEnergyTo(aSide);
        }
        if (AE_ENERGY && aTarget instanceof IC2) {
            return aThis == null || ((IC2)aTarget).acceptsEnergyFrom(aThis, CS.FORGE_DIR[aSide]);
        }
        if (FL_ENERGY && (aTarget instanceof TilePusher || aTarget instanceof TileBooster)) {
            return true;
        }
        if (WD_ENERGY && aTarget instanceof TileEntityAbstractEnergy) {
            return ((TileEntityAbstractEnergy)aTarget).energy_canInput(CS.FORGE_DIR[aSide]);
        }
        if (GC_ENERGY && aTarget instanceof IEnergyHandlerGC && (!(aTarget instanceof IConnector) || ((IConnector)aTarget).canConnect(CS.FORGE_DIR[aSide], NetworkType.POWER))) {
            return true;
        }
        if (BB_ENERGY && aTarget instanceof IEnergyBufferProvider && ((IEnergyBufferProvider)aTarget).getEnergyBuffer(CS.FORGE_DIR[aSide]) != null) {
            return true;
        }
        if (IC_ENERGY) {
            TileEntity tConnected;
            TileEntity tileEntity = tConnected = aTarget instanceof IEnergyTile || EnergyNet.instance == null ? aTarget : EnergyNet.instance.getTileEntity(aTarget.getWorldObj(), aTarget.xCoord, aTarget.yCoord, aTarget.zCoord);
            if (tConnected instanceof IEnergySink && (aThis == null || ((IEnergySink)tConnected).acceptsEnergyFrom(aThis, CS.FORGE_DIR[aSide]))) {
                return true;
            }
            if (tConnected instanceof IEnergySource && (aThis == null || ((IEnergySource)tConnected).emitsEnergyTo(aThis, CS.FORGE_DIR[aSide]))) {
                return true;
            }
        }
        if (RF_ENERGY && (CS.EMIT_EU_AS_RF || EnergyCompat.isElectricRFReceiver(aTarget)) && (aTarget instanceof IEnergyHandler || RF_ENERGY_NEW && aTarget instanceof IEnergyReceiver)) {
            return !(aTarget instanceof IEnergyConnection) || ((IEnergyConnection)aTarget).canConnectEnergy(CS.FORGE_DIR[aSide]);
        }
        return false;
    }

    public static boolean checkOverCharge(long aSize, TileEntity aReceiver) {
        if (aSize > CS.VMAX[3]) {
            World tWorld = aReceiver.getWorldObj();
            tWorld.setBlockToAir(aReceiver.xCoord, aReceiver.yCoord, aReceiver.zCoord);
            tWorld.newExplosion(null, (double)aReceiver.xCoord + 0.5, (double)aReceiver.yCoord + 0.5, (double)aReceiver.zCoord + 0.5, 5.0f, false, true);
            return true;
        }
        return false;
    }

    public static long insertEnergyInto(TagData aEnergyType, byte aSide, long aSize, long aAmount, Object aEmitter, TileEntity aReceiver) {
        if (aAmount <= 0L || aSize == 0L || aReceiver == null) {
            return 0L;
        }
        if (aReceiver instanceof TileEntityBase01Root) {
            return 0L;
        }
        if (aEnergyType == TD.Energy.EU) {
            IEnergyBuffer tEnergyBuffer;
            aSize = Math.abs(aSize);
            if (AE_ENERGY && aReceiver instanceof IC2) {
                if (((IC2)aReceiver).acceptsEnergyFrom(aEmitter instanceof TileEntity ? (TileEntity)aEmitter : null, CS.FORGE_DIR[aSide])) {
                    long rUsedAmount;
                    if (EnergyCompat.checkOverCharge(aSize, aReceiver)) {
                        return aAmount;
                    }
                    for (rUsedAmount = 0L; aAmount > rUsedAmount && ((IC2)aReceiver).getDemandedEnergy() >= (double)aSize && ((IC2)aReceiver).injectEnergy(CS.FORGE_DIR[aSide], (double)aSize, (double)aSize) < (double)aSize; ++rUsedAmount) {
                    }
                    return rUsedAmount;
                }
                return 0L;
            }
            if (FL_ENERGY) {
                if (aReceiver instanceof TilePusher) {
                    return EnergyCompat.checkOverCharge(aSize, aReceiver) ? aAmount : UT.Code.divup(((TilePusher)aReceiver).receiveEnergy(CS.FORGE_DIR[aSide], UT.Code.bind31(aAmount * aSize * 4L * 10L), false), aSize * 4L * 10L);
                }
                if (aReceiver instanceof TileBooster) {
                    return EnergyCompat.checkOverCharge(aSize, aReceiver) ? aAmount : UT.Code.divup(((TileBooster)aReceiver).receiveEnergy(CS.FORGE_DIR[aSide], UT.Code.bind31(aAmount * aSize * 4L * 10L), false), aSize * 4L * 10L);
                }
            }
            if (WD_ENERGY && aReceiver instanceof TileEntityAbstractEnergy) {
                if (((TileEntityAbstractEnergy)aReceiver).energy_getEnergyStored() >= ((TileEntityAbstractEnergy)aReceiver).energy_getMaxStorage()) {
                    return 0L;
                }
                if (EnergyCompat.checkOverCharge(aSize, aReceiver)) {
                    return aAmount;
                }
                ((TileEntityAbstractEnergy)aReceiver).energy_consume(-aSize);
                return 1L;
            }
            if (GC_ENERGY && CS.COMPAT_GC != null && aReceiver instanceof IEnergyHandlerGC && (!RF_ENERGY || !EnergyCompat.isElectricRFReceiver(aReceiver))) {
                if (!(aReceiver instanceof IConnector) || ((IConnector)aReceiver).canConnect(CS.FORGE_DIR[aSide], NetworkType.POWER)) {
                    float tReceived;
                    if (EnergyCompat.checkOverCharge(aSize, aReceiver)) {
                        return aAmount;
                    }
                    float tSizeToReceive = (float)aSize * EnergyConfigHandler.IC2_RATIO;
                    float tStored = ((IEnergyHandlerGC)aReceiver).getEnergyStoredGC((EnergySource)CS.COMPAT_GC.dir(aSide));
                    if ((tSizeToReceive >= tStored || tSizeToReceive <= ((IEnergyHandlerGC)aReceiver).getMaxEnergyStoredGC((EnergySource)CS.COMPAT_GC.dir(aSide)) - tStored) && (tReceived = ((IEnergyHandlerGC)aReceiver).receiveEnergyGC((EnergySource)CS.COMPAT_GC.dir(aSide), tSizeToReceive, false)) > 0.0f) {
                        tSizeToReceive -= tReceived;
                        while (tSizeToReceive > 0.0f && !((tReceived = ((IEnergyHandlerGC)aReceiver).receiveEnergyGC((EnergySource)CS.COMPAT_GC.dir(aSide), tSizeToReceive, false)) < 1.0f)) {
                            tSizeToReceive -= tReceived;
                        }
                        return 1L;
                    }
                }
                return 0L;
            }
            if (BB_ENERGY && aReceiver instanceof IEnergyBufferProvider && (tEnergyBuffer = ((IEnergyBufferProvider)aReceiver).getEnergyBuffer(CS.FORGE_DIR[aSide])) != null) {
                return EnergyCompat.checkOverCharge(aSize, aReceiver) ? aAmount : UT.Code.divup(tEnergyBuffer.addEnergyToStorage(UT.Code.bind31(aSize * aAmount) * 10, true), aSize * 10L);
            }
            if (RF_ENERGY && (CS.EMIT_EU_AS_RF || EnergyCompat.isElectricRFReceiver(aReceiver))) {
                if (!(aReceiver instanceof IEnergyConnection) || ((IEnergyConnection)aReceiver).canConnectEnergy(CS.FORGE_DIR[aSide])) {
                    if (RF_ENERGY_NEW && aReceiver instanceof IEnergyReceiver) {
                        return EnergyCompat.checkOverCharge(aSize, aReceiver) ? aAmount : UT.Code.divup(((IEnergyReceiver)aReceiver).receiveEnergy(CS.FORGE_DIR[aSide], UT.Code.bind31(aAmount * aSize * 4L), false), aSize * 4L);
                    }
                    if (aReceiver instanceof IEnergyHandler) {
                        return EnergyCompat.checkOverCharge(aSize, aReceiver) ? aAmount : UT.Code.divup(((IEnergyHandler)aReceiver).receiveEnergy(CS.FORGE_DIR[aSide], UT.Code.bind31(aAmount * aSize * 4L), false), aSize * 4L);
                    }
                }
                return 0L;
            }
            if (aReceiver instanceof IEnergyConnected) {
                return ((IEnergyConnected)aReceiver).injectEnergyUnits(aSide, aSize, aAmount);
            }
            if (IC_ENERGY) {
                TileEntity tReceiver;
                TileEntity tileEntity = tReceiver = aReceiver instanceof IEnergyTile || EnergyNet.instance == null ? aReceiver : EnergyNet.instance.getTileEntity(aReceiver.getWorldObj(), aReceiver.xCoord, aReceiver.yCoord, aReceiver.zCoord);
                if (tReceiver instanceof IEnergySink && ((IEnergySink)tReceiver).acceptsEnergyFrom(aEmitter instanceof TileEntity ? (TileEntity)aEmitter : null, CS.FORGE_DIR[aSide])) {
                    int tTier;
                    long rUsedAmount;
                    for (rUsedAmount = 0L; aAmount > rUsedAmount; ++rUsedAmount) {
                        double d = ((IEnergySink)tReceiver).getDemandedEnergy();
                        long l = rUsedAmount <= 0L && aSize <= CS.VMAX[0] ? 4L : aSize;
                        if (!(d >= (double)l) || !(((IEnergySink)tReceiver).injectEnergy(CS.FORGE_DIR[aSide], (double)aSize, (double)aSize) < (double)aSize)) break;
                    }
                    if (rUsedAmount > 0L && (tTier = ((IEnergySink)tReceiver).getSinkTier()) >= 0 && tTier < CS.VMAX.length - 1 && aSize > CS.VMAX[tTier]) {
                        World tWorld = tReceiver.getWorldObj();
                        tWorld.setBlockToAir(tReceiver.xCoord, tReceiver.yCoord, tReceiver.zCoord);
                        tWorld.newExplosion(null, (double)tReceiver.xCoord + 0.5, (double)tReceiver.yCoord + 0.5, (double)tReceiver.zCoord + 0.5, (float)(tTier + 1), false, true);
                        return aAmount;
                    }
                    return rUsedAmount;
                }
            }
            return 0L;
        }
        if (RF_ENERGY && aSize > 0L) {
            long tSizeToReceive = 0L;
            if (aEnergyType == TD.Energy.KU) {
                tSizeToReceive = aSize * 4L;
            } else if (aEnergyType == TD.Energy.MJ) {
                tSizeToReceive = aSize * 10L;
            } else if (aEnergyType == TD.Energy.RF) {
                tSizeToReceive = aSize;
            }
            if (tSizeToReceive > 0L && (!(aReceiver instanceof IEnergyConnection) || ((IEnergyConnection)aReceiver).canConnectEnergy(CS.FORGE_DIR[aSide]))) {
                if (RF_ENERGY_NEW && aReceiver instanceof IEnergyReceiver) {
                    return UT.Code.divup(((IEnergyReceiver)aReceiver).receiveEnergy(CS.FORGE_DIR[aSide], UT.Code.bind31(aAmount * tSizeToReceive), false), tSizeToReceive);
                }
                if (aReceiver instanceof IEnergyHandler) {
                    return UT.Code.divup(((IEnergyHandler)aReceiver).receiveEnergy(CS.FORGE_DIR[aSide], UT.Code.bind31(aAmount * tSizeToReceive), false), tSizeToReceive);
                }
            }
        }
        return 0L;
    }
}

