/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.delegate;

import cpw.mods.fml.common.FMLCommonHandler;
import gregapi.data.CS;
import gregapi.random.WorldAndCoords;
import gregapi.tileentity.ITileEntityUnloadable;
import gregapi.util.UT;
import gregapi.util.WD;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;

public final class DelegatorTileEntity<T>
extends WorldAndCoords {
    public final T mTileEntity;
    public final byte mSideOfTileEntity;

    public DelegatorTileEntity(DelegatorTileEntity<T> aDelegator) {
        super(aDelegator.mWorld, aDelegator.mX, aDelegator.mY, aDelegator.mZ);
        this.mTileEntity = aDelegator.mTileEntity;
        this.mSideOfTileEntity = aDelegator.mSideOfTileEntity;
    }

    public DelegatorTileEntity(T aTileEntity, byte aSideOfTileEntity) {
        super((TileEntity)aTileEntity);
        this.mTileEntity = aTileEntity;
        this.mSideOfTileEntity = aSideOfTileEntity;
    }

    public DelegatorTileEntity(T aTileEntity, DelegatorTileEntity<?> aDelegator) {
        super(aDelegator.mWorld, aDelegator.mX, aDelegator.mY, aDelegator.mZ);
        this.mTileEntity = aTileEntity;
        this.mSideOfTileEntity = aDelegator.mSideOfTileEntity;
    }

    public DelegatorTileEntity(T aTileEntity, World aWorld, int aX, int aY, int aZ, byte aSideOfTileEntity) {
        super(aWorld, aX, aY, aZ);
        this.mTileEntity = aTileEntity;
        this.mSideOfTileEntity = aSideOfTileEntity;
    }

    public DelegatorTileEntity(T aTileEntity, World aWorld, ChunkCoordinates aCoords, byte aSideOfTileEntity) {
        super(aWorld, aCoords.posX, aCoords.posY, aCoords.posZ);
        this.mTileEntity = aTileEntity;
        this.mSideOfTileEntity = aSideOfTileEntity;
    }

    public AxisAlignedBB box(double aMinX, double aMinY, double aMinZ, double aMaxX, double aMaxY, double aMaxZ) {
        return AxisAlignedBB.getBoundingBox((double)((double)this.mX + aMinX), (double)((double)this.mY + aMinY), (double)((double)this.mZ + aMinZ), (double)((double)this.mX + aMaxX), (double)((double)this.mY + aMaxY), (double)((double)this.mZ + aMaxZ));
    }

    public AxisAlignedBB box(double[] aBox) {
        return AxisAlignedBB.getBoundingBox((double)((double)this.mX + aBox[0]), (double)((double)this.mY + aBox[1]), (double)((double)this.mZ + aBox[2]), (double)((double)this.mX + aBox[3]), (double)((double)this.mY + aBox[4]), (double)((double)this.mZ + aBox[5]));
    }

    public AxisAlignedBB box(float[] aBox) {
        return AxisAlignedBB.getBoundingBox((double)((float)this.mX + aBox[0]), (double)((float)this.mY + aBox[1]), (double)((float)this.mZ + aBox[2]), (double)((float)this.mX + aBox[3]), (double)((float)this.mY + aBox[4]), (double)((float)this.mZ + aBox[5]));
    }

    public AxisAlignedBB box() {
        return AxisAlignedBB.getBoundingBox((double)this.mX, (double)this.mY, (double)this.mZ, (double)(this.mX + 1), (double)(this.mY + 1), (double)(this.mZ + 1));
    }

    public ForgeDirection getForgeSideOfTileEntity() {
        return CS.FORGE_DIR[this.mSideOfTileEntity];
    }

    public Block getBlock() {
        return this.mWorld.getBlock(this.mX, this.mY, this.mZ);
    }

    public byte getMetaData() {
        return UT.Code.bind4(this.mWorld.getBlockMetadata(this.mX, this.mY, this.mZ));
    }

    public boolean setBlock(Block aBlock) {
        return this.mWorld.setBlock(this.mX, this.mY, this.mZ, aBlock, 0, 3);
    }

    public boolean setBlock(Block aBlock, int aMetaData) {
        return this.mWorld.setBlock(this.mX, this.mY, this.mZ, aBlock, (int)UT.Code.bind4(aMetaData), 3);
    }

    public boolean setBlock(Block aBlock, int aMetaData, int aFlags) {
        return this.mWorld.setBlock(this.mX, this.mY, this.mZ, aBlock, (int)UT.Code.bind4(aMetaData), aFlags);
    }

    public boolean setMetaData(int aMetaData) {
        return this.mWorld.setBlockMetadataWithNotify(this.mX, this.mY, this.mZ, (int)UT.Code.bind4(aMetaData), 3);
    }

    public boolean setMetaData(int aMetaData, int aFlags) {
        return this.mWorld.setBlockMetadataWithNotify(this.mX, this.mY, this.mZ, (int)UT.Code.bind4(aMetaData), aFlags);
    }

    public boolean hasCollisionBox() {
        return this.mWorld != null && WD.hasCollide(this.mWorld, this.mX, this.mY, this.mZ);
    }

    public boolean equalCoords(DelegatorTileEntity<?> aOther) {
        return aOther.mX == this.mX && aOther.mY == this.mY && aOther.mZ == this.mZ;
    }

    public boolean equalSideAndCoords(DelegatorTileEntity<?> aOther) {
        return aOther.mSideOfTileEntity == this.mSideOfTileEntity && this.equalCoords(aOther);
    }

    public boolean equalSideWorldAndCoords(DelegatorTileEntity<?> aOther) {
        return aOther.mWorld == this.mWorld && this.equalSideAndCoords(aOther);
    }

    public boolean equalSideTileEntityAndCoords(DelegatorTileEntity<?> aOther) {
        return aOther.mTileEntity == this.mTileEntity && this.equalSideAndCoords(aOther);
    }

    public boolean exists() {
        return this.mTileEntity instanceof ITileEntityUnloadable ? !((ITileEntityUnloadable)this.mTileEntity).isDead() : this.mTileEntity != null && !((TileEntity)this.mTileEntity).isInvalid() && this.mWorld != null && this.mWorld.blockExists(this.mX, this.mY, this.mZ);
    }

    @Override
    public World getWorld() {
        return this.mWorld;
    }

    @Override
    public int getX() {
        return this.mX;
    }

    @Override
    public int getY() {
        return this.mY;
    }

    @Override
    public int getZ() {
        return this.mZ;
    }

    @Override
    public int getOffsetX(byte aSide) {
        return this.mX + CS.OFFX[aSide];
    }

    @Override
    public int getOffsetY(byte aSide) {
        return this.mY + CS.OFFY[aSide];
    }

    @Override
    public int getOffsetZ(byte aSide) {
        return this.mZ + CS.OFFZ[aSide];
    }

    @Override
    public int getOffsetX(byte aSide, int aMultiplier) {
        return this.mX + CS.OFFX[aSide] * aMultiplier;
    }

    @Override
    public int getOffsetY(byte aSide, int aMultiplier) {
        return this.mY + CS.OFFY[aSide] * aMultiplier;
    }

    @Override
    public int getOffsetZ(byte aSide, int aMultiplier) {
        return this.mZ + CS.OFFZ[aSide] * aMultiplier;
    }

    @Override
    public int getOffsetXN(byte aSide) {
        return this.mX - CS.OFFX[aSide];
    }

    @Override
    public int getOffsetYN(byte aSide) {
        return this.mY - CS.OFFY[aSide];
    }

    @Override
    public int getOffsetZN(byte aSide) {
        return this.mZ - CS.OFFZ[aSide];
    }

    @Override
    public int getOffsetXN(byte aSide, int aMultiplier) {
        return this.mX - CS.OFFX[aSide] * aMultiplier;
    }

    @Override
    public int getOffsetYN(byte aSide, int aMultiplier) {
        return this.mY - CS.OFFY[aSide] * aMultiplier;
    }

    @Override
    public int getOffsetZN(byte aSide, int aMultiplier) {
        return this.mZ - CS.OFFZ[aSide] * aMultiplier;
    }

    @Override
    public ChunkCoordinates getCoords() {
        return new ChunkCoordinates(this.mX, this.mY, this.mZ);
    }

    @Override
    public ChunkCoordinates getOffset(byte aSide, int aMultiplier) {
        return new ChunkCoordinates(this.getOffsetX(aSide, aMultiplier), this.getOffsetY(aSide, aMultiplier), this.getOffsetZ(aSide, aMultiplier));
    }

    @Override
    public ChunkCoordinates getOffsetN(byte aSide, int aMultiplier) {
        return new ChunkCoordinates(this.getOffsetXN(aSide, aMultiplier), this.getOffsetYN(aSide, aMultiplier), this.getOffsetZN(aSide, aMultiplier));
    }

    @Override
    public boolean isServerSide() {
        return this.mWorld == null ? FMLCommonHandler.instance().getEffectiveSide().isServer() : !this.mWorld.isRemote;
    }

    @Override
    public boolean isClientSide() {
        return this.mWorld == null ? FMLCommonHandler.instance().getEffectiveSide().isClient() : this.mWorld.isRemote;
    }

    @Override
    public int rng(int aRange) {
        return CS.RNGSUS.nextInt(aRange);
    }

    @Override
    public int getRandomNumber(int aRange) {
        return CS.RNGSUS.nextInt(aRange);
    }

    @Override
    public TileEntity getTileEntity(int aX, int aY, int aZ) {
        return this.mWorld == null ? null : this.mWorld.getTileEntity(aX, aY, aZ);
    }

    @Override
    public Block getBlock(int aX, int aY, int aZ) {
        return this.mWorld == null ? CS.NB : this.mWorld.getBlock(aX, aY, aZ);
    }

    @Override
    public byte getMetaData(int aX, int aY, int aZ) {
        return this.mWorld == null ? (byte)0 : UT.Code.bind4(this.mWorld.getBlockMetadata(aX, aY, aZ));
    }

    @Override
    public byte getLightLevel(int aX, int aY, int aZ) {
        return this.mWorld == null ? (byte)0 : UT.Code.bind4((long)this.mWorld.getLightBrightness(aX, aY, aZ) * 15L);
    }

    @Override
    public boolean getOpacity(int aX, int aY, int aZ) {
        return this.mWorld != null && this.mWorld.getBlock(aX, aY, aZ).isOpaqueCube();
    }

    @Override
    public boolean getSky(int aX, int aY, int aZ) {
        return this.mWorld == null || this.mWorld.canBlockSeeTheSky(aX, aY, aZ);
    }

    @Override
    public boolean getRain(int aX, int aY, int aZ) {
        return this.mWorld == null || this.mWorld.getPrecipitationHeight(aX, aZ) <= aY;
    }

    @Override
    public boolean getAir(int aX, int aY, int aZ) {
        return this.mWorld == null || this.mWorld.getBlock(aX, aY, aZ).isAir((IBlockAccess)this.mWorld, aX, aY, aZ);
    }

    @Override
    public BiomeGenBase getBiome(int aX, int aZ) {
        return this.mWorld == null ? null : this.mWorld.getBiomeGenForCoords(aX, aZ);
    }

    @Override
    public TileEntity getTileEntity(ChunkCoordinates aCoords) {
        return this.mWorld == null ? null : this.mWorld.getTileEntity(aCoords.posX, aCoords.posY, aCoords.posZ);
    }

    @Override
    public Block getBlock(ChunkCoordinates aCoords) {
        return this.mWorld == null ? CS.NB : this.mWorld.getBlock(aCoords.posX, aCoords.posY, aCoords.posZ);
    }

    @Override
    public byte getMetaData(ChunkCoordinates aCoords) {
        return this.mWorld == null ? (byte)0 : UT.Code.bind4(this.mWorld.getBlockMetadata(aCoords.posX, aCoords.posY, aCoords.posZ));
    }

    @Override
    public byte getLightLevel(ChunkCoordinates aCoords) {
        return this.mWorld == null ? (byte)0 : UT.Code.bind4((long)this.mWorld.getLightBrightness(aCoords.posX, aCoords.posY, aCoords.posZ) * 15L);
    }

    @Override
    public boolean getOpacity(ChunkCoordinates aCoords) {
        return this.mWorld != null && this.mWorld.getBlock(aCoords.posX, aCoords.posY, aCoords.posZ).isOpaqueCube();
    }

    @Override
    public boolean getSky(ChunkCoordinates aCoords) {
        return this.mWorld == null || this.mWorld.canBlockSeeTheSky(aCoords.posX, aCoords.posY, aCoords.posZ);
    }

    @Override
    public boolean getRain(ChunkCoordinates aCoords) {
        return this.mWorld == null || this.mWorld.getPrecipitationHeight(aCoords.posX, aCoords.posZ) <= aCoords.posY;
    }

    @Override
    public boolean getAir(ChunkCoordinates aCoords) {
        return this.mWorld == null || this.mWorld.getBlock(aCoords.posX, aCoords.posY, aCoords.posZ).isAir((IBlockAccess)this.mWorld, aCoords.posX, aCoords.posY, aCoords.posZ);
    }

    @Override
    public BiomeGenBase getBiome(ChunkCoordinates aCoords) {
        return this.mWorld == null ? null : this.mWorld.getBiomeGenForCoords(aCoords.posX, aCoords.posZ);
    }
}

