/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.connectors;

import gregapi.GT_API_Proxy;
import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityBlock;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.HashSetNoNulls;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.fluid.FluidTankGT;
import gregapi.old.Textures;
import gregapi.oredict.OreDictManager;
import gregapi.oredict.OreDictMaterial;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityAdjacentInventoryUpdatable;
import gregapi.tileentity.ITileEntityQuickObstructionCheck;
import gregapi.tileentity.ITileEntityServerTickPre;
import gregapi.tileentity.connectors.TileEntityBase10ConnectorRendered;
import gregapi.tileentity.data.ITileEntityGibbl;
import gregapi.tileentity.data.ITileEntityProgress;
import gregapi.tileentity.data.ITileEntityTemperature;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.delegate.ITileEntityCanDelegate;
import gregapi.util.CR;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class MultiTileEntityPipeFluid
extends TileEntityBase10ConnectorRendered
implements ITileEntityQuickObstructionCheck,
IFluidHandler,
ITileEntityGibbl,
ITileEntityTemperature,
ITileEntityProgress,
ITileEntityServerTickPre,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_OnEntityCollidedWithBlock {
    public byte[] mLastReceivedFrom = CS.ZL_BYTE;
    public byte mRenderType = 0;
    public long mTemperature = 293L;
    public long mMaxTemperature;
    public long mTransferredAmount = 0L;
    public long mCapacity = 1000L;
    public boolean mGasProof = false;
    public boolean mAcidProof = false;
    public boolean mPlasmaProof = false;
    public boolean mMagicProof = false;
    public boolean mBlocking = false;
    public FluidTankGT[] mTanks = CS.ZL_FT;
    private boolean mHasToAddTimer = true;

    public static void addFluidPipes(int aID, int aCreativeTabID, long aStat, boolean aGasProof, boolean aAcidProof, boolean aPlasmaProof, boolean aMagicProof, boolean aContactDamage, boolean aFlammable, boolean aRecipe, boolean aBlocking, MultiTileEntityRegistry aRegistry, MultiTileEntityBlock aBlock, Class<? extends TileEntity> aClass, OreDictMaterial aMat) {
        MultiTileEntityPipeFluid.addFluidPipes(aID, aCreativeTabID, aStat, aGasProof, aAcidProof, aPlasmaProof, aMagicProof, aContactDamage, aFlammable, aRecipe, aBlocking, aRegistry, aBlock, aClass, (long)((double)aMat.mMeltingPoint * 1.25), aMat);
    }

    public static void addFluidPipes(int aID, int aCreativeTabID, long aStat, boolean aGasProof, boolean aAcidProof, boolean aPlasmaProof, boolean aMagicProof, boolean aContactDamage, boolean aFlammable, boolean aRecipe, boolean aBlocking, MultiTileEntityRegistry aRegistry, MultiTileEntityBlock aBlock, Class<? extends TileEntity> aClass, long aMaxTemperature, OreDictMaterial aMat) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3;
        Object[] objectArray4;
        Object[] objectArray5;
        String string = "Tiny " + aMat.getLocal() + " Fluid Pipe";
        byte by = aMat.mToolQuality;
        NBTTagCompound nBTTagCompound = UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(aBlocking ? 2.0f : 1.0f), "gt.resistance", Float.valueOf(aBlocking ? 6.0f : 2.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PX_P[4]), "gt.contactdamage", aContactDamage, "gt.tankcap", aStat, "gt.opaque", aBlocking, "gt.gasproof", aGasProof, "gt.acidproof", aAcidProof, "gt.plasmaproof", aPlasmaProof, "gt.magicproof", aMagicProof, "gt.flammability", aFlammable ? 150 : 0, "gt.temperature", aMaxTemperature, "gt.tankcount", 1);
        if (aRecipe) {
            Object[] objectArray6 = new Object[4];
            objectArray6[0] = "sP ";
            objectArray6[1] = "wzh";
            objectArray6[2] = Character.valueOf('P');
            objectArray5 = objectArray6;
            objectArray6[3] = OP.plateCurved.dat(aMat);
        } else {
            objectArray5 = CS.ZL;
        }
        OreDictManager.INSTANCE.setTarget_(OP.pipeTiny, aMat, aRegistry.add(string, "Fluid Pipes", aID, aCreativeTabID, aClass, by, 64, aBlock, nBTTagCompound, objectArray5), true, false, true);
        String string2 = "Small " + aMat.getLocal() + " Fluid Pipe";
        byte by2 = aMat.mToolQuality;
        NBTTagCompound nBTTagCompound2 = UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(aBlocking ? 2.0f : 1.0f), "gt.resistance", Float.valueOf(aBlocking ? 6.0f : 2.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PX_P[6]), "gt.contactdamage", aContactDamage, "gt.tankcap", aStat * 2L, "gt.opaque", aBlocking, "gt.gasproof", aGasProof, "gt.acidproof", aAcidProof, "gt.plasmaproof", aPlasmaProof, "gt.magicproof", aMagicProof, "gt.flammability", aFlammable ? 150 : 0, "gt.temperature", aMaxTemperature, "gt.tankcount", 1);
        if (aRecipe) {
            Object[] objectArray7 = new Object[4];
            objectArray7[0] = " P ";
            objectArray7[1] = "wzh";
            objectArray7[2] = Character.valueOf('P');
            objectArray4 = objectArray7;
            objectArray7[3] = OP.plateCurved.dat(aMat);
        } else {
            objectArray4 = CS.ZL;
        }
        OreDictManager.INSTANCE.setTarget_(OP.pipeSmall, aMat, aRegistry.add(string2, "Fluid Pipes", aID + 1, aCreativeTabID, aClass, by2, 64, aBlock, nBTTagCompound2, objectArray4), true, false, true);
        String string3 = aMat.getLocal() + " Fluid Pipe";
        byte by3 = aMat.mToolQuality;
        NBTTagCompound nBTTagCompound3 = UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(aBlocking ? 2.0f : 1.0f), "gt.resistance", Float.valueOf(aBlocking ? 6.0f : 2.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PX_P[8]), "gt.contactdamage", aContactDamage, "gt.tankcap", aStat * 6L, "gt.opaque", aBlocking, "gt.gasproof", aGasProof, "gt.acidproof", aAcidProof, "gt.plasmaproof", aPlasmaProof, "gt.magicproof", aMagicProof, "gt.flammability", aFlammable ? 150 : 0, "gt.temperature", aMaxTemperature, "gt.tankcount", 1);
        if (aRecipe) {
            Object[] objectArray8 = new Object[4];
            objectArray8[0] = "PPP";
            objectArray8[1] = "wzh";
            objectArray8[2] = Character.valueOf('P');
            objectArray3 = objectArray8;
            objectArray8[3] = OP.plateCurved.dat(aMat);
        } else {
            objectArray3 = CS.ZL;
        }
        OreDictManager.INSTANCE.setTarget_(OP.pipeMedium, aMat, aRegistry.add(string3, "Fluid Pipes", aID + 2, aCreativeTabID, aClass, by3, 32, aBlock, nBTTagCompound3, objectArray3), true, false, true);
        String string4 = "Large " + aMat.getLocal() + " Fluid Pipe";
        byte by4 = aMat.mToolQuality;
        NBTTagCompound nBTTagCompound4 = UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(aBlocking ? 2.0f : 1.0f), "gt.resistance", Float.valueOf(aBlocking ? 6.0f : 2.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PX_P[12]), "gt.contactdamage", aContactDamage, "gt.tankcap", aStat * 12L, "gt.opaque", aBlocking, "gt.gasproof", aGasProof, "gt.acidproof", aAcidProof, "gt.plasmaproof", aPlasmaProof, "gt.magicproof", aMagicProof, "gt.flammability", aFlammable ? 150 : 0, "gt.temperature", aMaxTemperature, "gt.tankcount", 1);
        if (aRecipe) {
            Object[] objectArray9 = new Object[5];
            objectArray9[0] = "PPP";
            objectArray9[1] = "wzh";
            objectArray9[2] = "PPP";
            objectArray9[3] = Character.valueOf('P');
            objectArray2 = objectArray9;
            objectArray9[4] = OP.plateCurved.dat(aMat);
        } else {
            objectArray2 = CS.ZL;
        }
        OreDictManager.INSTANCE.setTarget_(OP.pipeLarge, aMat, aRegistry.add(string4, "Fluid Pipes", aID + 3, aCreativeTabID, aClass, by4, 16, aBlock, nBTTagCompound4, objectArray2), true, false, true);
        String string5 = "Huge " + aMat.getLocal() + " Fluid Pipe";
        byte by5 = aMat.mToolQuality;
        NBTTagCompound nBTTagCompound5 = UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(aBlocking ? 2.0f : 1.0f), "gt.resistance", Float.valueOf(aBlocking ? 6.0f : 2.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PX_P[16]), "gt.contactdamage", aContactDamage, "gt.tankcap", aStat * 24L, "gt.opaque", aBlocking, "gt.gasproof", aGasProof, "gt.acidproof", aAcidProof, "gt.plasmaproof", aPlasmaProof, "gt.magicproof", aMagicProof, "gt.flammability", aFlammable ? 150 : 0, "gt.temperature", aMaxTemperature, "gt.tankcount", 1);
        if (aRecipe) {
            Object[] objectArray10 = new Object[5];
            objectArray10[0] = "PPP";
            objectArray10[1] = "wzh";
            objectArray10[2] = "PPP";
            objectArray10[3] = Character.valueOf('P');
            objectArray = objectArray10;
            objectArray10[4] = OP.plateDouble.dat(aMat);
        } else {
            objectArray = CS.ZL;
        }
        OreDictManager.INSTANCE.setTarget_(OP.pipeHuge, aMat, aRegistry.add(string5, "Fluid Pipes", aID + 4, aCreativeTabID, aClass, by5, 16, aBlock, nBTTagCompound5, objectArray), true, false, true);
        OreDictManager.INSTANCE.setTarget_(OP.pipeQuadruple, aMat, aRegistry.add("Quadruple " + aMat.getLocal() + " Fluid Pipe", "Fluid Pipes", aID + 5, aCreativeTabID, aClass, aMat.mToolQuality, 16, aBlock, UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(aBlocking ? 2.0f : 1.0f), "gt.resistance", Float.valueOf(aBlocking ? 6.0f : 2.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PX_P[16]), "gt.contactdamage", aContactDamage, "gt.tankcap", aStat * 6L, "gt.opaque", aBlocking, "gt.gasproof", aGasProof, "gt.acidproof", aAcidProof, "gt.plasmaproof", aPlasmaProof, "gt.magicproof", aMagicProof, "gt.flammability", aFlammable ? 150 : 0, "gt.temperature", aMaxTemperature, "gt.tankcount", 4), "PP", "PP", Character.valueOf('P'), OP.pipeMedium.dat(aMat)), true, false, true);
        OreDictManager.INSTANCE.setTarget_(OP.pipeNonuple, aMat, aRegistry.add("Nonuple " + aMat.getLocal() + " Fluid Pipe", "Fluid Pipes", aID + 6, aCreativeTabID, aClass, aMat.mToolQuality, 16, aBlock, UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(aBlocking ? 2.0f : 1.0f), "gt.resistance", Float.valueOf(aBlocking ? 6.0f : 2.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PX_P[16]), "gt.contactdamage", aContactDamage, "gt.tankcap", aStat * 2L, "gt.opaque", aBlocking, "gt.gasproof", aGasProof, "gt.acidproof", aAcidProof, "gt.plasmaproof", aPlasmaProof, "gt.magicproof", aMagicProof, "gt.flammability", aFlammable ? 150 : 0, "gt.temperature", aMaxTemperature, "gt.tankcount", 9), "PPP", "PPP", "PPP", Character.valueOf('P'), OP.pipeSmall.dat(aMat)), true, false, true);
        CR.shapeless(aRegistry.getItem(aID + 2, 4L), CR.DEF_NCC, new Object[]{aRegistry.getItem(aID + 5)});
        CR.shapeless(aRegistry.getItem(aID + 1, 9L), CR.DEF_NCC, new Object[]{aRegistry.getItem(aID + 6)});
    }

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.hasKey("gt.mtransfer")) {
            this.mTransferredAmount = aNBT.getLong("gt.mtransfer");
        }
        if (aNBT.hasKey("gt.piperender")) {
            this.mRenderType = aNBT.getByte("gt.piperender");
        }
        if (aNBT.hasKey("gt.opaque")) {
            this.mBlocking = aNBT.getBoolean("gt.opaque");
        }
        if (aNBT.hasKey("gt.gasproof")) {
            this.mGasProof = aNBT.getBoolean("gt.gasproof");
        }
        if (aNBT.hasKey("gt.acidproof")) {
            this.mAcidProof = aNBT.getBoolean("gt.acidproof");
        }
        if (aNBT.hasKey("gt.magicproof")) {
            this.mMagicProof = aNBT.getBoolean("gt.magicproof");
        }
        if (aNBT.hasKey("gt.plasmaproof")) {
            this.mPlasmaProof = aNBT.getBoolean("gt.plasmaproof");
        }
        if (aNBT.hasKey("gt.tankcap")) {
            this.mCapacity = aNBT.getLong("gt.tankcap");
        }
        if (aNBT.hasKey("gt.temperature")) {
            this.mMaxTemperature = aNBT.getLong("gt.temperature");
        }
        if (aNBT.hasKey("gt.tankcount")) {
            this.mTanks = new FluidTankGT[Math.max(1, aNBT.getInteger("gt.tankcount"))];
            this.mLastReceivedFrom = new byte[this.mTanks.length];
            for (int i = 0; i < this.mTanks.length; ++i) {
                this.mTanks[i] = new FluidTankGT(aNBT, "gt.tank." + i, this.mCapacity).setIndex(i);
                this.mLastReceivedFrom[i] = aNBT.getByte("gt.mlast." + i);
            }
        } else {
            this.mTanks = new FluidTankGT((NBTTagCompound)aNBT, (String)"gt.tank.0", (long)this.mCapacity).AS_ARRAY;
            this.mLastReceivedFrom = new byte[]{aNBT.getByte("gt.mlast.0")};
        }
        if (this.worldObj != null && this.isServerSide() && this.mHasToAddTimer) {
            if (WD.even(this)) {
                GT_API_Proxy.SERVER_TICK_PRE.add(this);
            } else {
                GT_API_Proxy.SERVER_TICK_PR2.add(this);
            }
            this.mHasToAddTimer = false;
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        for (int i = 0; i < this.mTanks.length; ++i) {
            this.mTanks[i].writeToNBT(aNBT, "gt.tank." + i);
            aNBT.setByte("gt.mlast." + i, this.mLastReceivedFrom[i]);
        }
        UT.NBT.setNumber(aNBT, "gt.mtransfer", this.mTransferredAmount);
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L) {
            return rReturn;
        }
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("plunger")) {
            return CS.GarbageGT.trash(this.mTanks);
        }
        if (aTool.equals("thermometer")) {
            if (aChatReturn != null) {
                aChatReturn.add("Temperature: " + this.mTemperature + "K");
            }
            return 10000L;
        }
        if (aTool.equals("magnifyingglass") && !this.isCovered(UT.Code.getSideWrenching(aSide, aHitX, aHitY, aHitZ))) {
            if (aChatReturn != null) {
                boolean tPipeEmpty = true;
                for (FluidTankGT tTank : this.mTanks) {
                    if (tTank.isEmpty()) continue;
                    aChatReturn.add(tTank.content());
                    tPipeEmpty = false;
                }
                HashSetNoNulls<MultiTileEntityPipeFluid> tDone = new HashSetNoNulls<MultiTileEntityPipeFluid>(false, this);
                HashSetNoNulls<MultiTileEntityPipeFluid> tNow = new HashSetNoNulls<MultiTileEntityPipeFluid>(false, this);
                HashSetNoNulls<Object> tNext = new HashSetNoNulls();
                ArrayListNoNulls<FluidTankGT> tFluids = new ArrayListNoNulls<FluidTankGT>();
                while (true) {
                    for (MultiTileEntityPipeFluid tPipe : tNow) {
                        for (FluidTankGT tTank : tPipe.mTanks) {
                            if (tTank.isEmpty()) continue;
                            boolean temp = true;
                            for (FluidTankGT tFluid : tFluids) {
                                if (!tFluid.contains(tTank.get())) continue;
                                tFluid.add(tTank.amount());
                                temp = false;
                                break;
                            }
                            if (!temp) continue;
                            tFluids.add(new FluidTankGT().setFluid(tTank));
                        }
                        for (byte tSide : CS.ALL_SIDES_VALID) {
                            if (!tPipe.connected(tSide)) continue;
                            DelegatorTileEntity<TileEntity> tDelegator = tPipe.getAdjacentTileEntity(tSide);
                            if (!(tDelegator.mTileEntity instanceof MultiTileEntityPipeFluid) || !tDone.add((MultiTileEntityPipeFluid)tDelegator.mTileEntity)) continue;
                            tNext.add((MultiTileEntityPipeFluid)tDelegator.mTileEntity);
                        }
                    }
                    if (tNext.isEmpty()) break;
                    HashSetNoNulls<MultiTileEntityPipeFluid> tSwap = tNow;
                    tNow = tNext;
                    tNext = tSwap;
                    tNext.clear();
                }
                if (tFluids.isEmpty()) {
                    aChatReturn.add("=== This Fluid Pipe Network is empty ===");
                } else {
                    if (tPipeEmpty) {
                        aChatReturn.add("This particular Pipe Segment is currently empty");
                    }
                    aChatReturn.add("=== This Fluid Pipe Network contains: ===");
                    for (FluidTankGT tFluid : tFluids) {
                        aChatReturn.add(tFluid.content());
                    }
                }
            }
            return this.mTanks.length;
        }
        return 0L;
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.pipe.stats.bandwidth") + UT.Code.makeString(this.mCapacity / 2L) + " L/t");
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.pipe.stats.capacity") + UT.Code.makeString(this.mCapacity) + " L");
        if (this.mTanks.length > 1) {
            aList.add(LH.Chat.CYAN + LH.get("gt.lang.pipe.stats.amount") + this.mTanks.length);
        }
        aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.meltdown") + " (" + this.mMaxTemperature + " K)");
        if (this.mGasProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.gas"));
        }
        if (this.mAcidProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.acid"));
        }
        if (this.mPlasmaProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.plasma"));
        }
        if (this.mMagicProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.magic"));
        }
        if (this.mContactDamage) {
            aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.contact"));
        }
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.magnifyingglass.to.detail"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public void onUnregisterPre() {
        this.mHasToAddTimer = true;
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide && this.mHasToAddTimer) {
            if (WD.even(this)) {
                GT_API_Proxy.SERVER_TICK_PRE.add(this);
            } else {
                GT_API_Proxy.SERVER_TICK_PR2.add(this);
            }
            this.mHasToAddTimer = false;
        }
    }

    @Override
    public void onCoordinateChange() {
        super.onCoordinateChange();
        GT_API_Proxy.SERVER_TICK_PRE.remove(this);
        GT_API_Proxy.SERVER_TICK_PR2.remove(this);
        this.onUnregisterPre();
    }

    @Override
    public void onServerTickPre(boolean aFirst) {
        this.mTransferredAmount = 0L;
        DelegatorTileEntity[] tAdjacentPipes = new DelegatorTileEntity[6];
        DelegatorTileEntity[] tAdjacentTanks = new DelegatorTileEntity[6];
        DelegatorTileEntity[] tAdjacentOther = new DelegatorTileEntity[6];
        for (byte tSide : CS.ALL_SIDES_VALID) {
            DelegatorTileEntity<TileEntity> tTileEntity;
            if (!this.canEmitFluidsTo(tSide) || (tTileEntity = this.getAdjacentTileEntity(tSide)) == null) continue;
            if (tTileEntity.mTileEntity instanceof MultiTileEntityPipeFluid) {
                tAdjacentPipes[tSide] = new DelegatorTileEntity<MultiTileEntityPipeFluid>((MultiTileEntityPipeFluid)tTileEntity.mTileEntity, tTileEntity);
                continue;
            }
            if (tTileEntity.mTileEntity instanceof IFluidHandler) {
                tAdjacentTanks[tSide] = new DelegatorTileEntity<IFluidHandler>((IFluidHandler)tTileEntity.mTileEntity, tTileEntity);
                continue;
            }
            tAdjacentOther[tSide] = tTileEntity;
        }
        boolean tCheckTemperature = true;
        for (FluidTankGT tTank : this.mTanks) {
            FluidStack tFluid = tTank.get();
            if (tFluid != null && tFluid.amount > 0) {
                this.mTemperature = tCheckTemperature ? FL.temperature(tFluid) : Math.max(this.mTemperature, FL.temperature(tFluid));
                tCheckTemperature = false;
                if (!this.mMagicProof && FL.magic(tFluid)) {
                    this.mTransferredAmount += CS.GarbageGT.trash(tTank, FL.gas(tFluid) ? 16L : 4L);
                    UT.Sounds.send("random.fizz", this, false);
                    try {
                        for (Entity tEntity : this.worldObj.getEntitiesWithinAABB(Entity.class, this.box(-3.0, -3.0, -3.0, 4.0, 4.0, 4.0))) {
                            UT.Entities.applyPotion(tEntity, Potion.poison, 1200, 1, false);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace(CS.ERR);
                    }
                    if (this.rng(100) == 0) {
                        CS.GarbageGT.trash(this.mTanks);
                        WD.set(this.worldObj, this.xCoord, this.yCoord, this.zCoord, FL.gas(tFluid) ? IL.TC_Flux_Gas.block() : IL.TC_Flux_Goo.block(), IL.TC_Flux_Goo.exists() ? 7L : 0L, 3L);
                        return;
                    }
                }
                if (!this.mGasProof && FL.gas(tFluid)) {
                    this.mTransferredAmount += CS.GarbageGT.trash(tTank, 8L);
                    UT.Sounds.send("random.fizz", this, false);
                    try {
                        for (Entity tEntity : this.worldObj.getEntitiesWithinAABB(Entity.class, this.box(-2.0, -2.0, -2.0, 3.0, 3.0, 3.0))) {
                            UT.Entities.applyTemperatureDamage(tEntity, this.mTemperature, 2.0f, 10.0f);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace(CS.ERR);
                    }
                }
                if (!this.mPlasmaProof && FL.plasma(tFluid)) {
                    this.mTransferredAmount += CS.GarbageGT.trash(tTank, 64L);
                    UT.Sounds.send("random.fizz", this, false);
                    try {
                        for (Entity tEntity : this.worldObj.getEntitiesWithinAABB(Entity.class, this.box(-2.0, -2.0, -2.0, 3.0, 3.0, 3.0))) {
                            UT.Entities.applyTemperatureDamage(tEntity, this.mTemperature, 2.0f, 10.0f);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace(CS.ERR);
                    }
                }
                if (!this.mAcidProof && FL.acid(tFluid)) {
                    this.mTransferredAmount += CS.GarbageGT.trash(tTank, 16L);
                    UT.Sounds.send("random.fizz", this, false);
                    try {
                        for (Entity tEntity : this.worldObj.getEntitiesWithinAABB(Entity.class, this.box(-1.0, -1.0, -1.0, 2.0, 2.0, 2.0))) {
                            UT.Entities.applyChemDamage(tEntity, 2.0f);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace(CS.ERR);
                    }
                    if (this.rng(100) == 0) {
                        CS.GarbageGT.trash(this.mTanks);
                        this.setToAir();
                        return;
                    }
                }
            }
            if (this.mTemperature > this.mMaxTemperature) {
                this.setOnFire();
                if (this.rng(100) == 0) {
                    CS.GarbageGT.trash(this.mTanks);
                    this.setToFire();
                    return;
                }
            }
            if (tTank.has()) {
                this.distribute(tTank, tAdjacentPipes, tAdjacentTanks, tAdjacentOther);
            }
            this.mLastReceivedFrom[tTank.mIndex] = 0;
        }
        if (tCheckTemperature) {
            long tEnvTemp = WD.envTemp(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
            if (this.mTemperature < tEnvTemp) {
                ++this.mTemperature;
            } else if (this.mTemperature > tEnvTemp) {
                --this.mTemperature;
            }
        }
    }

    public void distribute(FluidTankGT aTank, DelegatorTileEntity<MultiTileEntityPipeFluid>[] aAdjacentPipes, DelegatorTileEntity<IFluidHandler>[] aAdjacentTanks, DelegatorTileEntity<TileEntity>[] aAdjacentOther) {
        block5: for (byte tSide : CS.ALL_SIDES_VALID) {
            Block tBlock;
            if (aAdjacentOther[tSide] == null || this.isCovered(tSide) && this.mCovers.mBehaviours[tSide].interceptFluidDrain(tSide, this.mCovers, tSide, aTank.get()) || (tBlock = aAdjacentOther[tSide].getBlock()) != Blocks.cauldron && !(tBlock instanceof BlockCauldron) || !aTank.has(334L) || !FL.water(aTank.get())) continue;
            switch (aAdjacentOther[tSide].getMetaData()) {
                case 0: {
                    if (aTank.drainAll(1000L)) {
                        aAdjacentOther[tSide].setMetaData(3);
                        continue block5;
                    }
                    if (aTank.drainAll(667L)) {
                        aAdjacentOther[tSide].setMetaData(2);
                        continue block5;
                    }
                    if (!aTank.drainAll(334L)) continue block5;
                    aAdjacentOther[tSide].setMetaData(1);
                    continue block5;
                }
                case 1: {
                    if (aTank.drainAll(667L)) {
                        aAdjacentOther[tSide].setMetaData(3);
                        continue block5;
                    }
                    if (!aTank.drainAll(334L)) continue block5;
                    aAdjacentOther[tSide].setMetaData(2);
                    continue block5;
                }
                case 2: {
                    if (!aTank.drainAll(334L)) continue block5;
                    aAdjacentOther[tSide].setMetaData(3);
                }
            }
        }
        if (aTank.isEmpty()) {
            return;
        }
        ArrayListNoNulls<DelegatorTileEntity<IFluidHandler>> tTanks = new ArrayListNoNulls<DelegatorTileEntity<IFluidHandler>>();
        ArrayListNoNulls<FluidTankGT> tPipes = new ArrayListNoNulls<FluidTankGT>();
        long tAmount = aTank.amount();
        int tTargetCount = 1;
        for (byte tSide : CS.ALL_SIDES_VALID) {
            if (CS.FACE_CONNECTED[tSide][this.mLastReceivedFrom[aTank.mIndex]] || !this.canEmitFluidsTo(tSide) || this.isCovered(tSide) && this.mCovers.mBehaviours[tSide].interceptFluidDrain(tSide, this.mCovers, tSide, aTank.get())) continue;
            if (aAdjacentPipes[tSide] != null) {
                FluidTankGT tTank = (FluidTankGT)((MultiTileEntityPipeFluid)aAdjacentPipes[tSide].mTileEntity).getFluidTankFillable(aAdjacentPipes[tSide].mSideOfTileEntity, aTank.get());
                if (tTank == null || tTank.amount() >= aTank.amount()) continue;
                int n = tTank.mIndex;
                ((MultiTileEntityPipeFluid)aAdjacentPipes[tSide].mTileEntity).mLastReceivedFrom[n] = (byte)(((MultiTileEntityPipeFluid)aAdjacentPipes[tSide].mTileEntity).mLastReceivedFrom[n] | CS.SBIT[aAdjacentPipes[tSide].mSideOfTileEntity]);
                tPipes.add(this.rng(tPipes.size() + 1), tTank);
                tAmount += tTank.amount();
                ++tTargetCount;
                continue;
            }
            if (aAdjacentTanks[tSide] == null || ((IFluidHandler)aAdjacentTanks[tSide].mTileEntity).fill(aAdjacentTanks[tSide].getForgeSideOfTileEntity(), aTank.make(1), false) <= 0 && ((IFluidHandler)aAdjacentTanks[tSide].mTileEntity).fill(aAdjacentTanks[tSide].getForgeSideOfTileEntity(), aTank.get(Long.MAX_VALUE), false) <= 0) continue;
            tTanks.add(this.rng(tTanks.size() + 1), aAdjacentTanks[tSide]);
            ++tTargetCount;
        }
        if (tTargetCount <= 1) {
            return;
        }
        tAmount = UT.Code.divup(tAmount, tTargetCount);
        Object object = tPipes.iterator();
        while (object.hasNext()) {
            FluidTankGT fluidTankGT = (FluidTankGT)object.next();
            this.mTransferredAmount += aTank.remove(fluidTankGT.add(aTank.amount(tAmount - fluidTankGT.amount()), aTank.get()));
        }
        if (aTank.isEmpty()) {
            return;
        }
        for (DelegatorTileEntity delegatorTileEntity : tTanks) {
            this.mTransferredAmount += aTank.remove(FL.fill(delegatorTileEntity, aTank.get(tAmount), true));
        }
        if (aTank.isEmpty()) {
            return;
        }
        if (tPipes.isEmpty()) {
            return;
        }
        tAmount = (aTank.amount() - this.mCapacity / 2L) / (long)tPipes.size();
        if (tAmount > 0L) {
            for (FluidTankGT fluidTankGT : tPipes) {
                this.mTransferredAmount += aTank.remove(fluidTankGT.add(aTank.amount(tAmount), aTank.get()));
            }
        }
    }

    @Override
    public boolean breakBlock() {
        for (byte tSide : CS.ALL_SIDES_VALID) {
            if (!this.canEmitFluidsTo(tSide)) continue;
            DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(tSide);
            for (FluidTankGT tTank : this.mTanks) {
                if (!tTank.has() || this.isCovered(tSide) && this.mCovers.mBehaviours[tSide].interceptFluidDrain(tSide, this.mCovers, tSide, tTank.get())) continue;
                this.mTransferredAmount += FL.move(tTank, tDelegator);
            }
        }
        CS.GarbageGT.trash(this.mTanks);
        return super.breakBlock();
    }

    @Override
    public void onConnectionChange(byte aPreviousConnections) {
        for (byte tSide : CS.ALL_SIDES_VALID) {
            DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(tSide);
            if (!(tDelegator.mTileEntity instanceof ITileEntityAdjacentInventoryUpdatable)) continue;
            ((ITileEntityAdjacentInventoryUpdatable)tDelegator.mTileEntity).adjacentInventoryUpdated(tDelegator.mSideOfTileEntity, this);
        }
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    @Override
    public boolean isObstructingBlockAt(byte aSide) {
        return this.mBlocking;
    }

    @Override
    public void onEntityCollidedWithBlock(Entity aEntity) {
        if (this.mContactDamage && !this.mFoamDried) {
            UT.Entities.applyTemperatureDamage(aEntity, this.mTemperature, 1.0f, 5.0f);
        }
    }

    @Override
    protected IFluidTank getFluidTankFillable2(byte aSide, FluidStack aFluidToFill) {
        if (CS.SIDES_VALID[aSide] && !this.canAcceptFluidsFrom(aSide)) {
            return null;
        }
        for (FluidTankGT tTank : this.mTanks) {
            if (!tTank.contains(aFluidToFill)) continue;
            return tTank;
        }
        for (FluidTankGT tTank : this.mTanks) {
            if (!tTank.isEmpty()) continue;
            return tTank;
        }
        return null;
    }

    @Override
    protected IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        if (CS.SIDES_VALID[aSide] && !this.canEmitFluidsTo(aSide)) {
            return null;
        }
        for (FluidTankGT tTank : this.mTanks) {
            if (!tTank.contains(aFluidToDrain)) continue;
            return tTank;
        }
        return null;
    }

    @Override
    protected IFluidTank[] getFluidTanks2(byte aSide) {
        return this.mTanks;
    }

    @Override
    public int fill(ForgeDirection aDirection, FluidStack aFluid, boolean aDoFill) {
        if (aFluid == null || aFluid.amount <= 0) {
            return 0;
        }
        FluidTankGT tTank = (FluidTankGT)this.getFluidTankFillable(UT.Code.side(aDirection), aFluid);
        if (tTank == null) {
            return 0;
        }
        int rFilledAmount = tTank.fill(aFluid, aDoFill);
        if (aDoFill) {
            if (rFilledAmount > 0) {
                this.updateInventory();
            }
            int n = tTank.mIndex;
            this.mLastReceivedFrom[n] = (byte)(this.mLastReceivedFrom[n] | CS.SBIT[UT.Code.side(aDirection)]);
        }
        return rFilledAmount;
    }

    @Override
    public boolean canConnect(byte aSide, DelegatorTileEntity<TileEntity> aDelegator) {
        Block tBlock;
        if (aDelegator.mTileEntity instanceof IFluidHandler) {
            if (aDelegator.mTileEntity instanceof ITileEntityCanDelegate) {
                return true;
            }
            return UT.Code.exists(0, ((IFluidHandler)aDelegator.mTileEntity).getTankInfo(aDelegator.getForgeSideOfTileEntity()));
        }
        return this.mCapacity >= 334L && ((tBlock = aDelegator.getBlock()) == Blocks.cauldron || tBlock instanceof BlockCauldron);
    }

    public boolean canEmitFluidsTo(byte aSide) {
        return this.connected(aSide);
    }

    public boolean canAcceptFluidsFrom(byte aSide) {
        return this.connected(aSide);
    }

    @Override
    public long getGibblValue(byte aSide) {
        long rAmount = 0L;
        for (FluidTankGT tTank : this.mTanks) {
            rAmount += tTank.amount();
        }
        return rAmount;
    }

    @Override
    public long getGibblMax(byte aSide) {
        return this.mCapacity * (long)this.mTanks.length;
    }

    @Override
    public long getProgressValue(byte aSide) {
        return this.mTransferredAmount;
    }

    @Override
    public long getProgressMax(byte aSide) {
        return this.mCapacity * (long)this.mTanks.length;
    }

    @Override
    public long getTemperatureValue(byte aSide) {
        return this.mTemperature;
    }

    @Override
    public long getTemperatureMax(byte aSide) {
        return this.mMaxTemperature;
    }

    @Override
    public ITexture getTextureSide(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        BlockTextureDefault tBase = BlockTextureDefault.get(this.mMaterial, this.getIconIndexSide(aSide, aConnections, aDiameter, aRenderPass), this.mIsGlowing, this.mRGBa);
        switch (this.mRenderType) {
            case 1: {
                return BlockTextureMulti.get(tBase, BlockTextureDefault.get(Textures.BlockIcons.PIPE_RESTRICTOR));
            }
        }
        return tBase;
    }

    @Override
    public ITexture getTextureConnected(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        BlockTextureDefault tBase = BlockTextureDefault.get(this.mMaterial, this.getIconIndexConnected(aSide, aConnections, aDiameter, aRenderPass), this.mIsGlowing, this.mRGBa);
        switch (this.mRenderType) {
            case 1: {
                return BlockTextureMulti.get(tBase, BlockTextureDefault.get(Textures.BlockIcons.PIPE_RESTRICTOR));
            }
        }
        return tBase;
    }

    @Override
    public int getIconIndexSide(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return CS.IconsGT.INDEX_BLOCK_PIPE_SIDE;
    }

    @Override
    public int getIconIndexConnected(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return this.mTanks.length >= 9 ? OP.pipeNonuple.mIconIndexBlock : (this.mTanks.length >= 4 ? OP.pipeQuadruple.mIconIndexBlock : (aDiameter < 0.37f ? OP.pipeTiny.mIconIndexBlock : (aDiameter < 0.49f ? OP.pipeSmall.mIconIndexBlock : (aDiameter < 0.74f ? OP.pipeMedium.mIconIndexBlock : (aDiameter < 0.99f ? OP.pipeLarge.mIconIndexBlock : OP.pipeHuge.mIconIndexBlock)))));
    }

    @Override
    public Collection<TagData> getConnectorTypes(byte aSide) {
        return TD.Connectors.PIPE_FLUID.AS_LIST;
    }

    @Override
    public String getFacingTool() {
        return "wrench";
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.connector.pipe.fluid";
    }
}

