/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.base;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityBlockInternal;
import gregapi.data.CS;
import gregapi.data.MT;
import gregapi.item.IItemColorableRGB;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.oredict.OreDictMaterial;
import gregapi.tileentity.ITileEntityDecolorable;
import gregapi.tileentity.base.TileEntityBase06Covers;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileEntityBase07Paintable
extends TileEntityBase06Covers
implements IItemColorableRGB,
ITileEntityDecolorable,
IMultiTileEntity.IMTE_GetSubItems,
IMultiTileEntity.IMTE_GetExplosionResistance,
IMultiTileEntity.IMTE_GetBlockHardness,
IMultiTileEntity.IMTE_GetLightOpacity,
IMultiTileEntity.IMTE_SyncDataByte,
IMultiTileEntity.IMTE_SyncDataByteArray {
    protected boolean mIsPainted = false;
    protected int mRGBa = 0xFFFFFF;
    protected int mFlammability = 0;
    protected float mHardness = 1.0f;
    protected float mResistance = 3.0f;
    protected OreDictMaterial mMaterial = MT.NULL;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.hasKey("gt.color")) {
            this.mRGBa = aNBT.getInteger("gt.color");
        }
        if (aNBT.hasKey("gt.painted")) {
            this.mIsPainted = aNBT.getBoolean("gt.painted");
        }
        if (aNBT.hasKey("gt.hardness")) {
            this.mHardness = aNBT.getFloat("gt.hardness");
        }
        if (aNBT.hasKey("gt.resistance")) {
            this.mResistance = aNBT.getFloat("gt.resistance");
        }
        if (aNBT.hasKey("gt.flammability")) {
            this.mFlammability = aNBT.getInteger("gt.flammability");
        }
        if (aNBT.hasKey("gt.material")) {
            this.mMaterial = OreDictMaterial.get(aNBT.getString("gt.material"));
        }
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        return aSendAll ? this.getClientDataPacketByteArray(aSendAll, (byte)UT.Code.getR(this.mRGBa), (byte)UT.Code.getG(this.mRGBa), (byte)UT.Code.getB(this.mRGBa), this.getVisualData()) : this.getClientDataPacketByte(aSendAll, this.getVisualData());
    }

    @Override
    public boolean receiveDataByte(byte aData, INetworkHandler aNetworkHandler) {
        this.setVisualData(aData);
        return true;
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        this.mRGBa = UT.Code.getRGBInt(new short[]{UT.Code.unsignB(aData[0]), UT.Code.unsignB(aData[1]), UT.Code.unsignB(aData[2])});
        this.setVisualData(aData[3]);
        return true;
    }

    @Override
    public boolean unpaint() {
        if (this.mIsPainted) {
            this.mIsPainted = false;
            this.mRGBa = UT.Code.getRGBInt(this.mMaterial.fRGBaSolid);
            this.updateClientData();
            return true;
        }
        return false;
    }

    @Override
    public boolean isPainted() {
        return this.mIsPainted || this.worldObj != null && this.isClientSide() && UT.Code.getRGBInt(this.mMaterial.fRGBaSolid) != this.mRGBa;
    }

    @Override
    public boolean paint(int aRGB) {
        if (aRGB != this.mRGBa) {
            this.mRGBa = aRGB;
            this.mIsPainted = true;
            return true;
        }
        return false;
    }

    @Override
    public int getPaint() {
        return this.mRGBa;
    }

    @Override
    public boolean canRecolorItem(ItemStack aStack) {
        return true;
    }

    @Override
    public boolean canDecolorItem(ItemStack aStack) {
        return this.mIsPainted;
    }

    @Override
    public boolean recolorItem(ItemStack aStack, int aRGB) {
        if (this.paint((this.isPainted() ? UT.Code.mixRGBInt(aRGB, this.getPaint()) : aRGB) & 0xFFFFFF)) {
            UT.NBT.set(aStack, this.writeItemNBT(aStack.hasTagCompound() ? aStack.getTagCompound() : UT.NBT.make()));
            return true;
        }
        return false;
    }

    @Override
    public boolean decolorItem(ItemStack aStack) {
        if (this.unpaint()) {
            if (aStack.hasTagCompound()) {
                aStack.getTagCompound().removeTag("gt.painted");
                aStack.getTagCompound().removeTag("gt.color");
                UT.NBT.set(aStack, this.writeItemNBT(aStack.getTagCompound()));
            } else {
                UT.NBT.set(aStack, this.writeItemNBT(UT.NBT.make()));
            }
            return true;
        }
        return false;
    }

    @Override
    public int getLightOpacity() {
        return 255;
    }

    @Override
    public int getFireSpreadSpeed(byte aSide, boolean aDefault) {
        return this.mFlammability;
    }

    @Override
    public int getFlammability(byte aSide, boolean aDefault) {
        return this.mFlammability;
    }

    @Override
    public float getBlockHardness() {
        return this.mHardness;
    }

    @Override
    public float getExplosionResistance2() {
        return this.mResistance;
    }

    @Override
    public boolean getSubItems(MultiTileEntityBlockInternal aBlock, Item aItem, CreativeTabs aTab, List<ItemStack> aList, short aID) {
        return this.showInCreative();
    }

    public byte getVisualData() {
        return 0;
    }

    public void setVisualData(byte aData) {
    }

    public boolean showInCreative() {
        return CS.SHOW_HIDDEN_MATERIALS || !this.mMaterial.mHidden;
    }
}

