/*
 * Decompiled with CFR 0.152.
 */
package gregapi.render;

import gregapi.data.CS;
import gregapi.render.ITexture;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;

public class BlockTextureMulti
implements ITexture {
    private final ITexture[] mTextures;

    public static BlockTextureMulti get(ITexture ... aTextures) {
        return CS.CODE_CLIENT || CS.CODE_UNCHECKED ? new BlockTextureMulti(aTextures) : null;
    }

    public BlockTextureMulti(ITexture ... aTextures) {
        this.mTextures = aTextures;
    }

    @Override
    public void renderXPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
        for (ITexture tTexture : this.mTextures) {
            if (tTexture == null || !tTexture.isValidTexture()) continue;
            tTexture.renderXPos(aRenderer, aBlock, aX, aY, aZ, aBrightness, aChangedBlockBounds);
        }
    }

    @Override
    public void renderXNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
        for (ITexture tTexture : this.mTextures) {
            if (tTexture == null || !tTexture.isValidTexture()) continue;
            tTexture.renderXNeg(aRenderer, aBlock, aX, aY, aZ, aBrightness, aChangedBlockBounds);
        }
    }

    @Override
    public void renderYPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
        for (ITexture tTexture : this.mTextures) {
            if (tTexture == null || !tTexture.isValidTexture()) continue;
            tTexture.renderYPos(aRenderer, aBlock, aX, aY, aZ, aBrightness, aChangedBlockBounds);
        }
    }

    @Override
    public void renderYNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
        for (ITexture tTexture : this.mTextures) {
            if (tTexture == null || !tTexture.isValidTexture()) continue;
            tTexture.renderYNeg(aRenderer, aBlock, aX, aY, aZ, aBrightness, aChangedBlockBounds);
        }
    }

    @Override
    public void renderZPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
        for (ITexture tTexture : this.mTextures) {
            if (tTexture == null || !tTexture.isValidTexture()) continue;
            tTexture.renderZPos(aRenderer, aBlock, aX, aY, aZ, aBrightness, aChangedBlockBounds);
        }
    }

    @Override
    public void renderZNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
        for (ITexture tTexture : this.mTextures) {
            if (tTexture == null || !tTexture.isValidTexture()) continue;
            tTexture.renderZNeg(aRenderer, aBlock, aX, aY, aZ, aBrightness, aChangedBlockBounds);
        }
    }

    @Override
    public boolean isValidTexture() {
        return this.mTextures.length > 0;
    }
}

