/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes.maps;

import gregapi.code.ItemStackContainer;
import gregapi.code.ItemStackMap;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.OD;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.Recipe;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class RecipeMapScannerVisuals
extends Recipe.RecipeMap {
    public final ItemStackMap<ItemStackContainer, ItemStack> mMappings = new ItemStackMap();

    public RecipeMapScannerVisuals(Collection<Recipe> aRecipeList, String aUnlocalizedName, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aInputFluidCount, long aOutputFluidCount, long aMinimalInputFluids, long aMinimalInputs, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed, boolean aConfigAllowed, boolean aNeedsOutputs, boolean aCombinePower, boolean aUseBucketSizeIn, boolean aUseBucketSizeOut) {
        super(aRecipeList, aUnlocalizedName, aNameLocal, aNameNEI, aProgressBarDirection, aProgressBarAmount, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, aInputFluidCount, aOutputFluidCount, aMinimalInputFluids, aMinimalInputs, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, false, aShowVoltageAmperageInNEI, aNEIAllowed, aConfigAllowed, aNeedsOutputs, aCombinePower, aUseBucketSizeIn, aUseBucketSizeOut);
        this.mMappings.put(Items.flint_and_steel, 32767L, ST.make((Block)Blocks.fire, 1L, 0L));
        this.mMappings.put(Items.reeds, 32767L, ST.make(Blocks.reeds, 1L, 0L));
        this.mMappings.put(Items.snowball, 32767L, ST.make(Blocks.snow, 1L, 0L));
        this.mMappings.put(Items.wheat_seeds, 32767L, ST.make(Blocks.wheat, 1L, 0L));
        this.mMappings.put(Items.wheat, 32767L, ST.make(Blocks.wheat, 1L, 7L));
        this.mMappings.put(Items.carrot, 32767L, ST.make(Blocks.carrots, 1L, 7L));
        this.mMappings.put(Items.poisonous_potato, 32767L, ST.make(Blocks.potatoes, 1L, 0L));
        this.mMappings.put(Items.potato, 32767L, ST.make(Blocks.potatoes, 1L, 7L));
        this.mMappings.put(Items.melon_seeds, 32767L, ST.make(Blocks.melon_stem, 1L, 0L));
        this.mMappings.put(Items.melon, 32767L, ST.make(Blocks.melon_stem, 1L, 7L));
        this.mMappings.put(Items.pumpkin_seeds, 32767L, ST.make(Blocks.pumpkin_stem, 1L, 7L));
        this.mMappings.put(Items.dye, 3L, ST.make(Blocks.cocoa, 1L, 8L));
        this.mMappings.put(Items.string, 32767L, ST.make(Blocks.web, 1L, 0L));
        this.mMappings.put(Items.nether_wart, 32767L, ST.make(Blocks.nether_wart, 1L, 3L));
        this.mMappings.put(Items.comparator, 32767L, ST.make((Block)Blocks.powered_comparator, 1L, 0L));
        this.mMappings.put(Items.repeater, 32767L, ST.make((Block)Blocks.powered_repeater, 1L, 0L));
        this.mMappings.put(Items.bed, 32767L, ST.make(Blocks.bed, 1L, 0L));
        this.mMappings.put(Items.iron_door, 32767L, ST.make(Blocks.iron_door, 1L, 0L));
        this.mMappings.put(Items.wooden_door, 32767L, ST.make(Blocks.wooden_door, 1L, 0L));
        this.mMappings.put(Items.ender_pearl, 32767L, ST.make((Block)Blocks.portal, 1L, 0L));
        this.mMappings.put(Items.ender_eye, 32767L, ST.make(Blocks.end_portal_frame, 1L, 0L));
        this.mMappings.put(Items.water_bucket, 32767L, ST.make(Blocks.water, 1L, 0L));
        this.mMappings.put(Items.lava_bucket, 32767L, ST.make(Blocks.lava, 1L, 0L));
        this.mMappings.put(Items.cauldron, 32767L, ST.make((Block)Blocks.cauldron, 1L, 0L));
        this.mMappings.put(Items.brewing_stand, 32767L, ST.make(Blocks.brewing_stand, 1L, 0L));
        this.mMappings.put(Items.flower_pot, 32767L, ST.make(Blocks.flower_pot, 1L, 0L));
    }

    @Override
    public Recipe findRecipe(IHasWorldAndCoords aTileEntity, Recipe aRecipe, boolean aNotUnificated, long aSize, ItemStack aSpecialSlot, FluidStack[] aFluids, ItemStack ... aInputs) {
        Recipe rRecipe = super.findRecipe(aTileEntity, aRecipe, aNotUnificated, aSize, aSpecialSlot, aFluids, aInputs);
        if (aInputs == null || aInputs.length < 2 || aInputs[0] == null || aInputs[1] == null || CS.GAPI_POST.mFinishedServerStarted <= 0) {
            return rRecipe;
        }
        if (rRecipe == null) {
            ItemStack tUSB = null;
            ItemStack tScanned = null;
            for (ItemStack aInput : aInputs) {
                Block tBlock;
                if (!ST.valid(aInput)) continue;
                if (ST.invalid(tUSB) && OM.is_(CS.OD_USB_STICKS[1], aInput)) {
                    tUSB = aInput;
                } else {
                    tScanned = aInput;
                }
                if (!ST.valid(tUSB) || !ST.valid(tScanned)) continue;
                assert (tScanned != null);
                if (IL.Paper_Blueprint_Used.equal(tScanned, false, true)) {
                    ItemStack[] tCraftingRecipe = UT.NBT.getBlueprintCrafting(tScanned);
                    if (tCraftingRecipe != CS.ZL_IS) {
                        rRecipe = new Recipe(false, false, false, ST.array(ST.amount(1L, tScanned), ST.amount(1L, tUSB)), ST.array(ST.amount(1L, tUSB), ST.amount(1L, tScanned)), null, null, null, null, 64L, 16L, 0L);
                        if (!rRecipe.mOutputs[0].hasTagCompound()) {
                            rRecipe.mOutputs[0].setTagCompound(UT.NBT.make());
                        }
                        rRecipe.mOutputs[0].getTagCompound().setTag("gt.usb.data", (NBTBase)UT.NBT.setBlueprintCrafting(UT.NBT.make(), tCraftingRecipe));
                        rRecipe.mOutputs[0].getTagCompound().setByte("gt.usb.tier", (byte)1);
                        return rRecipe;
                    }
                    return rRecipe;
                }
                if (OM.is_("gt:canvas", tScanned)) {
                    if (tScanned.hasTagCompound() && tScanned.getTagCompound().hasKey("gt.canvas.block")) {
                        rRecipe = new Recipe(false, false, false, ST.array(ST.amount(1L, tScanned), ST.amount(1L, tUSB)), ST.array(ST.amount(1L, tUSB), ST.amount(1L, tScanned)), null, null, null, null, 64L, 16L, 0L);
                        if (!rRecipe.mOutputs[0].hasTagCompound()) {
                            rRecipe.mOutputs[0].setTagCompound(UT.NBT.make());
                        }
                        NBTTagCompound tNBT = UT.NBT.make();
                        tNBT.setInteger("gt.canvas.block", tScanned.getTagCompound().getInteger("gt.canvas.block"));
                        tNBT.setInteger("gt.canvas.meta", tScanned.getTagCompound().getInteger("gt.canvas.meta"));
                        rRecipe.mOutputs[0].getTagCompound().setTag("gt.usb.data", (NBTBase)tNBT);
                        rRecipe.mOutputs[0].getTagCompound().setByte("gt.usb.tier", (byte)1);
                        return rRecipe;
                    }
                    return rRecipe;
                }
                if ((tScanned.getItem() == CS.ItemsGT.BOOKS || OD.bookWritten.is_(tScanned) || IL.Paper_Printed_Pages.equal(tScanned, false, true) || IL.Paper_Printed_Pages_Many.equal(tScanned, false, true)) && UT.Code.stringValid(UT.NBT.getBookTitle(tScanned))) {
                    rRecipe = new Recipe(false, false, false, ST.array(ST.amount(1L, tScanned), ST.amount(1L, tUSB)), ST.array(ST.amount(1L, tUSB), ST.amount(1L, tScanned)), null, null, null, null, 512L, 16L, 0L);
                    if (!rRecipe.mOutputs[0].hasTagCompound()) {
                        rRecipe.mOutputs[0].setTagCompound(UT.NBT.make());
                    }
                    rRecipe.mOutputs[0].getTagCompound().setTag("gt.usb.data", tScanned.getTagCompound().copy());
                    rRecipe.mOutputs[0].getTagCompound().setByte("gt.usb.tier", (byte)1);
                    return rRecipe;
                }
                if (tScanned.getItem() == Items.filled_map) {
                    rRecipe = new Recipe(false, false, false, ST.array(ST.amount(1L, tScanned), ST.amount(1L, tUSB)), ST.array(ST.amount(1L, tUSB), ST.amount(1L, tScanned)), null, null, null, null, 64L, 16L, 0L);
                    if (!rRecipe.mOutputs[0].hasTagCompound()) {
                        rRecipe.mOutputs[0].setTagCompound(UT.NBT.make());
                    }
                    rRecipe.mOutputs[0].getTagCompound().setTag("gt.usb.data", (NBTBase)UT.NBT.setMapID(UT.NBT.make(), ST.meta_(tScanned)));
                    rRecipe.mOutputs[0].getTagCompound().setByte("gt.usb.tier", (byte)1);
                    return rRecipe;
                }
                if (IL.TF_Magic_Map.equal(tScanned, true, true)) {
                    rRecipe = new Recipe(false, false, false, ST.array(ST.amount(1L, tScanned), ST.amount(1L, tUSB)), ST.array(ST.amount(1L, tUSB), ST.amount(1L, tScanned)), null, null, null, null, 64L, 16L, 0L);
                    if (!rRecipe.mOutputs[0].hasTagCompound()) {
                        rRecipe.mOutputs[0].setTagCompound(UT.NBT.make());
                    }
                    rRecipe.mOutputs[0].getTagCompound().setTag("gt.usb.data", (NBTBase)UT.NBT.setMagicMapID(UT.NBT.make(), ST.meta_(tScanned)));
                    rRecipe.mOutputs[0].getTagCompound().setByte("gt.usb.tier", (byte)1);
                    return rRecipe;
                }
                if (IL.TF_Maze_Map.equal(tScanned, true, true)) {
                    rRecipe = new Recipe(false, false, false, ST.array(ST.amount(1L, tScanned), ST.amount(1L, tUSB)), ST.array(ST.amount(1L, tUSB), ST.amount(1L, tScanned)), null, null, null, null, 64L, 16L, 0L);
                    if (!rRecipe.mOutputs[0].hasTagCompound()) {
                        rRecipe.mOutputs[0].setTagCompound(UT.NBT.make());
                    }
                    rRecipe.mOutputs[0].getTagCompound().setTag("gt.usb.data", (NBTBase)UT.NBT.setMazeMapID(UT.NBT.make(), ST.meta_(tScanned)));
                    rRecipe.mOutputs[0].getTagCompound().setByte("gt.usb.tier", (byte)1);
                    return rRecipe;
                }
                if (IL.TF_Ore_Map.equal(tScanned, true, true)) {
                    rRecipe = new Recipe(false, false, false, ST.array(ST.amount(1L, tScanned), ST.amount(1L, tUSB)), ST.array(ST.amount(1L, tUSB), ST.amount(1L, tScanned)), null, null, null, null, 64L, 16L, 0L);
                    if (!rRecipe.mOutputs[0].hasTagCompound()) {
                        rRecipe.mOutputs[0].setTagCompound(UT.NBT.make());
                    }
                    rRecipe.mOutputs[0].getTagCompound().setTag("gt.usb.data", (NBTBase)UT.NBT.setOreMapID(UT.NBT.make(), ST.meta_(tScanned)));
                    rRecipe.mOutputs[0].getTagCompound().setByte("gt.usb.tier", (byte)1);
                    return rRecipe;
                }
                if (IL.GC_Schematic_1.equal(tScanned, true, true)) {
                    rRecipe = new Recipe(false, false, false, ST.array(ST.amount(1L, tScanned), ST.amount(1L, tUSB)), ST.array(ST.amount(1L, tUSB), ST.amount(1L, tScanned)), null, null, null, null, 1024L, 16L, 0L);
                    if (!rRecipe.mOutputs[0].hasTagCompound()) {
                        rRecipe.mOutputs[0].setTagCompound(UT.NBT.make());
                    }
                    rRecipe.mOutputs[0].getTagCompound().setTag("gt.usb.data", (NBTBase)UT.NBT.makeShort("gc_schematics_1", ST.meta_(tScanned)));
                    rRecipe.mOutputs[0].getTagCompound().setByte("gt.usb.tier", (byte)1);
                    return rRecipe;
                }
                if (IL.GC_Schematic_2.equal(tScanned, true, true)) {
                    rRecipe = new Recipe(false, false, false, ST.array(ST.amount(1L, tScanned), ST.amount(1L, tUSB)), ST.array(ST.amount(1L, tUSB), ST.amount(1L, tScanned)), null, null, null, null, 1024L, 16L, 0L);
                    if (!rRecipe.mOutputs[0].hasTagCompound()) {
                        rRecipe.mOutputs[0].setTagCompound(UT.NBT.make());
                    }
                    rRecipe.mOutputs[0].getTagCompound().setTag("gt.usb.data", (NBTBase)UT.NBT.makeShort("gc_schematics_2", ST.meta_(tScanned)));
                    rRecipe.mOutputs[0].getTagCompound().setByte("gt.usb.tier", (byte)1);
                    return rRecipe;
                }
                if (IL.GC_Schematic_3.equal(tScanned, true, true)) {
                    rRecipe = new Recipe(false, false, false, ST.array(ST.amount(1L, tScanned), ST.amount(1L, tUSB)), ST.array(ST.amount(1L, tUSB), ST.amount(1L, tScanned)), null, null, null, null, 1024L, 16L, 0L);
                    if (!rRecipe.mOutputs[0].hasTagCompound()) {
                        rRecipe.mOutputs[0].setTagCompound(UT.NBT.make());
                    }
                    rRecipe.mOutputs[0].getTagCompound().setTag("gt.usb.data", (NBTBase)UT.NBT.makeShort("gc_schematics_3", ST.meta_(tScanned)));
                    rRecipe.mOutputs[0].getTagCompound().setByte("gt.usb.tier", (byte)1);
                    return rRecipe;
                }
                if (IL.IE_Blueprint_Projectiles_Common.equal(tScanned, true, true)) {
                    rRecipe = new Recipe(false, false, false, ST.array(ST.amount(1L, tScanned), ST.amount(1L, tUSB)), ST.array(ST.amount(1L, tUSB), ST.amount(1L, tScanned)), null, null, null, null, 1024L, 16L, 0L);
                    if (!rRecipe.mOutputs[0].hasTagCompound()) {
                        rRecipe.mOutputs[0].setTagCompound(UT.NBT.make());
                    }
                    rRecipe.mOutputs[0].getTagCompound().setTag("gt.usb.data", (NBTBase)UT.NBT.makeShort("ie_blueprint", ST.meta_(tScanned)));
                    rRecipe.mOutputs[0].getTagCompound().setByte("gt.usb.tier", (byte)1);
                    return rRecipe;
                }
                ItemStack tMapping = this.mMappings.get(tScanned);
                if (tMapping == null) {
                    tMapping = this.mMappings.get(tScanned.getItem(), 32767L);
                }
                if ((tBlock = ST.block_(tMapping == null ? tScanned : tMapping)) != null && tBlock != CS.NB) {
                    rRecipe = new Recipe(false, false, false, ST.array(ST.amount(1L, tScanned), ST.amount(1L, tUSB)), ST.array(ST.amount(1L, tUSB), ST.amount(1L, tScanned)), null, null, null, null, 512L, 16L, 0L);
                    if (!rRecipe.mOutputs[0].hasTagCompound()) {
                        rRecipe.mOutputs[0].setTagCompound(UT.NBT.make());
                    }
                    NBTTagCompound tNBT = UT.NBT.make();
                    tNBT.setInteger("gt.canvas.block", Block.getIdFromBlock((Block)tBlock));
                    tNBT.setInteger("gt.canvas.meta", (int)ST.meta_(tScanned));
                    rRecipe.mOutputs[0].getTagCompound().setTag("gt.usb.data", (NBTBase)tNBT);
                    rRecipe.mOutputs[0].getTagCompound().setByte("gt.usb.tier", (byte)1);
                    return rRecipe;
                }
                return rRecipe;
            }
        }
        return rRecipe;
    }

    @Override
    public boolean containsInput(ItemStack aStack, IHasWorldAndCoords aTileEntity, ItemStack aSpecialSlot) {
        return true;
    }
}

