/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes.maps;

import gregapi.block.metatype.BlockStones;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.IL;
import gregapi.data.MD;
import gregapi.data.OD;
import gregapi.data.RM;
import gregapi.data.TD;
import gregapi.oredict.OreDictItemData;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.Recipe;
import gregapi.recipes.maps.RecipeMapNonGTRecipes;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class RecipeMapFurnace
extends RecipeMapNonGTRecipes {
    public RecipeMapFurnace(Collection<Recipe> aRecipeList, String aUnlocalizedName, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aInputFluidCount, long aOutputFluidCount, long aMinimalInputFluids, long aMinimalInputs, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed, boolean aConfigAllowed, boolean aNeedsOutputs, boolean aCombinePower, boolean aUseBucketSizeIn, boolean aUseBucketSizeOut) {
        super(aRecipeList, aUnlocalizedName, aNameLocal, aNameNEI, aProgressBarDirection, aProgressBarAmount, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, aInputFluidCount, aOutputFluidCount, aMinimalInputFluids, aMinimalInputs, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed, aConfigAllowed, aNeedsOutputs, aCombinePower, aUseBucketSizeIn, aUseBucketSizeOut);
    }

    @Override
    public Recipe findRecipe(IHasWorldAndCoords aTileEntity, Recipe aRecipe, boolean aNotUnificated, long aSize, ItemStack aSpecialSlot, FluidStack[] aFluids, ItemStack ... aInputs) {
        OreDictItemData tData;
        if (aInputs == null || aInputs.length <= 0 || aInputs[0] == null) {
            return null;
        }
        if (aRecipe != null && aRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) {
            return aRecipe;
        }
        ItemStack tOutput = RM.get_smelting(aInputs[0]);
        if (tOutput == null) {
            return null;
        }
        FluidStack tCookingOil = aFluids != null && aFluids.length > 0 && aFluids[0] != null && CS.FluidsGT.COOKING_OIL.contains(aFluids[0].getFluid().getName()) ? aFluids[0] : CS.NF;
        FluidStack rXP = CS.NF;
        if (FL.valid(tCookingOil) && tCookingOil.amount >= 50 && !OD.listAllmeatsubstitute.is(aInputs[0]) && !OD.listAllmeatsubstitute.is(tOutput) && (OD.listAllmeatraw.is(aInputs[0]) || OD.listAllmeatcooked.is(tOutput))) {
            ++tOutput.stackSize;
            tCookingOil = FL.amount(tCookingOil, 50L);
        } else {
            tCookingOil = CS.NF;
        }
        if (FL.XP.exists() && !OM.prefixcontainsany(tData = OM.anydata_(aInputs[0]), TD.Prefix.DUST_BASED, TD.Prefix.INGOT_BASED, TD.Prefix.GEM_BASED)) {
            if (tOutput.getItem() == Items.brick || tOutput.getItem() == Items.netherbrick || tOutput.getItem() == Items.clay_ball || tOutput.getItem() == Items.dye) {
                rXP = FL.XP.make(tOutput.stackSize);
            } else if (tOutput.getItem() == Items.coal) {
                rXP = FL.XP.make((long)tOutput.stackSize * 2L);
            } else if (IL.EtFu_Chorus_Popped.equal(tOutput)) {
                rXP = FL.XP.make((long)tOutput.stackSize * 4L);
            } else if (IL.ERE_Pot_Cooked.equal(tOutput)) {
                rXP = FL.XP.make((long)tOutput.stackSize * 20L);
            } else if (OD.blockGlass.is(tOutput) || OD.paneGlass.is(tOutput)) {
                rXP = FL.XP.make(tOutput.stackSize);
            } else {
                Block tBlock = ST.block(tOutput);
                if (tBlock != Blocks.cobblestone && tBlock != Blocks.stone && tBlock != Blocks.stonebrick && !(tBlock instanceof BlockStones)) {
                    if (tBlock == Blocks.hardened_clay || tBlock == Blocks.stained_hardened_clay) {
                        rXP = FL.XP.make((long)tOutput.stackSize * 2L);
                    } else if (tBlock == Blocks.brick_block || tBlock == Blocks.nether_brick) {
                        rXP = FL.XP.make((long)tOutput.stackSize * 3L);
                    } else if (ST.food(tOutput) > 0) {
                        rXP = FL.XP.make(tOutput.stackSize);
                    } else if (tData != null && tData.validData()) {
                        if (tData.mPrefix.containsAny(TD.Prefix.ORE, TD.Prefix.ORE_PROCESSING_BASED)) {
                            tData = OM.anydata_(tOutput);
                            if (tData != null && tData.validData()) {
                                long tXP = (long)tOutput.stackSize * (3L + (long)tData.mMaterial.mMaterial.mToolQuality);
                                if (tData.mMaterial.mMaterial.contains(TD.Properties.VALUABLE)) {
                                    tXP *= 2L;
                                }
                                if (tData.mMaterial.mMaterial.contains(TD.Properties.MAGICAL)) {
                                    tXP *= 2L;
                                }
                                rXP = tData.mPrefix.mAmount > 0L ? FL.XP.make(UT.Code.divup(tData.mPrefix.mAmount * tXP, 648648000L)) : FL.XP.make(tXP);
                            } else {
                                rXP = FL.XP.make((long)tOutput.stackSize * 5L);
                            }
                        }
                    } else if (MD.RoC.owns(aInputs[0], "extracts")) {
                        tData = OM.anydata_(tOutput);
                        if (tData != null && tData.validData()) {
                            long tXP = (long)tOutput.stackSize * (3L + (long)tData.mMaterial.mMaterial.mToolQuality);
                            if (tData.mMaterial.mMaterial.contains(TD.Properties.VALUABLE)) {
                                tXP *= 2L;
                            }
                            if (tData.mMaterial.mMaterial.contains(TD.Properties.MAGICAL)) {
                                tXP *= 2L;
                            }
                            rXP = tData.mPrefix.mAmount > 0L ? FL.XP.make(UT.Code.divup(tData.mPrefix.mAmount * tXP, 648648000L)) : FL.XP.make(tXP);
                        } else {
                            rXP = FL.XP.make((long)tOutput.stackSize * 5L);
                        }
                    } else {
                        rXP = FL.XP.make(UT.Code.bind(1L, (long)tOutput.stackSize * 20L, UT.Code.roundUp((float)(tOutput.stackSize * 20) * FurnaceRecipes.smelting().func_151398_b(tOutput))));
                    }
                }
            }
        }
        return new Recipe(false, false, false, ST.array(ST.amount(1L, aInputs[0])), ST.array(tOutput), null, null, tCookingOil != null && tCookingOil.amount > 0 ? FL.array(tCookingOil) : CS.ZL_FS, rXP != null && rXP.amount > 0 ? FL.array(rXP) : CS.ZL_FS, 16L, 16L, 0L);
    }

    @Override
    public boolean containsInput(ItemStack aStack, IHasWorldAndCoords aTileEntity, ItemStack aSpecialSlot) {
        return ST.valid(RM.get_smelting(aStack));
    }

    @Override
    public boolean containsInput(FluidStack aFluid, IHasWorldAndCoords aTileEntity, ItemStack aSpecialSlot) {
        return CS.FluidsGT.COOKING_OIL.contains(aFluid.getFluid().getName());
    }

    @Override
    public boolean containsInput(Fluid aFluid, IHasWorldAndCoords aTileEntity, ItemStack aSpecialSlot) {
        return CS.FluidsGT.COOKING_OIL.contains(aFluid.getName());
    }
}

