/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes;

import gregapi.code.TagData;
import gregapi.item.IItemEnergy;
import gregapi.item.IItemGTContainerTool;
import gregapi.item.multiitem.MultiItemTool;
import gregapi.recipes.ICraftingRecipeGT;
import gregapi.util.ST;
import gregapi.util.UT;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class AdvancedCraftingShapeless
extends ShapelessOreRecipe
implements ICraftingRecipeGT {
    public final boolean mDismantleable;
    public final boolean mRemovableByGT;
    public final boolean mAutoCraftable;
    public final boolean mKeepingNBT;
    private final Enchantment[] mEnchantmentsAdded;
    private final int[] mEnchantmentLevelsAdded;

    public AdvancedCraftingShapeless(ItemStack aResult, boolean aDismantleAble, boolean aRemovableByGT, boolean aKeepingNBT, boolean aAutoCraftable, Enchantment[] aEnchantmentsAdded, int[] aEnchantmentLevelsAdded, Object ... aRecipe) {
        super(aResult, aRecipe);
        this.mEnchantmentsAdded = aEnchantmentsAdded;
        this.mEnchantmentLevelsAdded = aEnchantmentLevelsAdded;
        this.mRemovableByGT = aRemovableByGT;
        this.mKeepingNBT = aKeepingNBT;
        this.mDismantleable = aDismantleAble;
        this.mAutoCraftable = aAutoCraftable;
    }

    public boolean matches(InventoryCrafting aGrid, World aWorld) {
        if (this.mKeepingNBT) {
            ItemStack tStack = null;
            ItemStack tMainInput = this.getInput().get(0) instanceof ItemStack ? (ItemStack)this.getInput().get(0) : null;
            for (int i = 0; i < aGrid.getSizeInventory(); ++i) {
                if (aGrid.getStackInSlot(i) == null) continue;
                if (tMainInput == null) {
                    if (!(this.getInput().get(0) instanceof Iterable)) continue;
                    for (Object tObject : (Iterable)this.getInput().get(0)) {
                        if (!(tObject instanceof ItemStack) || !ST.equal(aGrid.getStackInSlot(i), (ItemStack)tObject, true)) continue;
                        tMainInput = ST.amount(1L, aGrid.getStackInSlot(i));
                    }
                    continue;
                }
                if (!ST.equal_(aGrid.getStackInSlot(i), tMainInput, true)) continue;
                if (tStack != null && !ST.equal_(tStack, aGrid.getStackInSlot(i), false)) {
                    return false;
                }
                tStack = aGrid.getStackInSlot(i);
            }
        }
        return super.matches(aGrid, aWorld);
    }

    public ItemStack getCraftingResult(InventoryCrafting aGrid) {
        ItemStack rStack = super.getCraftingResult(aGrid);
        if (rStack != null) {
            ST.update(rStack);
            if (this.mKeepingNBT) {
                ItemStack tMainInput = this.getInput().get(0) instanceof ItemStack ? (ItemStack)this.getInput().get(0) : null;
                for (int i = 0; i < aGrid.getSizeInventory(); ++i) {
                    if (aGrid.getStackInSlot(i) == null || !aGrid.getStackInSlot(i).hasTagCompound() || tMainInput != null && !ST.equal_(aGrid.getStackInSlot(i), tMainInput, true)) continue;
                    UT.NBT.set(rStack, (NBTTagCompound)aGrid.getStackInSlot(i).getTagCompound().copy());
                    break;
                }
            }
            if (rStack.getItem() instanceof IItemEnergy) {
                for (TagData tEnergyType : ((IItemEnergy)rStack.getItem()).getEnergyTypes(rStack)) {
                    long tCharge = 0L;
                    for (int i = 0; i < aGrid.getSizeInventory(); ++i) {
                        if (aGrid.getStackInSlot(i) == null || !(aGrid.getStackInSlot(i).getItem() instanceof IItemEnergy) || aGrid.getStackInSlot(i).getItem() instanceof IItemGTContainerTool) continue;
                        tCharge += ((IItemEnergy)aGrid.getStackInSlot(i).getItem()).getEnergyStored(tEnergyType, aGrid.getStackInSlot(i));
                    }
                    ((IItemEnergy)rStack.getItem()).setEnergyStored(tEnergyType, rStack, tCharge);
                }
            }
            if (this.mDismantleable) {
                NBTTagCompound rNBT = rStack.getTagCompound();
                NBTTagCompound tNBT = UT.NBT.make();
                if (rNBT == null) {
                    rNBT = UT.NBT.make();
                }
                for (int i = 0; i < 9; ++i) {
                    ItemStack tStack = aGrid.getStackInSlot(i);
                    if (tStack == null || ST.container(tStack, true) != null || tStack.getItem() instanceof MultiItemTool) continue;
                    tStack = ST.amount(1L, tStack);
                    tNBT.setTag("" + i, (NBTBase)ST.save(tStack));
                }
                rNBT.setTag("gt.recycling.comps", (NBTBase)tNBT);
                UT.NBT.set(rStack, rNBT);
            }
            for (int i = 0; i < this.mEnchantmentsAdded.length; ++i) {
                UT.NBT.addEnchantment(rStack, this.mEnchantmentsAdded[i], UT.NBT.getEnchantmentLevel(this.mEnchantmentsAdded[i], rStack) + this.mEnchantmentLevelsAdded[i]);
            }
            ST.update(rStack);
        }
        return rStack;
    }

    @Override
    public boolean isRemovableByGT() {
        return this.mRemovableByGT;
    }

    @Override
    public boolean isAutocraftableByGT() {
        return this.mAutoCraftable;
    }
}

