/*
 * Decompiled with CFR 0.152.
 */
package gregapi.oredict.listeners;

import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.lang.LanguageHandler;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictPrefix;
import gregapi.oredict.listeners.IOreDictListenerItem;
import gregapi.util.ST;
import gregapi.util.UT;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;

public class OreDictListenerItem_Washing
extends IOreDictListenerItem.OreDictListenerItem {
    private final OreDictPrefix mItemToGet;
    private final OreDictPrefix[] mByProductPrefixes;
    private final int mChance;

    public OreDictListenerItem_Washing(OreDictPrefix aItemToGet, int aChance, OreDictPrefix ... aByProductPrefixes) {
        LH.add("gt.behaviour.washing", "Throw into Cauldron to clean this Item");
        this.mByProductPrefixes = aByProductPrefixes;
        this.mItemToGet = aItemToGet;
        this.mChance = aChance;
    }

    @Override
    public ItemStack onTickWorld(OreDictPrefix aPrefix, OreDictMaterial aMaterial, ItemStack aStack, EntityItem aItem) {
        if (aMaterial != null) {
            ItemStack tStack;
            int tX = UT.Code.roundDown(aItem.posX);
            int tY = UT.Code.roundDown(aItem.posY - 0.25);
            int tZ = UT.Code.roundDown(aItem.posZ);
            Block tBlock = aItem.worldObj.getBlock(tX, tY, tZ);
            byte tMetaData = (byte)aItem.worldObj.getBlockMetadata(tX, tY, tZ);
            if (tBlock instanceof BlockCauldron && tMetaData > 0 && (tStack = this.mItemToGet.mat(aMaterial, 1L)) != null) {
                ((BlockCauldron)tBlock).func_150024_a(aItem.worldObj, tX, tY, tZ, tMetaData - 1);
                if (this.mByProductPrefixes.length > 0 && CS.RNGSUS.nextInt(this.mChance) > 0) {
                    ArrayListNoNulls<ItemStack> tStacks = ST.arraylist(new ItemStack[0]);
                    for (OreDictPrefix tPrefix : this.mByProductPrefixes) {
                        tStacks.add(tPrefix.mat(UT.Code.select(aMaterial, aMaterial.mByProducts), 1L));
                    }
                    if (tStacks.size() > 0) {
                        ST.drop(aItem.worldObj, aItem.posX, aItem.posY, aItem.posZ, (ItemStack)tStacks.get(CS.RNGSUS.nextInt(tStacks.size())));
                    }
                }
                ST.drop(aItem.worldObj, aItem.posX, aItem.posY, aItem.posZ, tStack);
                aItem.motionZ = 0.0;
                aItem.motionY = 0.0;
                aItem.motionX = 0.0;
                aItem.setPosition((double)tX + 0.5, (double)tY + 0.9, (double)tZ + 0.5);
                return aStack.stackSize > 1 ? ST.amount(aStack.stackSize - 1, aStack) : null;
            }
        }
        return aStack;
    }

    @Override
    public String getListenerToolTip(OreDictPrefix aPrefix, OreDictMaterial aMaterial, ItemStack aStack) {
        return LanguageHandler.translate("gt.behaviour.washing", "Throw into Cauldron to clean this Item");
    }
}

