/*
 * Decompiled with CFR 0.152.
 */
package gregapi.network.packets.data;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import gregapi.block.IBlockSyncData;
import gregapi.network.INetworkHandler;
import gregapi.network.packets.PacketCoordinates;
import net.minecraft.block.Block;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;

public class PacketSyncDataLong
extends PacketCoordinates {
    public long mData = 0L;

    public PacketSyncDataLong(int aDecoderType) {
        super(aDecoderType);
    }

    public PacketSyncDataLong(int aX, int aY, int aZ, long aData) {
        super(aX, aY, aZ);
        this.mData = aData;
    }

    public PacketSyncDataLong(ChunkCoordinates aCoords, long aData) {
        super(aCoords);
        this.mData = aData;
    }

    @Override
    public byte getPacketIDOffset() {
        return -112;
    }

    @Override
    public ByteArrayDataOutput encode2(ByteArrayDataOutput aData) {
        aData.writeLong(this.mData);
        return aData;
    }

    @Override
    public PacketCoordinates decode2(int aX, int aY, int aZ, ByteArrayDataInput aData) {
        return new PacketSyncDataLong(aX, aY, aZ, aData.readLong());
    }

    @Override
    public void process(IBlockAccess aWorld, INetworkHandler aNetworkHandler) {
        Block tBlock;
        if (aWorld != null && (tBlock = aWorld.getBlock(this.mX, this.mY, this.mZ)) instanceof IBlockSyncData) {
            ((IBlockSyncData)tBlock).receiveDataLong(aWorld, this.mX, this.mY, this.mZ, this.mData, aNetworkHandler);
        }
    }
}

