/*
 * Decompiled with CFR 0.152.
 */
package gregapi.network.packets;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import gregapi.network.IPacket;
import gregapi.util.UT;
import net.minecraft.util.ChunkCoordinates;

public abstract class PacketCoordinates
implements IPacket {
    public final int mX;
    public final int mY;
    public final int mZ;
    private byte mDecoderType = 0;

    public PacketCoordinates(int aDecoderType) {
        this.mDecoderType = (byte)(aDecoderType & 7);
        this.mZ = 0;
        this.mY = 0;
        this.mX = 0;
    }

    public PacketCoordinates(int aX, int aY, int aZ) {
        this.mX = aX;
        this.mY = aY;
        this.mZ = aZ;
        this.mDecoderType = (byte)((this.mX >= Short.MIN_VALUE && this.mX <= Short.MAX_VALUE ? 1 : 0) | (this.mY >= 0 && this.mY <= 255 ? 2 : 0) | (this.mZ >= Short.MIN_VALUE && this.mZ <= Short.MAX_VALUE ? 4 : 0));
    }

    public PacketCoordinates(ChunkCoordinates aCoords) {
        this.mX = aCoords.posX;
        this.mY = aCoords.posY;
        this.mZ = aCoords.posZ;
        this.mDecoderType = (byte)((this.mX >= Short.MIN_VALUE && this.mX <= Short.MAX_VALUE ? 1 : 0) | (this.mY >= 0 && this.mY <= 255 ? 2 : 0) | (this.mZ >= Short.MIN_VALUE && this.mZ <= Short.MAX_VALUE ? 4 : 0));
    }

    @Override
    public final byte getPacketID() {
        return (byte)(this.getPacketIDOffset() + this.mDecoderType);
    }

    @Override
    public final ByteArrayDataOutput encode() {
        ByteArrayDataOutput rOut = ByteStreams.newDataOutput((int)8);
        if ((this.mDecoderType & 1) != 0) {
            rOut.writeShort(this.mX);
        } else {
            rOut.writeInt(this.mX);
        }
        if ((this.mDecoderType & 2) != 0) {
            rOut.writeByte(this.mY);
        } else {
            rOut.writeShort(this.mY);
        }
        if ((this.mDecoderType & 4) != 0) {
            rOut.writeShort(this.mZ);
        } else {
            rOut.writeInt(this.mZ);
        }
        return this.encode2(rOut);
    }

    @Override
    public final IPacket decode(ByteArrayDataInput aData) {
        return this.decode2((this.mDecoderType & 1) != 0 ? aData.readShort() : aData.readInt(), (this.mDecoderType & 2) != 0 ? UT.Code.unsignB(aData.readByte()) : aData.readShort(), (this.mDecoderType & 4) != 0 ? aData.readShort() : aData.readInt(), aData);
    }

    public abstract byte getPacketIDOffset();

    public abstract ByteArrayDataOutput encode2(ByteArrayDataOutput var1);

    public abstract PacketCoordinates decode2(int var1, int var2, int var3, ByteArrayDataInput var4);
}

