/*
 * Decompiled with CFR 0.152.
 */
package gregapi.item.multiitem.behaviors;

import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.MD;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import iguanaman.hungeroverhaul.config.IguanaConfig;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public class Behavior_Bucket_Simple
extends IBehavior.AbstractBehaviorDefault {
    public static final IBehavior<MultiItem> INSTANCE = new Behavior_Bucket_Simple(CS.NI);
    public ItemStack mDefaultFullBucket;

    public Behavior_Bucket_Simple(ItemStack aDefault) {
        this.mDefaultFullBucket = aDefault;
    }

    @Override
    public boolean canDispense(MultiItem aItem, IBlockSource aSource, ItemStack aStack) {
        return true;
    }

    @Override
    public ItemStack onDispense(MultiItem aItem, IBlockSource aSource, ItemStack aStack) {
        if (aStack.stackSize > 1) {
            return super.onDispense(aItem, aSource, aStack);
        }
        FluidStack mFluid = FL.getFluid(aStack, true);
        ItemStack tBucket = ST.make(Items.bucket, 1L, 0L);
        EnumFacing aFacing = BlockDispenser.func_149937_b((int)aSource.getBlockMetadata());
        World aWorld = aSource.getWorld();
        int aX = aSource.getXInt() + aFacing.getFrontOffsetX();
        int aY = aSource.getYInt() + aFacing.getFrontOffsetY();
        int aZ = aSource.getZInt() + aFacing.getFrontOffsetZ();
        if (mFluid == null) {
            FluidStack tFluid;
            Block tFluidBlock = aWorld.getBlock(aX, aY, aZ);
            if (tFluidBlock == CS.BlocksGT.River) {
                tBucket = FL.fill(FL.Water.make(1000L), aStack, false, true, false, true);
                return tBucket == null ? aStack : tBucket;
            }
            if (tFluidBlock == CS.BlocksGT.Ocean) {
                tBucket = FL.fill(FL.Ocean.make(1000L), aStack, false, true, false, true);
                return tBucket == null ? aStack : tBucket;
            }
            if (tFluidBlock == CS.BlocksGT.Swamp) {
                tBucket = FL.fill(FL.Dirty_Water.make(1000L), aStack, false, true, false, true);
                return tBucket == null ? aStack : tBucket;
            }
            if (tFluidBlock == Blocks.lava || tFluidBlock == Blocks.flowing_lava) {
                if (aWorld.getBlockMetadata(aX, aY, aZ) != 0) {
                    return super.onDispense(aItem, aSource, aStack);
                }
                tBucket = FL.fill(FL.Lava.make(1000L), aStack, false, true, false, true);
                return tBucket == null ? aStack : (aWorld.setBlockToAir(aX, aY, aZ) ? tBucket : aStack);
            }
            if (tFluidBlock == Blocks.water || tFluidBlock == Blocks.flowing_water) {
                if (aWorld.getBlockMetadata(aX, aY, aZ) != 0) {
                    return super.onDispense(aItem, aSource, aStack);
                }
                tBucket = FL.fill(FL.Water.make(1000L), aStack, false, true, false, true);
                return tBucket == null ? aStack : (aWorld.setBlockToAir(aX, aY, aZ) ? tBucket : aStack);
            }
            if (tFluidBlock instanceof IFluidBlock && (tFluid = ((IFluidBlock)tFluidBlock).drain(aWorld, aX, aY, aZ, false)) != null) {
                tBucket = FL.fill(tFluid, aStack, false, true, false, true);
                if (ST.valid(tBucket)) {
                    ((IFluidBlock)tFluidBlock).drain(aWorld, aX, aY, aZ, true);
                    return tBucket == null ? aStack : tBucket;
                }
                return super.onDispense(aItem, aSource, aStack);
            }
        } else {
            if (ST.valid(this.mDefaultFullBucket)) {
                tBucket = ST.copy(this.mDefaultFullBucket);
            } else if (ST.invalid(tBucket = FL.fill(mFluid, tBucket, false, true, false, true))) {
                return super.onDispense(aItem, aSource, aStack);
            }
            if (ST.item_(tBucket) instanceof ItemBucket && ((ItemBucket)ST.item_(tBucket)).tryPlaceContainedLiquid(aWorld, aX, aY, aZ)) {
                return this.processBucket(ST.make(Items.bucket, 1L, 0L), aStack, true);
            }
        }
        return super.onDispense(aItem, aSource, aStack);
    }

    @Override
    public ItemStack onItemRightClick(MultiItem aItem, ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        FluidStack mFluid = FL.getFluid(aStack, true);
        MovingObjectPosition aTarget = WD.getMOP(aWorld, aPlayer, mFluid == null);
        if (aTarget == null || aTarget.typeOfHit != MovingObjectPosition.MovingObjectType.BLOCK) {
            return aStack;
        }
        int aX = aTarget.blockX;
        int aY = aTarget.blockY;
        int aZ = aTarget.blockZ;
        ItemStack tBucket = ST.make(Items.bucket, 1L, 0L);
        if (mFluid == null) {
            FluidStack tFluid;
            Block tFluidBlock = aWorld.getBlock(aX, aY, aZ);
            if (tFluidBlock == CS.BlocksGT.River) {
                tBucket = FL.fill(FL.Water.make(1000L), aStack, false, true, false, true);
                return tBucket == null ? aStack : tBucket;
            }
            if (tFluidBlock == CS.BlocksGT.Ocean) {
                tBucket = FL.fill(FL.Ocean.make(1000L), aStack, false, true, false, true);
                return tBucket == null ? aStack : tBucket;
            }
            if (tFluidBlock == CS.BlocksGT.Swamp) {
                tBucket = FL.fill(FL.Dirty_Water.make(1000L), aStack, false, true, false, true);
                return tBucket == null ? aStack : tBucket;
            }
            if (tFluidBlock == Blocks.lava || tFluidBlock == Blocks.flowing_lava || tFluidBlock == Blocks.water || tFluidBlock == Blocks.flowing_water) {
                if (aWorld.getBlockMetadata(aX, aY, aZ) == 0) {
                    tBucket = tBucket.getItem().onItemRightClick(tBucket, aWorld, aPlayer);
                }
            } else if (tFluidBlock instanceof IFluidBlock && (tFluid = ((IFluidBlock)tFluidBlock).drain(aWorld, aX, aY, aZ, false)) != null) {
                if (ST.valid(FL.fill(tFluid, aStack, false, true, false, true))) {
                    tBucket = tBucket.getItem().onItemRightClick(tBucket, aWorld, aPlayer);
                }
                if (FL.milk(tFluid) && tFluid.amount >= 1000) {
                    tBucket = ST.make(Items.milk_bucket, 1L, 0L);
                }
            }
        } else if (ST.valid(this.mDefaultFullBucket)) {
            tBucket = ST.copy(this.mDefaultFullBucket);
            tBucket = tBucket.getItem().onItemRightClick(tBucket, aWorld, aPlayer);
        } else {
            if (ST.invalid(tBucket = FL.fill(mFluid, tBucket, false, true, false, true))) {
                return aStack;
            }
            tBucket = tBucket.getItem().onItemRightClick(tBucket, aWorld, aPlayer);
        }
        aPlayer.clearItemInUse();
        return this.processBucket(tBucket, aStack, mFluid != null);
    }

    @Override
    public boolean onRightClickEntity(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, Entity aEntity) {
        if (FL.getFluid(aStack, true) == null && aEntity instanceof EntityLivingBase && !((EntityLivingBase)aEntity).isChild()) {
            if (aPlayer.worldObj.isRemote) {
                return true;
            }
            if (aEntity.getClass() == EntityCow.class || aEntity.getClass() == EntityMooshroom.class) {
                if (MD.HO.mLoaded && IguanaConfig.milkedTimeout > 0 && !UT.Entities.hasInfiniteItems(aPlayer)) {
                    NBTTagCompound tNBT = aEntity.getEntityData();
                    if (tNBT.hasKey("Milked")) {
                        return true;
                    }
                    tNBT.setInteger("Milked", IguanaConfig.milkedTimeout * 60);
                }
                ST.set(aStack, FL.fill(FL.Milk.make(Integer.MAX_VALUE), aStack, false, true, true, true));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onItemUseFirst(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float hitX, float hitY, float hitZ) {
        Block aBlock;
        if (aPlayer.worldObj.isRemote) {
            return false;
        }
        FluidStack mFluid = FL.getFluid(aStack, true);
        if (mFluid == null) {
            return false;
        }
        if (FL.water(mFluid) && mFluid.amount >= 1000 && (aBlock = aWorld.getBlock(aX, aY, aZ)) instanceof BlockCauldron) {
            if (aWorld.getBlockMetadata(aX, aY, aZ) < 3) {
                ((BlockCauldron)aBlock).func_150024_a(aWorld, aX, aY, aZ, 3);
                ST.set(aStack, ST.container(aStack, true));
                return true;
            }
            return false;
        }
        return false;
    }

    protected ItemStack processBucket(ItemStack aBucket, ItemStack aStack, boolean aWasFull) {
        if (aBucket == null) {
            return aStack;
        }
        if (aWasFull) {
            if (aBucket.getItem() == Items.bucket) {
                aBucket = ST.container(aStack, false);
                if (aBucket == null) {
                    aStack.stackSize = 0;
                } else {
                    aStack = aBucket;
                }
                return aStack;
            }
        } else {
            FluidStack tFluid = FL.getFluid(aBucket, true);
            if (tFluid != null) {
                aBucket = FL.fill(tFluid, aStack, false, true, false, true);
                if (aBucket == null) {
                    aStack.stackSize = 0;
                } else {
                    aStack = aBucket;
                }
                return aStack;
            }
        }
        return aStack;
    }
}

